/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.scoping.batch.AbstractSessionBasedExecutableScope;
import org.eclipse.xtext.xbase.scoping.batch.AbstractSessionBasedScope;
import org.eclipse.xtext.xbase.scoping.batch.BucketedEObjectDescription;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.TypeBucket;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStaticImportsScope
extends AbstractSessionBasedExecutableScope {
    public AbstractStaticImportsScope(IScope parent, IFeatureScopeSession session, XAbstractFeatureCall context, OperatorMapping operatorMapping) {
        super(parent, session, context, operatorMapping);
    }

    @Override
    protected Iterable<IEObjectDescription> getAllLocalElements() {
        List<TypeBucket> buckets = this.getBuckets();
        if (buckets.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (TypeBucket bucket : buckets) {
            if (bucket.isRestrictingNames()) {
                for (Map.Entry entry : bucket.getTypesToNames().entrySet()) {
                    JvmType type = (JvmType)entry.getKey();
                    if (!(type instanceof JvmDeclaredType)) continue;
                    Iterable features = ((JvmDeclaredType)type).getAllFeatures();
                    for (JvmFeature feature : features) {
                        if (!feature.isStatic() || !((Set)entry.getValue()).contains(feature.getSimpleName())) continue;
                        this.addDescriptions(feature, bucket, result);
                    }
                }
                continue;
            }
            for (JvmType jvmType : bucket.getTypes()) {
                if (!(jvmType instanceof JvmDeclaredType)) continue;
                Iterable features = ((JvmDeclaredType)jvmType).getAllFeatures();
                for (JvmFeature feature : features) {
                    if (!feature.isStatic()) continue;
                    this.addDescriptions(feature, bucket, result);
                }
            }
        }
        return result;
    }

    protected void addDescriptions(JvmFeature feature, TypeBucket bucket, List<IEObjectDescription> result) {
        String simpleName = feature.getSimpleName();
        BucketedEObjectDescription description = this.createDescription(QualifiedName.create((String)simpleName), feature, bucket);
        if (description != null) {
            result.add(description);
            String propertyName = this.toProperty(simpleName, feature);
            if (propertyName != null) {
                result.add(this.createDescription(QualifiedName.create((String)propertyName), feature, bucket));
            }
        }
    }

    protected abstract List<TypeBucket> getBuckets();

    @Override
    protected Collection<IEObjectDescription> getLocalElementsByName(final QualifiedName name) {
        final List<TypeBucket> buckets = this.getBuckets();
        if (buckets.isEmpty()) {
            return Collections.emptyList();
        }
        final ArrayList result = Lists.newArrayList();
        this.processFeatureNames(name, new AbstractSessionBasedScope.NameAcceptor(){

            public void accept(String simpleName, int order) {
                for (TypeBucket bucket : buckets) {
                    if (bucket.isRestrictingNames()) {
                        for (Map.Entry entry : bucket.getTypesToNames().entrySet()) {
                            if (!((Set)entry.getValue()).contains(simpleName)) continue;
                            this.processType((JvmType)entry.getKey(), simpleName, order, bucket);
                        }
                        continue;
                    }
                    for (JvmType jvmType : bucket.getTypes()) {
                        this.processType(jvmType, simpleName, order, bucket);
                    }
                }
            }

            protected void processType(JvmType type, String simpleName, int order, TypeBucket bucket) {
                if (type instanceof JvmDeclaredType) {
                    Iterable<JvmFeature> features = AbstractStaticImportsScope.this.findAllFeaturesByName(type, simpleName, bucket.getResolvedFeaturesProvider());
                    for (JvmFeature feature : features) {
                        BucketedEObjectDescription description;
                        if (!feature.isStatic() || order != 1 && !(feature instanceof JvmOperation) || (description = AbstractStaticImportsScope.this.createDescription(name, feature, bucket)) == null) continue;
                        result.add(description);
                    }
                }
            }
        });
        return result;
    }

    protected abstract BucketedEObjectDescription createDescription(QualifiedName var1, JvmFeature var2, TypeBucket var3);
}

