/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.validation.IssueSeverities;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.computation.IConstructorLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.IFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ILinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.internal.IFeatureScopeTracker;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.TypeData;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentSource;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackedResolvedTypes
extends ResolvedTypes {
    private final ResolvedTypes parent;

    protected StackedResolvedTypes(ResolvedTypes parent) {
        super(parent.getResolver());
        this.parent = parent;
    }

    protected ResolvedTypes getParent() {
        return this.parent;
    }

    protected void mergeIntoParent() {
        this.prepareMergeIntoParent();
        this.performMergeIntoParent();
    }

    protected void prepareMergeIntoParent() {
    }

    protected void performMergeIntoParent() {
        ResolvedTypes parent = this.getParent();
        this.mergeInto(parent);
        this.clear();
    }

    protected void mergeInto(ResolvedTypes parent) {
        this.mergeTypeParametersIntoParent(parent);
        this.mergeExpressionTypesIntoParent(parent);
        this.mergeTypesIntoParent(parent);
        this.mergeLinkingCandidatesIntoParent(parent);
        this.mergeQueuedDiagnostics(parent);
        this.mergePropagatedTypes(parent);
        this.mergeRefinedTypes(parent);
    }

    protected void mergePropagatedTypes(ResolvedTypes parent) {
        for (XExpression expression : this.basicGetPropagatedTypes()) {
            parent.setPropagatedType(expression);
        }
    }

    protected void mergeRefinedTypes(ResolvedTypes parent) {
        for (XExpression expression : this.basicGetRefinedTypes()) {
            parent.setRefinedType(expression);
        }
    }

    @Override
    protected boolean isPropagatedType(XExpression expression) {
        if (super.isPropagatedType(expression)) {
            return true;
        }
        return this.parent.isPropagatedType(expression);
    }

    @Override
    public boolean isRefinedType(XExpression expression) {
        if (super.isRefinedType(expression)) {
            return true;
        }
        return this.parent.isRefinedType(expression);
    }

    protected void mergeQueuedDiagnostics(ResolvedTypes parent) {
        Collection<AbstractDiagnostic> diagnostics = super.getQueuedDiagnostics();
        for (AbstractDiagnostic diagnostic : diagnostics) {
            parent.addDiagnostic(diagnostic);
        }
    }

    protected void mergeExpressionTypesIntoParent(ResolvedTypes parent) {
        for (Map.Entry<XExpression, List<TypeData>> entry : this.basicGetExpressionTypes().entrySet()) {
            for (TypeData typeData : entry.getValue()) {
                parent.acceptType(entry.getKey(), this.prepareMerge(typeData, parent.getReferenceOwner()));
            }
        }
    }

    protected TypeData prepareMerge(TypeData typeData, ITypeReferenceOwner owner) {
        LightweightTypeReference typeReference = typeData.getActualType();
        if (typeData.isOwnedBy(owner) && !(typeReference instanceof UnboundTypeReference)) {
            return typeData;
        }
        if (typeReference instanceof UnboundTypeReference && super.isResolved(((UnboundTypeReference)typeReference).getHandle())) {
            typeReference = typeReference.getUpperBoundSubstitute();
        }
        return new TypeData(typeData.getExpression(), typeData.getExpectation().copyInto(owner), typeReference.copyInto(owner), (EnumSet<ConformanceHint>)typeData.getConformanceHints().clone(), typeData.isReturnType());
    }

    protected void mergeLinkingCandidatesIntoParent(ResolvedTypes parent) {
        Map<XExpression, ILinkingCandidate> linkingCandidates = this.basicGetLinkingCandidates();
        if (!linkingCandidates.isEmpty()) {
            for (Map.Entry<XExpression, ILinkingCandidate> entry : linkingCandidates.entrySet()) {
                parent.acceptLinkingInformation(entry.getKey(), entry.getValue());
            }
        }
    }

    protected void mergeTypesIntoParent(ResolvedTypes parent) {
        Map<JvmIdentifiableElement, LightweightTypeReference> types = this.basicGetTypes();
        if (!types.isEmpty()) {
            for (Map.Entry<JvmIdentifiableElement, LightweightTypeReference> entry : types.entrySet()) {
                LightweightTypeReference value = entry.getValue();
                if (value instanceof UnboundTypeReference && super.isResolved(((UnboundTypeReference)value).getHandle())) {
                    parent.setType(entry.getKey(), value.getUpperBoundSubstitute().copyInto(parent.getReferenceOwner()));
                    continue;
                }
                parent.setType(entry.getKey(), value.copyInto(parent.getReferenceOwner()));
            }
        }
    }

    protected void mergeTypeParametersIntoParent(ResolvedTypes parent) {
        for (UnboundTypeReference unbound : this.basicGetTypeParameters().values()) {
            LightweightTypeReference resolvedTo = unbound.getResolvedTo();
            if (resolvedTo != null) continue;
            List<JvmTypeParameter> typeParameters = this.basicGetDeclardTypeParameters();
            if (typeParameters != null && typeParameters.contains(unbound.getTypeParameter())) {
                unbound.tryResolve();
                if (unbound.internalIsResolved()) continue;
                if (unbound.getExpression() instanceof XConstructorCall) {
                    unbound.resolve();
                    continue;
                }
                unbound.acceptHint(new ParameterizedTypeReference(unbound.getOwner(), (JvmType)unbound.getTypeParameter()), BoundTypeArgumentSource.RESOLVED, unbound, VarianceInfo.INVARIANT, VarianceInfo.INVARIANT);
                continue;
            }
            LightweightTypeReference reference = unbound.copyInto(parent.getReferenceOwner());
            if (!(reference instanceof UnboundTypeReference)) continue;
            parent.acceptUnboundTypeReference(unbound.getHandle(), (UnboundTypeReference)reference);
        }
        Map<Object, List<LightweightBoundTypeArgument>> typeParameterHints = this.basicGetTypeParameterHints();
        for (Map.Entry<Object, List<LightweightBoundTypeArgument>> hint : typeParameterHints.entrySet()) {
            if (parent.isResolved(hint.getKey())) continue;
            List<LightweightBoundTypeArgument> boundTypeArguments = hint.getValue();
            for (LightweightBoundTypeArgument boundTypeArgument : boundTypeArguments) {
                if (boundTypeArgument.getOrigin() instanceof VarianceInfo) {
                    parent.acceptHint(hint.getKey(), boundTypeArgument);
                    continue;
                }
                LightweightBoundTypeArgument copy = new LightweightBoundTypeArgument(boundTypeArgument.getTypeReference().copyInto(parent.getReferenceOwner()), boundTypeArgument.getSource(), boundTypeArgument.getOrigin(), boundTypeArgument.getDeclaredVariance(), boundTypeArgument.getActualVariance());
                parent.acceptHint(hint.getKey(), copy);
            }
        }
    }

    @Override
    public boolean isResolved(Object handle) {
        if (super.isResolved(handle)) {
            return true;
        }
        return this.parent.isResolved(handle);
    }

    @Override
    protected Collection<TypeData> doGetTypeData(XExpression expression) {
        Collection<TypeData> result = super.doGetTypeData(expression);
        if (result == null) {
            result = this.parent.doGetTypeData(expression);
        }
        return result;
    }

    @Override
    protected LightweightTypeReference doGetActualType(JvmIdentifiableElement identifiable, boolean ignoreReassignedTypes) {
        LightweightTypeReference result = super.doGetActualType(identifiable, ignoreReassignedTypes);
        if (result == null) {
            result = this.parent.doGetActualType(identifiable, ignoreReassignedTypes);
        }
        return result;
    }

    @Override
    protected boolean isRefinedType(JvmIdentifiableElement element) {
        if (super.isRefinedType(element)) {
            return true;
        }
        return this.parent.isRefinedType(element);
    }

    @Override
    protected ILinkingCandidate doGetLinkingCandidate(XExpression featureOrConstructorCall) {
        if (featureOrConstructorCall == null) {
            return null;
        }
        ILinkingCandidate result = super.doGetLinkingCandidate(featureOrConstructorCall);
        if (result != null) {
            return result;
        }
        return this.parent.doGetLinkingCandidate(featureOrConstructorCall);
    }

    @Override
    protected JvmIdentifiableElement doGetLinkedFeature(XExpression featureOrConstructorCall) {
        if (featureOrConstructorCall == null) {
            return null;
        }
        JvmIdentifiableElement result = super.doGetLinkedFeature(featureOrConstructorCall);
        if (result != null) {
            return result;
        }
        return this.parent.doGetLinkedFeature(featureOrConstructorCall);
    }

    @Override
    protected LightweightTypeReference doGetDeclaredType(JvmIdentifiableElement identifiable) {
        return null;
    }

    @Override
    public List<LightweightTypeReference> getExpectedExceptions() {
        return this.parent.getExpectedExceptions();
    }

    @Override
    public List<JvmTypeParameter> getDeclaredTypeParameters() {
        List<JvmTypeParameter> result = this.basicGetDeclardTypeParameters();
        if (result != null) {
            return result;
        }
        return this.parent.getDeclaredTypeParameters();
    }

    @Override
    public void addDeclaredTypeParameters(List<JvmTypeParameter> typeParameters) {
        if (typeParameters.isEmpty()) {
            return;
        }
        List<JvmTypeParameter> list = this.basicGetDeclardTypeParameters();
        if (list == null) {
            super.addDeclaredTypeParameters(this.parent.getDeclaredTypeParameters());
            this.getDeclaredTypeParameters().addAll(typeParameters);
        } else {
            list.addAll(typeParameters);
        }
    }

    public void replaceDeclaredTypeParameters(List<JvmTypeParameter> typeParameters) {
        List<JvmTypeParameter> list = this.basicGetDeclardTypeParameters();
        if (list != null) {
            throw new IllegalStateException("Cannot replace declared type parameters if there are already type parameters in this StackedResolvedTypes");
        }
        super.addDeclaredTypeParameters(typeParameters);
    }

    @Override
    protected List<LightweightTypeReference> doGetActualTypeArguments(XExpression expression) {
        List<LightweightTypeReference> result = super.doGetActualTypeArguments(expression);
        if (result == null) {
            result = this.parent.doGetActualTypeArguments(expression);
        }
        return result;
    }

    @Override
    public IFeatureLinkingCandidate getFeature(XAbstractFeatureCall featureCall) {
        IFeatureLinkingCandidate result = super.getFeature(featureCall);
        if (result == null) {
            result = this.parent.getFeature(featureCall);
        }
        return result;
    }

    @Override
    public IConstructorLinkingCandidate getConstructor(XConstructorCall constructorCall) {
        IConstructorLinkingCandidate result = super.getConstructor(constructorCall);
        if (result == null) {
            result = this.parent.getConstructor(constructorCall);
        }
        return result;
    }

    @Override
    public void reassignType(JvmIdentifiableElement identifiable, LightweightTypeReference reference) {
        super.reassignType(identifiable, reference);
        if (reference == null) {
            this.getParent().reassignType(identifiable, reference);
        }
    }

    public List<AbstractDiagnostic> getQueuedDiagnostics() {
        ArrayList result = Lists.newArrayList(super.getQueuedDiagnostics());
        result.addAll(this.parent.getQueuedDiagnostics());
        return result;
    }

    @Override
    protected UnboundTypeReference getUnboundTypeReference(Object handle) {
        UnboundTypeReference result = this.basicGetTypeParameters().get(handle);
        if (result == null) {
            result = this.parent.getUnboundTypeReference(handle);
            if (result.internalIsResolved()) {
                throw new IllegalStateException("Cannot query unbound reference that was already resolved");
            }
            return (UnboundTypeReference)result.copyInto(this.getReferenceOwner());
        }
        return result;
    }

    @Override
    protected void refineExpectedType(XExpression receiver, ITypeExpectation refinedExpectation) {
        Collection typeData = this.basicGetExpressionTypes().get(receiver);
        if (typeData == null) {
            this.getParent().refineExpectedType(receiver, refinedExpectation);
        } else {
            super.refineExpectedType(receiver, refinedExpectation);
        }
    }

    @Override
    protected List<LightweightBoundTypeArgument> getHints(Object handle) {
        List<LightweightBoundTypeArgument> result = super.getHints(handle);
        if (result.size() == 1 && super.isResolved(handle)) {
            return result;
        }
        List<LightweightBoundTypeArgument> parentHints = this.getParent().getHints(handle);
        if (parentHints.size() == 1 && this.getParent().isResolved(handle)) {
            LightweightBoundTypeArgument parentHint = parentHints.get(0);
            LightweightBoundTypeArgument copy = new LightweightBoundTypeArgument(parentHint.getTypeReference().copyInto(this.getReferenceOwner()), parentHint.getSource(), parentHint.getOrigin(), parentHint.getDeclaredVariance(), parentHint.getActualVariance());
            return Collections.singletonList(copy);
        }
        if (parentHints.isEmpty()) {
            return result;
        }
        ArrayList withParentHints = Lists.newArrayListWithCapacity((int)(parentHints.size() + result.size()));
        for (LightweightBoundTypeArgument parentHint : parentHints) {
            if (parentHint.getTypeReference() == null) {
                withParentHints.add(parentHint);
                continue;
            }
            LightweightBoundTypeArgument copy = new LightweightBoundTypeArgument(parentHint.getTypeReference().copyInto(this.getReferenceOwner()), parentHint.getSource(), parentHint.getOrigin(), parentHint.getDeclaredVariance(), parentHint.getActualVariance());
            withParentHints.add(copy);
        }
        withParentHints.addAll(result);
        return withParentHints;
    }

    protected EnumSet<ConformanceHint> getConformanceHints(XExpression expression, boolean recompute) {
        TypeData typeData = this.getTypeData(expression, false);
        if (typeData == null) {
            return EnumSet.of(ConformanceHint.EXCEPTION);
        }
        return this.getConformanceHints(typeData, recompute);
    }

    @Override
    protected void appendContent(StringBuilder result, String indentation) {
        super.appendContent(result, indentation);
        result.append("\n" + indentation + "parent: [");
        this.parent.appendContent(result, String.valueOf(indentation) + "  ");
        this.closeBracket(result, indentation);
    }

    @Override
    protected LightweightTypeReference getExpectedTypeForAssociatedExpression(JvmMember member, XExpression expression) {
        return this.parent.getExpectedTypeForAssociatedExpression(member, expression);
    }

    @Override
    protected void markToBeInferred(XExpression expression) {
        this.parent.markToBeInferred(expression);
    }

    @Override
    protected IssueSeverities getSeverities() {
        return this.parent.getSeverities();
    }

    @Override
    protected IFeatureScopeTracker getFeatureScopeTracker() {
        return this.parent.getFeatureScopeTracker();
    }

    @Override
    protected Map<JvmIdentifiableElement, LightweightTypeReference> getFlattenedReassignedTypes() {
        Map<JvmIdentifiableElement, LightweightTypeReference> result = this.parent.getFlattenedReassignedTypes();
        if (result == null) {
            return super.getFlattenedReassignedTypes();
        }
        result.putAll(this.basicGetReassignedTypes());
        return result;
    }
}

