/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.linking.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.IScopeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportedNamesAdapter
extends AdapterImpl
implements IScopeWrapper {
    private static final Logger log = Logger.getLogger(ImportedNamesAdapter.class);
    private Set<QualifiedName> importedNames = new HashSet<QualifiedName>();

    public static ImportedNamesAdapter find(Resource resource) {
        for (Adapter adapter : resource.eAdapters()) {
            if (!(adapter instanceof ImportedNamesAdapter)) continue;
            return (ImportedNamesAdapter)adapter;
        }
        return null;
    }

    public static ImportedNamesAdapter findOrInstall(Resource resource) {
        ImportedNamesAdapter adapter = ImportedNamesAdapter.find(resource);
        if (adapter != null) {
            return adapter;
        }
        ImportedNamesAdapter importedNamesAdapter = new ImportedNamesAdapter();
        resource.eAdapters().add((Object)importedNamesAdapter);
        return importedNamesAdapter;
    }

    public Set<QualifiedName> getImportedNames() {
        return this.importedNames;
    }

    @Override
    public IScope wrap(IScope scope) {
        return new WrappingScope(scope);
    }

    public void clear() {
        this.importedNames.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class WrappingScope
    implements IScope {
        private final IScope delegate;

        public WrappingScope(IScope scope) {
            this.delegate = scope;
        }

        @Override
        public IEObjectDescription getSingleElement(QualifiedName name) {
            QualifiedName lowerCase = name.toLowerCase();
            ImportedNamesAdapter.this.importedNames.add(lowerCase);
            return this.delegate.getSingleElement(name);
        }

        @Override
        public Iterable<IEObjectDescription> getElements(final QualifiedName name) {
            return new Iterable<IEObjectDescription>(){

                @Override
                public Iterator<IEObjectDescription> iterator() {
                    QualifiedName lowerCase = name.toLowerCase();
                    ImportedNamesAdapter.this.importedNames.add(lowerCase);
                    Iterable<IEObjectDescription> elements = WrappingScope.this.delegate.getElements(name);
                    return elements.iterator();
                }
            };
        }

        @Override
        public Iterable<IEObjectDescription> getElements(EObject object) {
            this.handleNoNameQuery();
            return this.delegate.getElements(object);
        }

        @Override
        public IEObjectDescription getSingleElement(EObject object) {
            this.handleNoNameQuery();
            return this.delegate.getSingleElement(object);
        }

        @Override
        public Iterable<IEObjectDescription> getAllElements() {
            this.handleNoNameQuery();
            return this.delegate.getAllElements();
        }

        protected void handleNoNameQuery() {
            if (log.isInfoEnabled()) {
                log.info((Object)"getElements should be called with a QualifiedName during linking.");
            }
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " -> " + this.delegate;
        }
    }
}

