/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.edit.ActiveCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.SingleEditHandler;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.selection.event.CellSelectionEvent;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class InlineCellEditController {
    private static Map<ILayer, ILayerListener> layerListenerMap = new HashMap<ILayer, ILayerListener>();

    public static boolean editCellInline(ILayerCell cell, Character initialEditValue, final Composite parent, IConfigRegistry configRegistry) {
        int rowPosition;
        int columnPosition;
        ILayer layer;
        Rectangle cellBounds;
        List<String> configLabels;
        block7: {
            ActiveCellEditor.commit();
            configLabels = cell.getConfigLabels().getLabels();
            cellBounds = cell.getBounds();
            layer = cell.getLayer();
            columnPosition = layer.getColumnPositionByX(cellBounds.x);
            rowPosition = layer.getRowPositionByY(cellBounds.y);
            boolean editable = configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, "EDIT", configLabels).isEditable(cell, configRegistry);
            if (editable) break block7;
            return false;
        }
        try {
            ICellEditor cellEditor = configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITOR, "EDIT", configLabels);
            SingleEditHandler editHandler = new SingleEditHandler(cellEditor, layer, columnPosition, rowPosition);
            Rectangle editorBounds = layer.getLayerPainter().adjustCellBounds(columnPosition, rowPosition, new Rectangle(cellBounds.x, cellBounds.y, cellBounds.width, cellBounds.height));
            Object originalCanonicalValue = cell.getDataValue();
            ActiveCellEditor.activate(cellEditor, parent, originalCanonicalValue, initialEditValue, EditModeEnum.INLINE, editHandler, cell, configRegistry);
            Control editorControl = ActiveCellEditor.getControl();
            if (editorControl != null) {
                editorControl.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        if (!ActiveCellEditor.commit()) {
                            if (e.widget instanceof Control && !e.widget.isDisposed()) {
                                ((Control)e.widget).forceFocus();
                            }
                        } else {
                            parent.forceFocus();
                        }
                    }
                });
                editorControl.setBounds(editorBounds);
                ILayerListener layerListener = layerListenerMap.get(layer);
                if (layerListener == null) {
                    layerListener = new InlineCellEditLayerListener(layer);
                    layerListenerMap.put(layer, layerListener);
                    layer.addLayerListener(layerListener);
                }
            }
        }
        catch (Exception e) {
            if (cell == null) {
                System.err.println("Cell being edited is no longer available. Character: " + initialEditValue);
            } else {
                System.err.println("Error while editing cell (inline): Cell: " + cell + "; Character: " + initialEditValue);
            }
            e.printStackTrace();
        }
        return true;
    }

    public static void dispose() {
        layerListenerMap.clear();
    }

    static class InlineCellEditLayerListener
    implements ILayerListener {
        private final ILayer layer;

        InlineCellEditLayerListener(ILayer layer) {
            this.layer = layer;
        }

        public void handleLayerEvent(ILayerEvent event) {
            if (event instanceof CellSelectionEvent && ActiveCellEditor.isValid()) {
                int selectedCellColumnPosition = 0;
                int selectedCellRowPosition = 0;
                CellSelectionEvent csEvent = (CellSelectionEvent)event;
                selectedCellColumnPosition = csEvent.getColumnPosition();
                selectedCellRowPosition = csEvent.getRowPosition();
                int editorColumnPosition = ActiveCellEditor.getColumnPosition();
                int editorRowPosition = ActiveCellEditor.getRowPosition();
                int editorColumnIndex = ActiveCellEditor.getColumnIndex();
                int editorRowIndex = ActiveCellEditor.getRowIndex();
                int selectedColumnIndex = this.layer.getColumnIndexByPosition(selectedCellColumnPosition);
                int selectedRowIndex = this.layer.getRowIndexByPosition(selectedCellRowPosition);
                Control editorControl = ActiveCellEditor.getControl();
                if (selectedColumnIndex != editorColumnIndex || selectedRowIndex != editorRowIndex) {
                    ActiveCellEditor.close();
                } else if (editorControl != null && !editorControl.isDisposed()) {
                    Rectangle cellBounds = this.layer.getBoundsByPosition(editorColumnPosition, editorRowPosition);
                    Rectangle adjustedCellBounds = this.layer.getLayerPainter().adjustCellBounds(editorColumnPosition, editorRowPosition, cellBounds);
                    editorControl.setBounds(adjustedCellBounds);
                }
            }
        }
    }
}

