/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.LayoutCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.cell.AggregrateConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.TranslatedLayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.util.IClientAreaProvider;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeLayer
extends AbstractLayer {
    private final int layoutXCount;
    private final int layoutYCount;
    private final Map<ILayer, String> childLayerToRegionNameMap = new HashMap<ILayer, String>();
    private final Map<String, IConfigLabelAccumulator> regionNameToConfigLabelAccumulatorMap = new HashMap<String, IConfigLabelAccumulator>();
    private final Map<ILayer, LayoutCoordinate> childLayerToLayoutCoordinateMap = new HashMap<ILayer, LayoutCoordinate>();
    private final ILayer[][] childLayerLayout;
    private ChildLayerInfo[][] childLayerInfos;
    private final CompositeLayerPainter compositeLayerPainter = new CompositeLayerPainter();

    public CompositeLayer(int layoutXCount, int layoutYCount) {
        this.layoutXCount = layoutXCount;
        this.layoutYCount = layoutYCount;
        this.childLayerLayout = new ILayer[layoutXCount][layoutYCount];
    }

    @Override
    public void dispose() {
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            int layoutY = 0;
            while (layoutY < this.layoutYCount) {
                ILayer childLayer = this.childLayerLayout[layoutX][layoutY];
                if (childLayer != null) {
                    childLayer.dispose();
                }
                ++layoutY;
            }
            ++layoutX;
        }
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            int layoutY = 0;
            while (layoutY < this.layoutYCount) {
                ILayer childLayer = this.childLayerLayout[layoutX][layoutY];
                if (childLayer != null) {
                    String regionName = this.childLayerToRegionNameMap.get(childLayer);
                    childLayer.saveState(String.valueOf(prefix) + "." + regionName, properties);
                }
                ++layoutY;
            }
            ++layoutX;
        }
        super.saveState(prefix, properties);
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            int layoutY = 0;
            while (layoutY < this.layoutYCount) {
                ILayer childLayer = this.childLayerLayout[layoutX][layoutY];
                if (childLayer != null) {
                    String regionName = this.childLayerToRegionNameMap.get(childLayer);
                    childLayer.loadState(String.valueOf(prefix) + "." + regionName, properties);
                }
                ++layoutY;
            }
            ++layoutX;
        }
        super.loadState(prefix, properties);
    }

    @Override
    public void configure(ConfigRegistry configRegistry, UiBindingRegistry uiBindingRegistry) {
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            int layoutY = 0;
            while (layoutY < this.layoutYCount) {
                this.childLayerLayout[layoutX][layoutY].configure(configRegistry, uiBindingRegistry);
                ++layoutY;
            }
            ++layoutX;
        }
        super.configure(configRegistry, uiBindingRegistry);
    }

    @Override
    public ILayerPainter getLayerPainter() {
        return this.compositeLayerPainter;
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (super.doCommand(command)) {
            return true;
        }
        return this.doCommandOnChildLayers(command);
    }

    protected boolean doCommandOnChildLayers(ILayerCommand command) {
        for (ILayer childLayer : this.childLayerToLayoutCoordinateMap.keySet()) {
            ILayerCommand childCommand;
            if (!childLayer.doCommand(childCommand = command.cloneCommand())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        if (event instanceof IStructuralChangeEvent) {
            this.childLayerInfos = null;
        }
        super.handleLayerEvent(event);
    }

    @Override
    public int getColumnCount() {
        ChildLayerInfo lastChildLayerInfo = this.getChildLayerInfoByLayout(this.layoutXCount - 1, 0);
        return lastChildLayerInfo.getColumnPositionOffset() + lastChildLayerInfo.getLayer().getColumnCount();
    }

    @Override
    public int getPreferredColumnCount() {
        int preferredColumnCount = 0;
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            preferredColumnCount += this.childLayerLayout[layoutX][0].getPreferredColumnCount();
            ++layoutX;
        }
        return preferredColumnCount;
    }

    @Override
    public int getColumnIndexByPosition(int compositeColumnPosition) {
        ChildLayerInfo childLayerInfo = this.getChildLayerInfoByColumnPosition(compositeColumnPosition);
        if (childLayerInfo == null) {
            return -1;
        }
        int childColumnPosition = compositeColumnPosition - childLayerInfo.getColumnPositionOffset();
        return childLayerInfo.getLayer().getColumnIndexByPosition(childColumnPosition);
    }

    @Override
    public int localToUnderlyingColumnPosition(int localColumnPosition) {
        ChildLayerInfo childLayerInfo = this.getChildLayerInfoByColumnPosition(localColumnPosition);
        if (childLayerInfo == null) {
            return -1;
        }
        return localColumnPosition - childLayerInfo.getColumnPositionOffset();
    }

    @Override
    public int underlyingToLocalColumnPosition(ILayer sourceUnderlyingLayer, int underlyingColumnPosition) {
        ChildLayerInfo childLayerInfo = this.getChildLayerInfoByChildLayer(sourceUnderlyingLayer);
        if (childLayerInfo == null) {
            return -1;
        }
        return childLayerInfo.columnPositionOffset + underlyingColumnPosition;
    }

    @Override
    public Collection<Range> underlyingToLocalColumnPositions(ILayer sourceUnderlyingLayer, Collection<Range> underlyingColumnPositionRanges) {
        ChildLayerInfo childLayerInfo = this.getChildLayerInfoByChildLayer(sourceUnderlyingLayer);
        if (childLayerInfo == null) {
            return null;
        }
        ArrayList<Range> localColumnPositionRanges = new ArrayList<Range>();
        int offset = childLayerInfo.columnPositionOffset;
        for (Range underlyingColumnPositionRange : underlyingColumnPositionRanges) {
            localColumnPositionRanges.add(new Range(offset + underlyingColumnPositionRange.start, offset + underlyingColumnPositionRange.end));
        }
        return localColumnPositionRanges;
    }

    @Override
    public int getWidth() {
        ChildLayerInfo lastChildLayerInfo = this.getChildLayerInfoByLayout(this.layoutXCount - 1, 0);
        return lastChildLayerInfo.getWidthOffset() + lastChildLayerInfo.getLayer().getWidth();
    }

    @Override
    public int getPreferredWidth() {
        int preferredWidth = 0;
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            preferredWidth += this.childLayerLayout[layoutX][0].getPreferredWidth();
            ++layoutX;
        }
        return preferredWidth;
    }

    @Override
    public int getColumnWidthByPosition(int compositeColumnPosition) {
        ChildLayerInfo childLayerInfo = this.getChildLayerInfoByColumnPosition(compositeColumnPosition);
        if (childLayerInfo == null) {
            return -1;
        }
        int childColumnPosition = compositeColumnPosition - childLayerInfo.getColumnPositionOffset();
        return childLayerInfo.getLayer().getColumnWidthByPosition(childColumnPosition);
    }

    @Override
    public boolean isColumnPositionResizable(int compositeColumnPosition) {
        ChildLayerInfo childLayerInfo = this.getChildLayerInfoByColumnPosition(compositeColumnPosition);
        if (childLayerInfo == null) {
            return false;
        }
        int childColumnPosition = compositeColumnPosition - childLayerInfo.getColumnPositionOffset();
        return childLayerInfo.getLayer().isColumnPositionResizable(childColumnPosition);
    }

    @Override
    public int getColumnPositionByX(int x) {
        ChildLayerInfo childLayerInfo = this.getChildLayerInfoByX(x);
        if (childLayerInfo == null) {
            return -1;
        }
        int childX = x - childLayerInfo.getWidthOffset();
        int childColumnPosition = childLayerInfo.getLayer().getColumnPositionByX(childX);
        return childLayerInfo.getColumnPositionOffset() + childColumnPosition;
    }

    @Override
    public int getStartXOfColumnPosition(int columnPosition) {
        ChildLayerInfo childLayerInfo = this.getChildLayerInfoByColumnPosition(columnPosition);
        if (childLayerInfo == null) {
            return -1;
        }
        int childColumnPosition = columnPosition - childLayerInfo.getColumnPositionOffset();
        return childLayerInfo.getWidthOffset() + childLayerInfo.getLayer().getStartXOfColumnPosition(childColumnPosition);
    }

    @Override
    public Collection<ILayer> getUnderlyingLayersByColumnPosition(int columnPosition) {
        HashSet<ILayer> underlyingLayers = new HashSet<ILayer>();
        if (this.childLayerInfos == null) {
            this.populateChildLayerInfos();
        }
        int layoutX = 0;
        while (layoutX < this.childLayerInfos.length) {
            if (columnPosition >= this.childLayerInfos[layoutX][0].getColumnPositionOffset() && columnPosition < this.childLayerInfos[layoutX][0].getColumnPositionOffset() + this.childLayerInfos[layoutX][0].getLayer().getColumnCount()) {
                int layoutY = 0;
                while (layoutY < this.childLayerInfos[layoutX].length) {
                    underlyingLayers.add(this.childLayerInfos[layoutX][layoutY].getLayer());
                    ++layoutY;
                }
                break;
            }
            ++layoutX;
        }
        return underlyingLayers;
    }

    @Override
    public int getRowCount() {
        ChildLayerInfo lastChildLayerInfo = this.getChildLayerInfoByLayout(0, this.layoutYCount - 1);
        return lastChildLayerInfo.getRowPositionOffset() + lastChildLayerInfo.getLayer().getRowCount();
    }

    @Override
    public int getPreferredRowCount() {
        int preferredRowCount = 0;
        int layoutY = 0;
        while (layoutY < this.layoutYCount) {
            preferredRowCount += this.childLayerLayout[0][layoutY].getPreferredRowCount();
            ++layoutY;
        }
        return preferredRowCount;
    }

    @Override
    public int getRowIndexByPosition(int compositeRowPosition) {
        ChildLayerInfo childLayerInfo = this.getChildLayerInfoByRowPosition(compositeRowPosition);
        if (childLayerInfo == null) {
            return -1;
        }
        int childRowPosition = compositeRowPosition - childLayerInfo.getRowPositionOffset();
        return childLayerInfo.getLayer().getRowIndexByPosition(childRowPosition);
    }

    @Override
    public int localToUnderlyingRowPosition(int localRowPosition) {
        ChildLayerInfo childLayerInfo = this.getChildLayerInfoByRowPosition(localRowPosition);
        if (childLayerInfo == null) {
            return -1;
        }
        return localRowPosition - childLayerInfo.getRowPositionOffset();
    }

    @Override
    public int underlyingToLocalRowPosition(ILayer sourceUnderlyingLayer, int underlyingRowPosition) {
        ChildLayerInfo childLayerInfo = this.getChildLayerInfoByChildLayer(sourceUnderlyingLayer);
        if (childLayerInfo == null) {
            return -1;
        }
        return childLayerInfo.rowPositionOffset + underlyingRowPosition;
    }

    @Override
    public Collection<Range> underlyingToLocalRowPositions(ILayer sourceUnderlyingLayer, Collection<Range> underlyingRowPositionRanges) {
        ChildLayerInfo childLayerInfo = this.getChildLayerInfoByChildLayer(sourceUnderlyingLayer);
        if (childLayerInfo == null) {
            return null;
        }
        ArrayList<Range> localRowPositionRanges = new ArrayList<Range>();
        int offset = childLayerInfo.rowPositionOffset;
        for (Range underlyingRowPositionRange : underlyingRowPositionRanges) {
            localRowPositionRanges.add(new Range(offset + underlyingRowPositionRange.start, offset + underlyingRowPositionRange.end));
        }
        return localRowPositionRanges;
    }

    @Override
    public int getHeight() {
        ChildLayerInfo lastChildLayerInfo = this.getChildLayerInfoByLayout(0, this.layoutYCount - 1);
        return lastChildLayerInfo.getHeightOffset() + lastChildLayerInfo.getLayer().getHeight();
    }

    @Override
    public int getPreferredHeight() {
        int preferredHeight = 0;
        int layoutY = 0;
        while (layoutY < this.layoutYCount) {
            preferredHeight += this.childLayerLayout[0][layoutY].getPreferredHeight();
            ++layoutY;
        }
        return preferredHeight;
    }

    @Override
    public int getRowHeightByPosition(int compositeRowPosition) {
        ChildLayerInfo childLayerInfo = this.getChildLayerInfoByRowPosition(compositeRowPosition);
        if (childLayerInfo == null) {
            return -1;
        }
        int childRowPosition = compositeRowPosition - childLayerInfo.getRowPositionOffset();
        return childLayerInfo.getLayer().getRowHeightByPosition(childRowPosition);
    }

    @Override
    public boolean isRowPositionResizable(int compositeRowPosition) {
        ChildLayerInfo childLayerInfo = this.getChildLayerInfoByRowPosition(compositeRowPosition);
        if (childLayerInfo == null) {
            return false;
        }
        int childRowPosition = compositeRowPosition - childLayerInfo.getRowPositionOffset();
        return childLayerInfo.getLayer().isRowPositionResizable(childRowPosition);
    }

    @Override
    public int getRowPositionByY(int y) {
        ChildLayerInfo childLayerInfo = this.getChildLayerInfoByXY(0, y);
        if (childLayerInfo == null) {
            return -1;
        }
        int childY = y - childLayerInfo.getHeightOffset();
        int childRowPosition = childLayerInfo.getLayer().getRowPositionByY(childY);
        return childLayerInfo.getRowPositionOffset() + childRowPosition;
    }

    @Override
    public int getStartYOfRowPosition(int rowPosition) {
        ChildLayerInfo childLayerInfo = this.getChildLayerInfoByRowPosition(rowPosition);
        if (childLayerInfo == null) {
            return -1;
        }
        int childRowPosition = rowPosition - childLayerInfo.getRowPositionOffset();
        return childLayerInfo.getHeightOffset() + childLayerInfo.getLayer().getStartYOfRowPosition(childRowPosition);
    }

    @Override
    public Collection<ILayer> getUnderlyingLayersByRowPosition(int rowPosition) {
        HashSet<ILayer> underlyingLayers = new HashSet<ILayer>();
        if (this.childLayerInfos == null) {
            this.populateChildLayerInfos();
        }
        int layoutY = 0;
        while (layoutY < this.childLayerInfos[0].length) {
            if (rowPosition >= this.childLayerInfos[0][layoutY].getRowPositionOffset() && rowPosition < this.childLayerInfos[0][layoutY].getRowPositionOffset() + this.childLayerInfos[0][layoutY].getLayer().getRowCount()) {
                int layoutX = 0;
                while (layoutX < this.childLayerInfos.length) {
                    underlyingLayers.add(this.childLayerInfos[layoutX][layoutY].getLayer());
                    ++layoutX;
                }
                break;
            }
            ++layoutY;
        }
        return underlyingLayers;
    }

    @Override
    public ILayerCell getCellByPosition(int compositeColumnPosition, int compositeRowPosition) {
        int childRowPosition;
        int childColumnPosition;
        ChildLayerInfo childLayerInfo = this.getChildLayerInfoByPosition(compositeColumnPosition, compositeRowPosition);
        if (childLayerInfo == null) {
            return null;
        }
        ILayer childLayer = childLayerInfo.getLayer();
        ILayerCell cell = childLayer.getCellByPosition(childColumnPosition = compositeColumnPosition - childLayerInfo.getColumnPositionOffset(), childRowPosition = compositeRowPosition - childLayerInfo.getRowPositionOffset());
        if (cell != null) {
            cell = new TranslatedLayerCell(cell, this, this.underlyingToLocalColumnPosition(childLayer, cell.getOriginColumnPosition()), this.underlyingToLocalRowPosition(childLayer, cell.getOriginRowPosition()), this.underlyingToLocalColumnPosition(childLayer, cell.getColumnPosition()), this.underlyingToLocalRowPosition(childLayer, cell.getRowPosition()));
        }
        return cell;
    }

    @Override
    public Rectangle getBoundsByPosition(int compositeColumnPosition, int compositeRowPosition) {
        int childRowPosition;
        int childColumnPosition;
        ChildLayerInfo childLayerInfo = this.getChildLayerInfoByPosition(compositeColumnPosition, compositeRowPosition);
        if (childLayerInfo == null) {
            return null;
        }
        ILayer childLayer = childLayerInfo.getLayer();
        Rectangle bounds = childLayer.getBoundsByPosition(childColumnPosition = compositeColumnPosition - childLayerInfo.getColumnPositionOffset(), childRowPosition = compositeRowPosition - childLayerInfo.getRowPositionOffset());
        if (bounds != null) {
            bounds.x += childLayerInfo.widthOffset;
            bounds.y += childLayerInfo.heightOffset;
        }
        return bounds;
    }

    public Rectangle getCellBounds(int compositeRowPosition, int compositeColumnPosition) {
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        rectangle.width = this.getColumnWidthByPosition(compositeColumnPosition);
        rectangle.height = this.getRowHeightByPosition(compositeRowPosition);
        rectangle.x = this.getStartXOfColumnPosition(compositeColumnPosition);
        rectangle.y = this.getStartYOfRowPosition(compositeRowPosition);
        return rectangle;
    }

    @Override
    public String getDisplayModeByPosition(int compositeColumnPosition, int compositeRowPosition) {
        ChildLayerInfo childLayerInfo = this.getChildLayerInfoByPosition(compositeColumnPosition, compositeRowPosition);
        if (childLayerInfo == null) {
            return super.getDisplayModeByPosition(compositeColumnPosition, compositeRowPosition);
        }
        return childLayerInfo.getLayer().getDisplayModeByPosition(compositeColumnPosition - childLayerInfo.getColumnPositionOffset(), compositeRowPosition - childLayerInfo.getRowPositionOffset());
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int compositeColumnPosition, int compositeRowPosition) {
        ChildLayerInfo childLayerInfo = this.getChildLayerInfoByPosition(compositeColumnPosition, compositeRowPosition);
        if (childLayerInfo == null) {
            return new LabelStack(new String[0]);
        }
        ILayer childLayer = childLayerInfo.getLayer();
        int childColumnPosition = compositeColumnPosition - childLayerInfo.getColumnPositionOffset();
        int childRowPosition = compositeRowPosition - childLayerInfo.getRowPositionOffset();
        LabelStack configLabels = childLayer.getConfigLabelsByPosition(childColumnPosition, childRowPosition);
        String regionName = this.childLayerToRegionNameMap.get(childLayer);
        IConfigLabelAccumulator configLabelAccumulator = this.regionNameToConfigLabelAccumulatorMap.get(regionName);
        if (configLabelAccumulator != null) {
            configLabelAccumulator.accumulateConfigLabels(configLabels, childColumnPosition, childRowPosition);
        }
        configLabels.addLabel(regionName);
        return configLabels;
    }

    @Override
    public Object getDataValueByPosition(int compositeColumnPosition, int compositeRowPosition) {
        ChildLayerInfo childLayerInfo = this.getChildLayerInfoByPosition(compositeColumnPosition, compositeRowPosition);
        if (childLayerInfo == null) {
            return -1;
        }
        return childLayerInfo.getLayer().getDataValueByPosition(compositeColumnPosition - childLayerInfo.getColumnPositionOffset(), compositeRowPosition - childLayerInfo.getRowPositionOffset());
    }

    @Override
    public ICellPainter getCellPainter(int compositeColumnPosition, int compositeRowPosition, ILayerCell cell, IConfigRegistry configRegistry) {
        ChildLayerInfo childLayerInfo = this.getChildLayerInfoByPosition(compositeColumnPosition, compositeRowPosition);
        if (childLayerInfo == null) {
            return null;
        }
        return childLayerInfo.getLayer().getCellPainter(compositeColumnPosition - childLayerInfo.getColumnPositionOffset(), compositeRowPosition - childLayerInfo.getRowPositionOffset(), cell, configRegistry);
    }

    public void setChildLayer(String regionName, ILayer childLayer, final int layoutX, final int layoutY) {
        if (childLayer == null) {
            throw new IllegalArgumentException("Cannot set null child layer");
        }
        this.childLayerToRegionNameMap.put(childLayer, regionName);
        childLayer.addLayerListener(this);
        this.childLayerToLayoutCoordinateMap.put(childLayer, new LayoutCoordinate(layoutX, layoutY));
        this.childLayerLayout[layoutX][layoutY] = childLayer;
        childLayer.setClientAreaProvider(new IClientAreaProvider(){

            public Rectangle getClientArea() {
                return CompositeLayer.this.getChildClientArea(layoutX, layoutY);
            }
        });
    }

    public IConfigLabelAccumulator getConfigLabelAccumulatorByRegionName(String regionName) {
        return this.regionNameToConfigLabelAccumulatorMap.get(regionName);
    }

    public void setConfigLabelAccumulatorForRegion(String regionName, IConfigLabelAccumulator configLabelAccumulator) {
        this.regionNameToConfigLabelAccumulatorMap.put(regionName, configLabelAccumulator);
    }

    public void addConfigLabelAccumulatorForRegion(String regionName, IConfigLabelAccumulator configLabelAccumulator) {
        AggregrateConfigLabelAccumulator aggregateAccumulator;
        IConfigLabelAccumulator existingConfigLabelAccumulator = this.regionNameToConfigLabelAccumulatorMap.get(regionName);
        if (existingConfigLabelAccumulator instanceof AggregrateConfigLabelAccumulator) {
            aggregateAccumulator = (AggregrateConfigLabelAccumulator)existingConfigLabelAccumulator;
        } else {
            aggregateAccumulator = new AggregrateConfigLabelAccumulator();
            aggregateAccumulator.add(existingConfigLabelAccumulator);
            this.regionNameToConfigLabelAccumulatorMap.put(regionName, aggregateAccumulator);
        }
        aggregateAccumulator.add(configLabelAccumulator);
    }

    private Rectangle getChildClientArea(int layoutX, int layoutY) {
        ChildLayerInfo childLayerInfo = this.getChildLayerInfoByLayout(layoutX, layoutY);
        Rectangle compositeClientArea = this.getClientAreaProvider().getClientArea();
        Rectangle childClientArea = new Rectangle(compositeClientArea.x + childLayerInfo.getWidthOffset(), compositeClientArea.y + childLayerInfo.getHeightOffset(), childLayerInfo.getLayer().getPreferredWidth(), childLayerInfo.getLayer().getPreferredHeight());
        Rectangle intersection = compositeClientArea.intersection(childClientArea);
        return intersection;
    }

    public ILayer getChildLayerByLayoutCoordinate(int layoutX, int layoutY) {
        return this.childLayerLayout[layoutX][layoutY];
    }

    public ILayer getChildLayerByXY(int x, int y) {
        ChildLayerInfo childLayerInfo = this.getChildLayerInfoByXY(x, y);
        return childLayerInfo == null ? null : childLayerInfo.getLayer();
    }

    @Override
    public LabelStack getRegionLabelsByXY(int x, int y) {
        ChildLayerInfo childLayerInfo = this.getChildLayerInfoByXY(x, y);
        if (childLayerInfo == null) {
            return null;
        }
        ILayer childLayer = childLayerInfo.getLayer();
        int childX = x - childLayerInfo.getWidthOffset();
        int childY = y - childLayerInfo.getHeightOffset();
        LabelStack regionLabels = childLayer.getRegionLabelsByXY(childX, childY);
        String regionName = this.childLayerToRegionNameMap.get(childLayer);
        regionLabels.addLabel(regionName);
        return regionLabels;
    }

    @Override
    public ILayer getUnderlyingLayerByPosition(int columnPosition, int rowPosition) {
        return this.getChildLayerInfoByPosition(columnPosition, rowPosition).getLayer();
    }

    private ChildLayerInfo getChildLayerInfoByXY(int x, int y) {
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            ChildLayerInfo childLayerInfo = this.getChildLayerInfoByLayout(layoutX, 0);
            if (childLayerInfo == null) {
                return null;
            }
            if (x >= childLayerInfo.getWidthOffset() && x < childLayerInfo.getWidthOffset() + childLayerInfo.getLayer().getWidth()) break;
            ++layoutX;
        }
        int layoutY = 0;
        while (layoutY < this.layoutYCount) {
            ChildLayerInfo childLayerInfo = this.getChildLayerInfoByLayout(layoutX, layoutY);
            if (childLayerInfo == null) {
                return null;
            }
            if (y >= childLayerInfo.getHeightOffset() && y < childLayerInfo.getHeightOffset() + childLayerInfo.getLayer().getHeight()) {
                return childLayerInfo;
            }
            ++layoutY;
        }
        return null;
    }

    private ChildLayerInfo getChildLayerInfoByX(int x) {
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            ChildLayerInfo childLayerInfo = this.getChildLayerInfoByLayout(layoutX, 0);
            if (childLayerInfo == null) {
                return null;
            }
            if (x >= childLayerInfo.getWidthOffset() && x < childLayerInfo.getWidthOffset() + childLayerInfo.getLayer().getWidth()) {
                return childLayerInfo;
            }
            ++layoutX;
        }
        return null;
    }

    protected ChildLayerInfo getChildLayerInfoByColumnPosition(int compositeColumnPosition) {
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            ChildLayerInfo childLayerInfo = this.getChildLayerInfoByLayout(layoutX, 0);
            if (compositeColumnPosition >= childLayerInfo.getColumnPositionOffset() && compositeColumnPosition < childLayerInfo.getColumnPositionOffset() + childLayerInfo.getLayer().getColumnCount()) {
                return childLayerInfo;
            }
            ++layoutX;
        }
        return null;
    }

    protected ChildLayerInfo getChildLayerInfoByRowPosition(int compositeRowPosition) {
        int layoutY = 0;
        while (layoutY < this.layoutYCount) {
            ChildLayerInfo childLayerInfo = this.getChildLayerInfoByLayout(0, layoutY);
            if (compositeRowPosition >= childLayerInfo.getRowPositionOffset() && compositeRowPosition < childLayerInfo.getRowPositionOffset() + childLayerInfo.getLayer().getRowCount()) {
                return childLayerInfo;
            }
            ++layoutY;
        }
        return null;
    }

    protected ChildLayerInfo getChildLayerInfoByPosition(int compositeColumnPosition, int compositeRowPosition) {
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            ChildLayerInfo childLayerInfo = this.getChildLayerInfoByLayout(layoutX, 0);
            if (compositeColumnPosition >= childLayerInfo.getColumnPositionOffset() && compositeColumnPosition < childLayerInfo.getColumnPositionOffset() + childLayerInfo.getLayer().getColumnCount()) break;
            ++layoutX;
        }
        if (layoutX >= this.layoutXCount) {
            return null;
        }
        int layoutY = 0;
        while (layoutY < this.layoutYCount) {
            ChildLayerInfo childLayerInfo = this.getChildLayerInfoByLayout(layoutX, layoutY);
            if (compositeRowPosition >= childLayerInfo.getRowPositionOffset() && compositeRowPosition < childLayerInfo.getRowPositionOffset() + childLayerInfo.getLayer().getRowCount()) {
                return childLayerInfo;
            }
            ++layoutY;
        }
        return null;
    }

    protected ChildLayerInfo getChildLayerInfoByLayout(int layoutX, int layoutY) {
        if (layoutX >= this.layoutXCount || layoutY >= this.layoutYCount) {
            return null;
        }
        if (this.childLayerInfos == null) {
            this.populateChildLayerInfos();
        }
        return this.childLayerInfos[layoutX][layoutY];
    }

    protected ChildLayerInfo getChildLayerInfoByChildLayer(ILayer childLayer) {
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            int layoutY = 0;
            while (layoutY < this.layoutYCount) {
                if (childLayer == this.childLayerLayout[layoutX][layoutY]) {
                    return this.getChildLayerInfoByLayout(layoutX, layoutY);
                }
                ++layoutY;
            }
            ++layoutX;
        }
        return null;
    }

    protected void populateChildLayerInfos() {
        this.childLayerInfos = new ChildLayerInfo[this.layoutXCount][this.layoutYCount];
        int columnPositionOffset = 0;
        int widthOffset = 0;
        int layoutX = 0;
        while (layoutX < this.layoutXCount) {
            int rowPositionOffset = 0;
            int heightOffset = 0;
            int layoutY = 0;
            while (layoutY < this.layoutYCount) {
                ILayer childLayer = this.childLayerLayout[layoutX][layoutY];
                this.childLayerInfos[layoutX][layoutY] = new ChildLayerInfo(childLayer, columnPositionOffset, rowPositionOffset, widthOffset, heightOffset);
                if (layoutY < this.layoutYCount - 1) {
                    rowPositionOffset += childLayer.getRowCount();
                    heightOffset += childLayer.getHeight();
                }
                ++layoutY;
            }
            if (layoutX < this.layoutXCount - 1) {
                ILayer childLayer = this.childLayerLayout[layoutX][0];
                columnPositionOffset += childLayer.getColumnCount();
                widthOffset += childLayer.getWidth();
            }
            ++layoutX;
        }
    }

    protected static final class ChildLayerInfo {
        private final ILayer layer;
        private final int columnPositionOffset;
        private final int rowPositionOffset;
        private final int widthOffset;
        private final int heightOffset;

        public ChildLayerInfo(ILayer layer, int columnPositionOffset, int rowPositionOffset, int widthOffset, int heightOffset) {
            this.layer = layer;
            this.columnPositionOffset = columnPositionOffset;
            this.rowPositionOffset = rowPositionOffset;
            this.widthOffset = widthOffset;
            this.heightOffset = heightOffset;
        }

        public ILayer getLayer() {
            return this.layer;
        }

        public int getColumnPositionOffset() {
            return this.columnPositionOffset;
        }

        public int getRowPositionOffset() {
            return this.rowPositionOffset;
        }

        public int getWidthOffset() {
            return this.widthOffset;
        }

        public int getHeightOffset() {
            return this.heightOffset;
        }
    }

    protected class CompositeLayerPainter
    implements ILayerPainter {
        protected CompositeLayerPainter() {
        }

        public void paintLayer(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle rectangle, IConfigRegistry configuration) {
            int x = xOffset;
            int layoutX = 0;
            while (layoutX < CompositeLayer.this.layoutXCount) {
                int y = yOffset;
                int layoutY = 0;
                while (layoutY < CompositeLayer.this.layoutYCount) {
                    ILayer childLayer = CompositeLayer.this.childLayerLayout[layoutX][layoutY];
                    Rectangle childLayerRectangle = new Rectangle(x, y, childLayer.getWidth(), childLayer.getHeight());
                    childLayerRectangle = rectangle.intersection(childLayerRectangle);
                    Rectangle originalClipping = gc.getClipping();
                    gc.setClipping(childLayerRectangle);
                    childLayer.getLayerPainter().paintLayer(natLayer, gc, x, y, childLayerRectangle, configuration);
                    gc.setClipping(originalClipping);
                    y += childLayer.getHeight();
                    ++layoutY;
                }
                x += CompositeLayer.this.childLayerLayout[layoutX][0].getWidth();
                ++layoutX;
            }
        }

        public Rectangle adjustCellBounds(int columnPosition, int rowPosition, Rectangle cellBounds) {
            ChildLayerInfo childLayerInfo = CompositeLayer.this.getChildLayerInfoByPosition(columnPosition, rowPosition);
            if (childLayerInfo == null) {
                return null;
            }
            int widthOffset = childLayerInfo.getWidthOffset();
            int heightOffset = childLayerInfo.getHeightOffset();
            cellBounds.x -= widthOffset;
            cellBounds.y -= heightOffset;
            ILayerPainter childLayerPainter = childLayerInfo.getLayer().getLayerPainter();
            int childColumnPosition = columnPosition - childLayerInfo.getColumnPositionOffset();
            int childRowPosition = rowPosition - childLayerInfo.getRowPositionOffset();
            Rectangle adjustedChildCellBounds = childLayerPainter.adjustCellBounds(childColumnPosition, childRowPosition, cellBounds);
            adjustedChildCellBounds.x += widthOffset;
            adjustedChildCellBounds.y += heightOffset;
            return adjustedChildCellBounds;
        }
    }
}

