/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.painter.cell.decorator;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.BackgroundPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class XPBackgroundDecorator
extends BackgroundPainter {
    public final Color separatorColor = GUIHelper.getColor(199, 197, 178);
    public final Color gradientColor1 = GUIHelper.getColor(226, 222, 205);
    public final Color gradientColor2 = GUIHelper.getColor(214, 210, 194);
    public final Color gradientColor3 = GUIHelper.getColor(203, 199, 184);
    public final Color highlightColor1 = GUIHelper.getColor(250, 171, 0);
    public final Color highlightColor2 = GUIHelper.getColor(252, 194, 71);
    public final Color highlightColor3 = GUIHelper.getColor(250, 178, 24);

    public XPBackgroundDecorator(ICellPainter interiorPainter) {
        super(interiorPainter);
    }

    public int getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return super.getPreferredWidth(cell, gc, configRegistry) + 4;
    }

    public int getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return super.getPreferredHeight(cell, gc, configRegistry) + 4;
    }

    public void paintCell(ILayerCell cell, GC gc, Rectangle rectangle, IConfigRegistry configRegistry) {
        super.paintCell(cell, gc, rectangle, configRegistry);
        Rectangle interiorBounds = new Rectangle(rectangle.x + 2, rectangle.y + 2, rectangle.width - 4, rectangle.height - 4);
        super.paintCell(cell, gc, interiorBounds, configRegistry);
        Color originalBackground = gc.getBackground();
        Color originalForeground = gc.getForeground();
        int x = rectangle.x;
        gc.setForeground(GUIHelper.COLOR_WHITE);
        gc.drawLine(x, rectangle.y + 3, x, rectangle.y + rectangle.height - 6);
        x = rectangle.x + rectangle.width - 1;
        gc.setForeground(this.separatorColor);
        gc.drawLine(x, rectangle.y + 3, x, rectangle.y + rectangle.height - 6);
        gc.setBackground(originalBackground);
        gc.setForeground(originalForeground);
        boolean isHighlight = false;
        int y = rectangle.y + rectangle.height - 3;
        gc.setForeground(isHighlight ? this.highlightColor1 : this.gradientColor1);
        gc.drawLine(rectangle.x, y, rectangle.x + rectangle.width, y);
        gc.setForeground(isHighlight ? this.highlightColor2 : this.gradientColor2);
        gc.drawLine(rectangle.x, ++y, rectangle.x + rectangle.width, y);
        gc.setForeground(isHighlight ? this.highlightColor3 : this.gradientColor3);
        gc.drawLine(rectangle.x, ++y, rectangle.x + rectangle.width, y);
    }
}

