/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.painter.layer;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.painter.IOverlayPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class NatLayerPainter
implements ILayerPainter {
    private final NatTable natTable;

    public NatLayerPainter(NatTable natTable) {
        this.natTable = natTable;
    }

    public void paintLayer(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle rectangle, IConfigRegistry configRegistry) {
        try {
            this.paintBackground(natLayer, gc, xOffset, yOffset, rectangle, configRegistry);
            gc.setForeground(this.natTable.getForeground());
            ILayerPainter layerPainter = this.natTable.getLayer().getLayerPainter();
            layerPainter.paintLayer(natLayer, gc, xOffset, yOffset, rectangle, configRegistry);
            this.paintOverlays(natLayer, gc, xOffset, yOffset, rectangle, configRegistry);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.err.println("Error while painting table: " + e.getMessage());
        }
    }

    protected void paintBackground(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle rectangle, IConfigRegistry configRegistry) {
        gc.setBackground(this.natTable.getBackground());
        gc.fillRectangle(rectangle);
    }

    protected void paintOverlays(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle rectangle, IConfigRegistry configRegistry) {
        for (IOverlayPainter overlayPainter : this.natTable.getOverlayPainters()) {
            overlayPainter.paintOverlay(gc, this.natTable);
        }
    }

    public Rectangle adjustCellBounds(int columnPosition, int rowPosition, Rectangle cellBounds) {
        ILayerPainter layerPainter = this.natTable.getLayer().getLayerPainter();
        return layerPainter.adjustCellBounds(columnPosition, rowPosition, cellBounds);
    }
}

