/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.style.editor;

import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.style.BorderStyle;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.style.editor.AbstractStyleEditorDialog;
import org.eclipse.nebula.widgets.nattable.style.editor.BorderStyleEditorPanel;
import org.eclipse.nebula.widgets.nattable.style.editor.CellStyleEditorPanel;
import org.eclipse.nebula.widgets.nattable.style.editor.SeparatorPanel;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ColumnStyleEditorDialog
extends AbstractStyleEditorDialog {
    private CellStyleEditorPanel cellStyleEditorPanel;
    private BorderStyleEditorPanel borderStyleEditorPanel;
    protected Style newColumnCellStyle;
    protected BorderStyle newBorderStyle;
    private final Style columnStyle;

    public ColumnStyleEditorDialog(Shell parent, Style columnCellStyle) {
        super(parent);
        this.columnStyle = columnCellStyle;
        this.newColumnCellStyle = columnCellStyle;
        if (columnCellStyle != null) {
            this.newBorderStyle = this.columnStyle.getAttributeValue(CellStyleAttributes.BORDER_STYLE);
        }
    }

    protected void initComponents(final Shell shell) {
        shell.setLayout((Layout)new GridLayout());
        shell.setText(Messages.getString("ColumnStyleEditorDialog.shellTitle"));
        shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                ColumnStyleEditorDialog.this.doFormCancel(shell);
            }
        });
        Composite tabPanel = new Composite((Composite)shell, 0);
        tabPanel.setLayout((Layout)new GridLayout());
        GridData fillGridData = new GridData();
        fillGridData.grabExcessHorizontalSpace = true;
        fillGridData.horizontalAlignment = 4;
        tabPanel.setLayoutData((Object)fillGridData);
        CTabFolder tabFolder = new CTabFolder(tabPanel, 2048);
        tabFolder.setLayout((Layout)new GridLayout());
        tabFolder.setLayoutData((Object)fillGridData);
        CTabItem columnTab = new CTabItem(tabFolder, 0);
        columnTab.setText(Messages.getString("ColumnStyleEditorDialog.column"));
        columnTab.setImage(GUIHelper.getImage("column"));
        columnTab.setControl((Control)this.createColumnPanel((Composite)tabFolder));
        try {
            this.cellStyleEditorPanel.edit(this.columnStyle);
            this.borderStyleEditorPanel.edit(this.columnStyle.getAttributeValue(CellStyleAttributes.BORDER_STYLE));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private Composite createColumnPanel(Composite parent) {
        Composite columnPanel = new Composite(parent, 0);
        columnPanel.setLayout((Layout)new GridLayout());
        new SeparatorPanel(columnPanel, Messages.getString("ColumnStyleEditorDialog.styling"));
        this.cellStyleEditorPanel = new CellStyleEditorPanel(columnPanel, 0);
        new SeparatorPanel(columnPanel, Messages.getString("ColumnStyleEditorDialog.border"));
        this.borderStyleEditorPanel = new BorderStyleEditorPanel(columnPanel, 0);
        return columnPanel;
    }

    protected void doFormOK(Shell shell) {
        this.newColumnCellStyle = this.cellStyleEditorPanel.getNewValue();
        this.newBorderStyle = this.borderStyleEditorPanel.getNewValue();
        shell.dispose();
    }

    protected void doFormClear(Shell shell) {
        this.newColumnCellStyle = null;
        shell.dispose();
    }

    public Style getNewColumnCellStyle() {
        return this.newColumnCellStyle;
    }

    public BorderStyle getNewColumnBorderStyle() {
        return this.newBorderStyle;
    }
}

