/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.examples.INatExample;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractNatExample
implements INatExample {
    private Text outputArea;

    @Override
    public String getName() {
        return this.getClass().getSimpleName().replaceAll("^_[0-9]*_", "").replace('_', ' ');
    }

    @Override
    public String getShortDescription() {
        String description = this.getDescription();
        return description.substring(0, description.indexOf(46) + 1);
    }

    @Override
    public String getDescription() {
        String description = this.getResourceAsString(String.valueOf(this.getClass().getSimpleName()) + ".txt");
        if (description != null) {
            return description;
        }
        return "";
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onStop() {
    }

    private String getResourceAsString(String resource) {
        InputStream inStream = this.getClass().getResourceAsStream(resource);
        if (inStream != null) {
            StringBuffer strBuf = new StringBuffer();
            try {
                int i = -1;
                while ((i = inStream.read()) != -1) {
                    strBuf.append((char)i);
                }
                return strBuf.toString();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Text setupTextArea(Composite parent) {
        this.outputArea = new Text(parent, 2562);
        this.outputArea.setEditable(false);
        GridDataFactory.fillDefaults().grab(true, false).hint(0, 100).align(4, 1).applyTo((Control)this.outputArea);
        return this.outputArea;
    }

    public void log(String msg) {
        if (ObjectUtils.isNotNull((Object)this.outputArea)) {
            this.outputArea.append(String.valueOf(msg) + "\n");
            System.out.println(msg);
        }
    }
}

