/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._800_Integration;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.copy.command.CopyDataCommandHandler;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultIntegerDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.PercentageDisplayConverter;
import org.eclipse.nebula.widgets.nattable.dataset.NumberValues;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsEventLayer;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultSummaryRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.summaryrow.DefaultSummaryRowConfiguration;
import org.eclipse.nebula.widgets.nattable.summaryrow.ISummaryProvider;
import org.eclipse.nebula.widgets.nattable.summaryrow.SummaryDisplayConverter;
import org.eclipse.nebula.widgets.nattable.summaryrow.SummaryRowConfigAttributes;
import org.eclipse.nebula.widgets.nattable.summaryrow.SummaryRowLayer;
import org.eclipse.nebula.widgets.nattable.summaryrow.SummationSummaryProvider;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class _802_CalculatingGridExample
extends AbstractNatExample {
    public static String COLUMN_ONE_LABEL = "ColumnOneLabel";
    public static String COLUMN_TWO_LABEL = "ColumnTwoLabel";
    public static String COLUMN_THREE_LABEL = "ColumnThreeLabel";
    public static String COLUMN_FOUR_LABEL = "ColumnFourLabel";
    public static String COLUMN_FIVE_LABEL = "ColumnFiveLabel";
    private EventList<NumberValues> valuesToShow = GlazedLists.eventList(new ArrayList());

    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(new _802_CalculatingGridExample());
    }

    @Override
    public String getDescription() {
        return "This example demonstrates how to create a NatTable that contains calculated values.\nThe first three columns are editable, while the last two columns contain the calculated values.\nThe values in column four and five will automatically update when committing the edited values.\nThis example also contains a summary row to show that it is even possible to update the summary row in a editable grid.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)panel);
        Composite gridPanel = new Composite(panel, 0);
        gridPanel.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)gridPanel);
        Composite buttonPanel = new Composite(panel, 0);
        buttonPanel.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonPanel);
        String[] propertyNames = new String[]{"columnOneNumber", "columnTwoNumber", "columnThreeNumber", "columnFourNumber", "columnFiveNumber"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("columnOneNumber", "100%");
        propertyToLabelMap.put("columnTwoNumber", "Value One");
        propertyToLabelMap.put("columnThreeNumber", "Value Two");
        propertyToLabelMap.put("columnFourNumber", "Sum");
        propertyToLabelMap.put("columnFiveNumber", "Percentage");
        this.valuesToShow.add((Object)this.createNumberValues());
        this.valuesToShow.add((Object)this.createNumberValues());
        ConfigRegistry configRegistry = new ConfigRegistry();
        CalculatingGridLayer gridLayer = new CalculatingGridLayer(this.valuesToShow, configRegistry, propertyNames, propertyToLabelMap);
        DataLayer bodyDataLayer = gridLayer.getBodyDataLayer();
        ColumnOverrideLabelAccumulator columnLabelAccumulator = new ColumnOverrideLabelAccumulator((ILayer)bodyDataLayer);
        bodyDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)columnLabelAccumulator);
        this.registerColumnLabels(columnLabelAccumulator);
        NatTable natTable = new NatTable(gridPanel, (ILayer)gridLayer, false);
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new CalculatingEditConfiguration());
        natTable.configure();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
        Button addRowButton = new Button(buttonPanel, 8);
        addRowButton.setText("add row");
        addRowButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                _802_CalculatingGridExample.this.valuesToShow.add((Object)_802_CalculatingGridExample.this.createNumberValues());
            }
        });
        Button resetButton = new Button(buttonPanel, 8);
        resetButton.setText("reset");
        resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                _802_CalculatingGridExample.this.valuesToShow.clear();
                _802_CalculatingGridExample.this.valuesToShow.add((Object)_802_CalculatingGridExample.this.createNumberValues());
                _802_CalculatingGridExample.this.valuesToShow.add((Object)_802_CalculatingGridExample.this.createNumberValues());
            }
        });
        return panel;
    }

    private void registerColumnLabels(ColumnOverrideLabelAccumulator columnLabelAccumulator) {
        columnLabelAccumulator.registerColumnOverrides(0, new String[]{COLUMN_ONE_LABEL});
        columnLabelAccumulator.registerColumnOverrides(1, new String[]{COLUMN_TWO_LABEL});
        columnLabelAccumulator.registerColumnOverrides(2, new String[]{COLUMN_THREE_LABEL});
        columnLabelAccumulator.registerColumnOverrides(3, new String[]{COLUMN_FOUR_LABEL});
        columnLabelAccumulator.registerColumnOverrides(4, new String[]{COLUMN_FIVE_LABEL});
    }

    private NumberValues createNumberValues() {
        NumberValues nv = new NumberValues();
        nv.setColumnOneNumber(100);
        nv.setColumnTwoNumber(20);
        nv.setColumnThreeNumber(30);
        return nv;
    }

    class CalculatingBodyLayerStack
    extends AbstractLayerTransform {
        private final DataLayer bodyDataLayer;
        private final GlazedListsEventLayer<NumberValues> glazedListsEventLayer;
        private final SummaryRowLayer summaryRowLayer;
        private final ColumnReorderLayer columnReorderLayer;
        private final ColumnHideShowLayer columnHideShowLayer;
        private final SelectionLayer selectionLayer;
        private final ViewportLayer viewportLayer;

        public CalculatingBodyLayerStack(EventList<NumberValues> valuesToShow, ConfigRegistry configRegistry) {
            ListDataProvider dataProvider = new ListDataProvider(valuesToShow, (IColumnAccessor)new CalculatingDataProvider());
            this.bodyDataLayer = new DataLayer((IDataProvider)dataProvider);
            this.glazedListsEventLayer = new GlazedListsEventLayer((IUniqueIndexLayer)this.bodyDataLayer, valuesToShow);
            this.summaryRowLayer = new SummaryRowLayer(this.glazedListsEventLayer, (IConfigRegistry)configRegistry, false);
            this.summaryRowLayer.addConfiguration((IConfiguration)new CalculatingSummaryRowConfiguration(this.bodyDataLayer.getDataProvider()));
            this.columnReorderLayer = new ColumnReorderLayer((IUniqueIndexLayer)this.summaryRowLayer);
            this.columnHideShowLayer = new ColumnHideShowLayer((IUniqueIndexLayer)this.columnReorderLayer);
            this.selectionLayer = new SelectionLayer((IUniqueIndexLayer)this.columnHideShowLayer);
            this.viewportLayer = new ViewportLayer((IUniqueIndexLayer)this.selectionLayer);
            this.setUnderlyingLayer((ILayer)this.viewportLayer);
            this.registerCommandHandler((ILayerCommandHandler)new CopyDataCommandHandler(this.selectionLayer));
        }

        public DataLayer getDataLayer() {
            return this.bodyDataLayer;
        }

        public SelectionLayer getSelectionLayer() {
            return this.selectionLayer;
        }
    }

    class CalculatingDataProvider
    implements IColumnAccessor<NumberValues> {
        CalculatingDataProvider() {
        }

        public Object getDataValue(NumberValues rowObject, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return rowObject.getColumnOneNumber();
                }
                case 1: {
                    return rowObject.getColumnTwoNumber();
                }
                case 2: {
                    return rowObject.getColumnThreeNumber();
                }
                case 3: {
                    return rowObject.getColumnTwoNumber() + rowObject.getColumnThreeNumber();
                }
                case 4: {
                    return new Double(rowObject.getColumnTwoNumber() + rowObject.getColumnThreeNumber()) / (double)rowObject.getColumnOneNumber();
                }
            }
            return null;
        }

        public void setDataValue(NumberValues rowObject, int columnIndex, Object newValue) {
            switch (columnIndex) {
                case 0: {
                    rowObject.setColumnOneNumber(((Integer)newValue).intValue());
                    break;
                }
                case 1: {
                    rowObject.setColumnTwoNumber(((Integer)newValue).intValue());
                    break;
                }
                case 2: {
                    rowObject.setColumnThreeNumber(((Integer)newValue).intValue());
                }
            }
        }

        public int getColumnCount() {
            return 5;
        }
    }

    class CalculatingEditConfiguration
    extends AbstractRegistryConfiguration {
        CalculatingEditConfiguration() {
        }

        public void configureRegistry(IConfigRegistry configRegistry) {
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE);
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.NEVER_EDITABLE, "EDIT", COLUMN_FOUR_LABEL);
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.NEVER_EDITABLE, "EDIT", COLUMN_FIVE_LABEL);
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.NEVER_EDITABLE, "EDIT", "SummaryRow");
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultIntegerDisplayConverter(), "NORMAL");
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultIntegerDisplayConverter(), "EDIT");
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new PercentageDisplayConverter(), "NORMAL", COLUMN_FIVE_LABEL);
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new SummaryDisplayConverter((IDisplayConverter)new DefaultIntegerDisplayConverter()), "NORMAL", "SummaryRow");
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new SummaryDisplayConverter((IDisplayConverter)new PercentageDisplayConverter()), "NORMAL", "SummaryColumn_4");
        }
    }

    class CalculatingGridLayer
    extends GridLayer {
        public CalculatingGridLayer(EventList<NumberValues> valuesToShow, ConfigRegistry configRegistry, String[] propertyNames, Map<String, String> propertyToLabelMap) {
            super(true);
            this.init(valuesToShow, configRegistry, propertyNames, propertyToLabelMap);
        }

        private void init(EventList<NumberValues> valuesToShow, ConfigRegistry configRegistry, String[] propertyNames, Map<String, String> propertyToLabelMap) {
            CalculatingBodyLayerStack bodyLayer = new CalculatingBodyLayerStack(valuesToShow, configRegistry);
            SelectionLayer selectionLayer = bodyLayer.getSelectionLayer();
            DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
            ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)new DefaultColumnHeaderDataLayer((IDataProvider)columnHeaderDataProvider), (ILayer)bodyLayer, selectionLayer);
            DefaultSummaryRowHeaderDataProvider rowHeaderDataProvider = new DefaultSummaryRowHeaderDataProvider(bodyLayer.getDataLayer().getDataProvider(), "\u2211");
            RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider), (ILayer)bodyLayer, selectionLayer);
            CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider)), (ILayer)rowHeaderLayer, (ILayer)columnHeaderLayer);
            this.setBodyLayer((ILayer)bodyLayer);
            this.setColumnHeaderLayer((ILayer)columnHeaderLayer);
            this.setRowHeaderLayer((ILayer)rowHeaderLayer);
            this.setCornerLayer((ILayer)cornerLayer);
        }

        public DataLayer getBodyDataLayer() {
            return ((CalculatingBodyLayerStack)this.getBodyLayer()).getDataLayer();
        }
    }

    class CalculatingSummaryRowConfiguration
    extends DefaultSummaryRowConfiguration {
        private final IDataProvider dataProvider;

        public CalculatingSummaryRowConfiguration(IDataProvider dataProvider) {
            this.dataProvider = dataProvider;
            this.summaryRowBgColor = GUIHelper.COLOR_BLUE;
            this.summaryRowFgColor = GUIHelper.COLOR_WHITE;
        }

        public void addSummaryProviderConfig(IConfigRegistry configRegistry) {
            configRegistry.registerConfigAttribute(SummaryRowConfigAttributes.SUMMARY_PROVIDER, (Object)new SummationSummaryProvider(this.dataProvider), "NORMAL", "SummaryRow");
            configRegistry.registerConfigAttribute(SummaryRowConfigAttributes.SUMMARY_PROVIDER, (Object)new AverageSummaryProvider(), "NORMAL", "SummaryColumn_4");
        }

        class AverageSummaryProvider
        implements ISummaryProvider {
            AverageSummaryProvider() {
            }

            public Object summarize(int columnIndex) {
                double total = 0.0;
                int rowCount = CalculatingSummaryRowConfiguration.this.dataProvider.getRowCount();
                int rowIndex = 0;
                while (rowIndex < rowCount) {
                    Object dataValue = CalculatingSummaryRowConfiguration.this.dataProvider.getDataValue(columnIndex, rowIndex);
                    total += Double.parseDouble(dataValue.toString());
                    ++rowIndex;
                }
                return total / (double)rowCount;
            }
        }
    }
}

