/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.examples._103_Events;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.blink.BlinkConfigAttributes;
import org.eclipse.nebula.widgets.nattable.blink.BlinkLayer;
import org.eclipse.nebula.widgets.nattable.blink.BlinkingCellResolver;
import org.eclipse.nebula.widgets.nattable.blink.IBlinkingCellResolver;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyResolver;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowIdAccessor;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsEventLayer;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultGridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class BlinkingGlazedListExample
extends AbstractNatExample {
    private static final String BLINK_UP_CONFIG_LABEL = "blinkUpConfigLabel";
    private static final String BLINK_DOWN_CONFIG_LABEL = "blinkDownConfigLabel";
    private final Timer timer = new Timer();
    private final EventList<Tuple> baseTupleList;
    private final List<String> headers = new ArrayList<String>();
    private final BasicEventList<Tuple> eventList;

    public static void main(String[] args) {
        StandaloneNatExampleRunner.run(800, 400, new BlinkingGlazedListExample());
    }

    public BlinkingGlazedListExample() {
        this.headers.add("Name");
        this.headers.add("Value");
        this.headers.add("Price");
        this.headers.add("Quantity");
        this.eventList = new BasicEventList();
        this.baseTupleList = GlazedLists.threadSafeList(this.eventList);
    }

    @Override
    public String getDescription() {
        return "Cell blinking";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        this.baseTupleList.add((Object)new Tuple(this.headers, new Object[]{"Name 1", "Value 1", 1.5, -1000}, 0L));
        this.baseTupleList.add((Object)new Tuple(this.headers, new Object[]{"Name 2", "Value 2", -2.5, 2000}, 1L));
        this.baseTupleList.add((Object)new Tuple(this.headers, new Object[]{"Name 3", "Value 3", 3.5, -3000}, 2L));
        this.baseTupleList.add((Object)new Tuple(this.headers, new Object[]{"Name 4", "Value 4", -4.5, 4000}, 3L));
        this.baseTupleList.add((Object)new Tuple(this.headers, new Object[]{"Name 5", "Value 5", 5.5, -5000}, 4L));
        ConfigRegistry configRegistry = new ConfigRegistry();
        ObservableElementList observableTupleList = new ObservableElementList(this.baseTupleList, GlazedLists.beanConnector(Tuple.class));
        TupleColumnPropertyAccessor columnPropertyAccessor = new TupleColumnPropertyAccessor();
        ListDataProvider bodyDataProvider = new ListDataProvider((List)observableTupleList, (IColumnAccessor)columnPropertyAccessor);
        DataLayer bodyDataLayer = new DataLayer((IDataProvider)bodyDataProvider);
        GlazedListsEventLayer glazedListEventsLayer = new GlazedListsEventLayer((IUniqueIndexLayer)bodyDataLayer, this.baseTupleList);
        BlinkLayer blinkingLayer = new BlinkLayer((IUniqueIndexLayer)glazedListEventsLayer, (IRowDataProvider)bodyDataProvider, this.getRowIdAccessor(), (IColumnPropertyResolver)columnPropertyAccessor, (IConfigRegistry)configRegistry);
        this.registerBlinkingConfigCells(configRegistry);
        try {
            this.baseTupleList.getReadWriteLock().readLock().lock();
            for (Tuple tuple : this.baseTupleList) {
                tuple.addPropertyChangeListener((PropertyChangeListener)glazedListEventsLayer);
            }
        }
        finally {
            this.baseTupleList.getReadWriteLock().readLock().unlock();
        }
        ColumnHeaderDataProvider defaultColumnHeaderDataProvider = new ColumnHeaderDataProvider();
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider((IDataProvider)bodyDataProvider);
        DefaultCornerDataProvider defaultCornerDataProvider = new DefaultCornerDataProvider((IDataProvider)defaultColumnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        DefaultGridLayer gridLayer = new DefaultGridLayer((IUniqueIndexLayer)blinkingLayer, (IUniqueIndexLayer)new DefaultColumnHeaderDataLayer((IDataProvider)defaultColumnHeaderDataProvider), (IUniqueIndexLayer)new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider), (IUniqueIndexLayer)new DataLayer((IDataProvider)defaultCornerDataProvider));
        NatTable natTable = new NatTable(parent, (ILayer)gridLayer, false);
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.configure();
        return natTable;
    }

    private IRowIdAccessor<Tuple> getRowIdAccessor() {
        return new IRowIdAccessor<Tuple>(){

            public Serializable getRowId(Tuple rowObject) {
                return Long.valueOf(rowObject.id);
            }
        };
    }

    @Override
    public void onStart() {
        this.timer.schedule((TimerTask)new UpdateTupleTask(), 500L, 2000L);
    }

    @Override
    public void onStop() {
        this.timer.cancel();
    }

    private void registerBlinkingConfigCells(ConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(BlinkConfigAttributes.BLINK_RESOLVER, (Object)this.getBlinkResolver(), "NORMAL");
        Style cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)Display.getDefault().getSystemColor(5));
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, "NORMAL", BLINK_UP_CONFIG_LABEL);
        cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)Display.getDefault().getSystemColor(3));
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, "NORMAL", BLINK_DOWN_CONFIG_LABEL);
    }

    private IBlinkingCellResolver getBlinkResolver() {
        return new BlinkingCellResolver(){
            private final String[] configLabels = new String[1];

            public String[] resolve(Object oldValue, Object newValue) {
                int old = (Integer)oldValue;
                int latest = (Integer)newValue;
                this.configLabels[0] = latest > old ? BlinkingGlazedListExample.BLINK_UP_CONFIG_LABEL : BlinkingGlazedListExample.BLINK_DOWN_CONFIG_LABEL;
                return this.configLabels;
            }
        };
    }

    public class ColumnHeaderDataProvider
    implements IDataProvider {
        public int getColumnCount() {
            return BlinkingGlazedListExample.this.headers.size();
        }

        public Object getDataValue(int columnIndex, int rowIndex) {
            return BlinkingGlazedListExample.this.headers.get(columnIndex);
        }

        public int getRowCount() {
            return 1;
        }

        public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
        }
    }

    public class Tuple
    implements Comparable<Tuple> {
        private final Object[] objects;
        private final List<String> propertyNames;
        private final long id;
        private final PropertyChangeSupport support;

        public Tuple(List<String> propertyNames, Object[] objects, long id) {
            this.propertyNames = propertyNames;
            this.objects = objects;
            this.id = id;
            this.support = new PropertyChangeSupport(this);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.support.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.support.removePropertyChangeListener(listener);
        }

        public Object getValue(int index) {
            return this.objects[index];
        }

        public void update(int index, Object newValue) {
            Object oldValue = this.objects[index];
            this.objects[index] = newValue;
            System.out.println("Update: " + newValue);
            this.support.firePropertyChange(this.propertyNames.get(index), oldValue, newValue);
        }

        @Override
        public int compareTo(Tuple o) {
            return 0;
        }
    }

    public class TupleColumnPropertyAccessor
    implements IColumnPropertyAccessor<Tuple> {
        public int getColumnCount() {
            return BlinkingGlazedListExample.this.headers.size();
        }

        public Object getDataValue(Tuple tuple, int colIndex) {
            return tuple.getValue(colIndex);
        }

        public void setDataValue(Tuple arg0, int arg1, Object arg2) {
        }

        public int getColumnIndex(String propertyName) {
            return BlinkingGlazedListExample.this.headers.indexOf(propertyName);
        }

        public String getColumnProperty(int columnIndex) {
            return (String)BlinkingGlazedListExample.this.headers.get(columnIndex);
        }
    }

    public class UpdateTupleTask
    extends TimerTask {
        @Override
        public void run() {
            Tuple toUpdate = (Tuple)BlinkingGlazedListExample.this.baseTupleList.get(2);
            Integer existingValue = (Integer)toUpdate.getValue(3);
            toUpdate.update(3, existingValue * -1);
        }
    }
}

