/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.coordinate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;

public class PositionUtil {
    public static List<List<Integer>> getGroupedByContiguous(Collection<Integer> numberCollection) {
        ArrayList<Integer> numbers = new ArrayList<Integer>(numberCollection);
        Collections.sort(numbers);
        ArrayList<Integer> contiguous = new ArrayList<Integer>();
        ArrayList<List<Integer>> grouped = new ArrayList<List<Integer>>();
        int i = 0;
        while (i < numbers.size() - 1) {
            if ((Integer)numbers.get(i) + 1 != (Integer)numbers.get(i + 1)) {
                contiguous.add((Integer)numbers.get(i));
                grouped.add(contiguous);
                contiguous = new ArrayList();
            } else {
                contiguous.add((Integer)numbers.get(i));
            }
            ++i;
        }
        if (ObjectUtils.isNotEmpty(numbers)) {
            contiguous.add((Integer)numbers.get(numbers.size() - 1));
        }
        grouped.add(contiguous);
        return grouped;
    }

    public static List<Range> getRanges(Collection<Integer> numbers) {
        ArrayList<Range> ranges = null;
        if (ObjectUtils.isNotEmpty(numbers)) {
            List<List<Integer>> grouped = PositionUtil.getGroupedByContiguous(numbers);
            ranges = new ArrayList(grouped.size());
            for (List<Integer> number : grouped) {
                int start = number.get(0);
                int end = number.get(number.size() - 1) + 1;
                ranges.add(new Range(start, end));
            }
        }
        return ranges != null ? ranges : new ArrayList<Range>();
    }

    public static List<Range> getRanges(int ... numbers) {
        ArrayList<Integer> numberCollection = new ArrayList<Integer>(numbers.length);
        int[] nArray = numbers;
        int n = numbers.length;
        int n2 = 0;
        while (n2 < n) {
            int number = nArray[n2];
            numberCollection.add(number);
            ++n2;
        }
        return PositionUtil.getRanges(numberCollection);
    }

    public static int[] getPositions(Collection<Range> ranges) {
        if (ranges == null || ranges.size() == 0) {
            return new int[0];
        }
        HashSet<Integer> positions = new HashSet<Integer>();
        for (Range r : ranges) {
            int i = r.start;
            while (i < r.end) {
                if (i >= 0) {
                    positions.add(i);
                }
                ++i;
            }
        }
        int[] result = new int[positions.size()];
        int index = 0;
        Iterator iterator = positions.iterator();
        while (iterator.hasNext()) {
            int pos;
            result[index] = pos = ((Integer)iterator.next()).intValue();
            ++index;
        }
        Arrays.sort(result);
        return result;
    }

    public static int[] getPositions(Range ... ranges) {
        return PositionUtil.getPositions(Arrays.asList(ranges));
    }

    public static Range joinConsecutiveRanges(Collection<Range> ranges) {
        if (ranges == null || ranges.isEmpty()) {
            return null;
        }
        ArrayList<Range> sortedRanges = new ArrayList<Range>(ranges);
        Collections.sort(sortedRanges, new Comparator<Range>(){

            @Override
            public int compare(Range o1, Range o2) {
                if (o1.start == o2.start) {
                    return o1.end < o2.end ? -1 : (o1.end == o2.end ? 0 : 1);
                }
                return o1.start < o2.start ? -1 : (o1.start == o2.start ? 0 : 1);
            }
        });
        int start = ((Range)sortedRanges.get((int)0)).start;
        int end = ((Range)sortedRanges.get((int)0)).end;
        int i = 1;
        while (i < sortedRanges.size()) {
            Range range = (Range)sortedRanges.get(i);
            if (range.start > end) {
                return null;
            }
            end = Math.max(end, range.end);
            ++i;
        }
        return new Range(start, end);
    }

    public static List<Range> mergeRanges(Collection<Range> ranges) {
        TreeSet<Integer> numbers = new TreeSet<Integer>();
        for (Range range : ranges) {
            int number = range.start;
            while (number < range.end) {
                numbers.add(number);
                ++number;
            }
        }
        return PositionUtil.getRanges(numbers);
    }

    public static SelectionLayer.MoveDirectionEnum getHorizontalMoveDirection(int fromPosition, int toPosition) {
        if (fromPosition > toPosition) {
            return SelectionLayer.MoveDirectionEnum.LEFT;
        }
        if (fromPosition < toPosition) {
            return SelectionLayer.MoveDirectionEnum.RIGHT;
        }
        return SelectionLayer.MoveDirectionEnum.NONE;
    }

    public static SelectionLayer.MoveDirectionEnum getVerticalMoveDirection(int fromRowPosition, int toRowPosition) {
        if (fromRowPosition > toRowPosition) {
            return SelectionLayer.MoveDirectionEnum.UP;
        }
        if (fromRowPosition < toRowPosition) {
            return SelectionLayer.MoveDirectionEnum.DOWN;
        }
        return SelectionLayer.MoveDirectionEnum.NONE;
    }
}

