/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 *
 * This package provides classes to perform curve fitting.
 *
 * <p>Curve fitting is a special case of a least squares problem
 * were the parameters are the coefficients of a function <code>f</code>
 * whose graph <code>y=f(x)</code> should pass through sample points, and
 * were the objective function is the squared sum of residuals
 * <code>f(x<sub>i</sub>)-y<sub>i</sub></code> for observed points
 * (x<sub>i</sub>, y<sub>i</sub>).</p>
 *
 *
 */
package org.apache.commons.math3.optimization.fitting;
