/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.freeze.command;

import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.freeze.FreezeHelper;
import org.eclipse.nebula.widgets.nattable.freeze.FreezeLayer;
import org.eclipse.nebula.widgets.nattable.freeze.command.IFreezeCoordinatesProvider;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;

public class FreezeSelectionStrategy
implements IFreezeCoordinatesProvider {
    private final FreezeLayer freezeLayer;
    private final ViewportLayer viewportLayer;
    private final SelectionLayer selectionLayer;
    private final boolean include;

    public FreezeSelectionStrategy(FreezeLayer freezeLayer, ViewportLayer viewportLayer, SelectionLayer selectionLayer) {
        this(freezeLayer, viewportLayer, selectionLayer, false);
    }

    public FreezeSelectionStrategy(FreezeLayer freezeLayer, ViewportLayer viewportLayer, SelectionLayer selectionLayer, boolean include) {
        this.freezeLayer = freezeLayer;
        this.viewportLayer = viewportLayer;
        this.selectionLayer = selectionLayer;
        this.include = include;
    }

    @Override
    public PositionCoordinate getTopLeftPosition() {
        int rowPosition;
        PositionCoordinate lastSelectedCellPosition = this.selectionLayer.getLastSelectedCellPosition();
        if (lastSelectedCellPosition == null) {
            return null;
        }
        int selectedColumnPosition = this.getUnderlyingColumnPosition(lastSelectedCellPosition.columnPosition);
        int selectedRowPosition = this.getUnderlyingRowPosition(lastSelectedCellPosition.rowPosition);
        ILayerCell lastSelectedCell = this.selectionLayer.getCellByPosition(lastSelectedCellPosition.columnPosition, lastSelectedCellPosition.rowPosition);
        int columnPosition = FreezeHelper.getTopLeftColumnPosition(this.viewportLayer);
        if (columnPosition > 0 && columnPosition >= selectedColumnPosition) {
            columnPosition = !this.include ? selectedColumnPosition - 1 : selectedColumnPosition + lastSelectedCell.getColumnSpan() - 1;
        }
        if ((rowPosition = this.viewportLayer.getScrollableLayer().getRowPositionByY(this.viewportLayer.getOrigin().getY())) > 0 && rowPosition >= selectedRowPosition) {
            rowPosition = !this.include ? selectedRowPosition - 1 : selectedRowPosition - lastSelectedCell.getRowSpan() - 1;
        }
        return new PositionCoordinate(this.freezeLayer, columnPosition, rowPosition);
    }

    @Override
    public PositionCoordinate getBottomRightPosition() {
        if (this.selectionLayer.getSelectedCells().size() > 1) {
            PositionCoordinate[] coords;
            if (this.selectionLayer.getFullySelectedColumnPositions().length > 0) {
                int[] selColPos;
                int columnPosition = 0;
                int[] nArray = selColPos = this.selectionLayer.getFullySelectedColumnPositions();
                int n = selColPos.length;
                int n2 = 0;
                while (n2 < n) {
                    int col = nArray[n2];
                    columnPosition = Math.max(columnPosition, col);
                    ++n2;
                }
                return new PositionCoordinate(this.freezeLayer, this.getUnderlyingColumnPosition(columnPosition), -1);
            }
            if (this.selectionLayer.getFullySelectedRowPositions().length > 0) {
                int[] selRowPos;
                int rowPosition = 0;
                int[] nArray = selRowPos = this.selectionLayer.getFullySelectedRowPositions();
                int n = selRowPos.length;
                int n3 = 0;
                while (n3 < n) {
                    int row = nArray[n3];
                    rowPosition = Math.max(rowPosition, row);
                    ++n3;
                }
                return new PositionCoordinate(this.freezeLayer, -1, this.getUnderlyingRowPosition(rowPosition));
            }
            int columnPosition = -1;
            int rowPosition = -1;
            PositionCoordinate[] positionCoordinateArray = coords = this.selectionLayer.getSelectedCellPositions();
            int n = coords.length;
            int n4 = 0;
            while (n4 < n) {
                PositionCoordinate coord = positionCoordinateArray[n4];
                columnPosition = columnPosition < 0 ? coord.columnPosition : (!this.include ? Math.min(columnPosition, coord.columnPosition) : Math.max(columnPosition, coord.columnPosition));
                rowPosition = rowPosition < 0 ? coord.rowPosition : (!this.include ? Math.min(rowPosition, coord.rowPosition) : Math.max(rowPosition, coord.rowPosition));
                ++n4;
            }
            int column = this.getUnderlyingColumnPosition(columnPosition);
            int row = this.getUnderlyingRowPosition(rowPosition);
            return new PositionCoordinate(this.freezeLayer, !this.include ? column - 1 : column, !this.include ? row - 1 : row);
        }
        PositionCoordinate selectionAnchor = this.selectionLayer.getSelectionAnchor();
        if (selectionAnchor != null) {
            int column = this.getUnderlyingColumnPosition(selectionAnchor.columnPosition);
            int row = this.getUnderlyingRowPosition(selectionAnchor.rowPosition);
            if (!this.include) {
                return new PositionCoordinate(this.freezeLayer, column - 1, row - 1);
            }
            ILayerCell selectionAnchorCell = this.selectionLayer.getCellByPosition(selectionAnchor.columnPosition, selectionAnchor.rowPosition);
            return new PositionCoordinate(this.freezeLayer, column + selectionAnchorCell.getColumnSpan() - 1, row + selectionAnchorCell.getRowSpan() - 1);
        }
        return null;
    }

    protected int getUnderlyingColumnPosition(int columnPosition) {
        if (this.viewportLayer.getScrollableLayer() == this.selectionLayer) {
            return columnPosition;
        }
        return LayerUtil.convertColumnPosition(this.selectionLayer, columnPosition, this.viewportLayer.getScrollableLayer());
    }

    protected int getUnderlyingRowPosition(int rowPosition) {
        if (this.viewportLayer.getScrollableLayer() == this.selectionLayer) {
            return rowPosition;
        }
        return LayerUtil.convertRowPosition(this.selectionLayer, rowPosition, this.viewportLayer.getScrollableLayer());
    }
}

