/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.datachange;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowIdAccessor;
import org.eclipse.nebula.widgets.nattable.datachange.CellKeyHandler;
import org.eclipse.nebula.widgets.nattable.datachange.IdIndexIdentifier;

public class IdIndexKeyHandler<T>
implements CellKeyHandler<IdIndexIdentifier<T>> {
    private final IRowDataProvider<T> rowDataProvider;
    private final IRowIdAccessor<T> rowIdAccessor;
    private Class<?> clazz;

    public IdIndexKeyHandler(IRowDataProvider<T> rowDataProvider, IRowIdAccessor<T> rowIdAccessor) {
        this.rowDataProvider = rowDataProvider;
        this.rowIdAccessor = rowIdAccessor;
        Method[] methodArray = this.rowIdAccessor.getClass().getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Class<?>[] classArray = method.getParameterTypes();
            int n3 = classArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Class<?> class1 = classArray[n4];
                if (class1 != Object.class) {
                    this.clazz = class1;
                }
                ++n4;
            }
            ++n2;
        }
    }

    @Override
    public IdIndexIdentifier<T> getKey(int columnIndex, int rowIndex) {
        T rowObject;
        if (rowIndex >= 0 && rowIndex < this.rowDataProvider.getRowCount() && (rowObject = this.rowDataProvider.getRowObject(rowIndex)).getClass().equals(this.clazz)) {
            Serializable rowId = this.rowIdAccessor.getRowId(rowObject);
            return new IdIndexIdentifier<T>(columnIndex, rowId, rowObject);
        }
        return null;
    }

    @Override
    public IdIndexIdentifier<T> getKeyWithColumnUpdate(IdIndexIdentifier<T> oldKey, int columnIndex) {
        return new IdIndexIdentifier(columnIndex, oldKey.rowId, oldKey.rowObject);
    }

    @Override
    public IdIndexIdentifier<T> getKeyWithRowUpdate(IdIndexIdentifier<T> oldKey, int rowIndex) {
        return this.getKey(oldKey.columnIndex, rowIndex);
    }

    @Override
    public int getColumnIndex(IdIndexIdentifier<T> key) {
        return key.columnIndex;
    }

    @Override
    public int getRowIndex(IdIndexIdentifier<T> key) {
        return this.rowDataProvider.indexOfRowObject(key.rowObject);
    }

    @Override
    public boolean updateOnHorizontalStructuralChange() {
        return true;
    }

    @Override
    public boolean updateOnVerticalStructuralChange() {
        return false;
    }
}

