/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.copyinheritance;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.StateHelper;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.copyinheritance.CopyInheritance;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.StandardElementGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.Protections;

public class TypeLevel {
    public static CopyInheritance.SupertypeObligation[] connectRoleClasses(ReferenceBinding superTeam, TypeDeclaration roleDecl) {
        ArrayList<CopyInheritance.SupertypeObligation> obligations = new ArrayList<CopyInheritance.SupertypeObligation>();
        ReferenceBinding[] tsuperRoles = roleDecl.getRoleModel().getTSuperRoleBindings();
        SourceTypeBinding destRole = roleDecl.binding;
        if (tsuperRoles.length > 0) {
            ReferenceBinding tsuperRole = tsuperRoles[tsuperRoles.length - 1];
            assert (tsuperRole.isDirectRole());
            TypeLevel.mergeSuperinterfaces(superTeam, tsuperRole, destRole);
            if (!roleDecl.isInterface()) {
                TypeLevel.copyAdjustSuperclass(tsuperRole, roleDecl, obligations);
            }
            TypeLevel.copyBaseclass(tsuperRole, roleDecl);
        } else {
            TypeLevel.copyAdjustSuperclass(null, roleDecl, obligations);
        }
        TypeLevel.adjustSuperinterfaces(superTeam, destRole, obligations);
        if (destRole != null) {
            destRole.resetIncompatibleTypes();
        }
        CopyInheritance.SupertypeObligation[] result = new CopyInheritance.SupertypeObligation[obligations.size()];
        obligations.toArray(result);
        return result;
    }

    private static void adjustSuperinterfaces(ReferenceBinding superTeam, SourceTypeBinding destRole, ArrayList<CopyInheritance.SupertypeObligation> obligations) {
        if (destRole == null) {
            return;
        }
        ReferenceBinding[] superinterfaces = destRole.superInterfaces();
        if (superinterfaces != null) {
            int i = 0;
            while (i < superinterfaces.length) {
                ReferenceBinding teamType;
                ReferenceBinding superinterface;
                if (TypeBinding.equalsEquals(superinterfaces[i].enclosingType(), superTeam) && TypeBinding.notEquals(superinterface = (teamType = destRole.enclosingType()).getMemberType(superinterfaces[i].internalName()), destRole)) {
                    obligations.add(new CopyInheritance.SupertypeObligation(superinterface, superinterfaces[i], null, null));
                    superinterfaces[i] = superinterfaces[i].transferTypeArguments(superinterface);
                    destRole.scope.compilationUnitScope().recordSuperTypeReference(superinterface);
                }
                ++i;
            }
        }
    }

    private static void copyBaseclass(ReferenceBinding srcRole, TypeDeclaration destRoleDecl) {
        SourceTypeBinding destRole = destRoleDecl.binding;
        ReferenceBinding srcErasure = (ReferenceBinding)srcRole.erasure();
        if (srcErasure.isBinaryBinding() || StateHelper.hasState(srcRole, 7)) {
            if (srcRole.rawBaseclass() != null && destRoleDecl.baseclass == null) {
                destRole.baseclass = TypeLevel.checkAdjustImplicitlyRefinedBase(srcRole.baseclass, destRoleDecl, destRole);
                destRoleDecl.scope.compilationUnitScope().recordSuperTypeReference(destRole.baseclass);
                if (destRole.baseclass.isValidBinding() && TypeBinding.notEquals(srcRole.baseclass, destRole.baseclass)) {
                    StandardElementGenerator.checkCreateBaseField(destRoleDecl, destRole.baseclass, false);
                }
            }
        } else {
            TypeDeclaration srcDecl = srcErasure.roleModel.getAst();
            if (srcDecl.baseclass != null && destRoleDecl.baseclass == null) {
                long pos = ((long)destRoleDecl.sourceStart << 32) + (long)destRoleDecl.sourceEnd;
                destRoleDecl.baseclass = new AstGenerator(pos).alienScopeTypeReference(srcDecl.baseclass, srcDecl.scope.parent);
                destRoleDecl.baseclass.setBaseclassDecapsulation(Expression.DecapsulationState.REPORTED);
                destRoleDecl.baseclass.isGenerated = true;
            }
        }
    }

    private static ReferenceBinding checkAdjustImplicitlyRefinedBase(ReferenceBinding baseclass, TypeDeclaration destRoleDecl, SourceTypeBinding destRole) {
        if (RoleTypeBinding.isRoleWithExplicitAnchor(baseclass) && ((RoleTypeBinding)baseclass)._teamAnchor.isBaseAnchor() && destRoleDecl.enclosingType != null && destRoleDecl.enclosingType.baseclass != null) {
            ReferenceBinding destEnclosing = destRole.enclosingType();
            ReferenceBinding outerBase = destEnclosing.baseclass();
            if (!outerBase.isCompatibleWith(baseclass.enclosingType())) {
                return baseclass;
            }
            ReferenceBinding innerBase = outerBase.getMemberType(baseclass.sourceName());
            FieldBinding outerBaseField = destEnclosing.getField(IOTConstants._OT_BASE, true);
            assert (outerBaseField != null);
            TypeBinding[] typeArguments = baseclass.isParameterizedType() ? ((ParameterizedTypeBinding)baseclass).arguments : null;
            TypeBinding innerBaseRoleType = outerBaseField.getDependentTypeBinding(innerBase, -1, typeArguments, 0);
            return ((RoleTypeBinding)innerBaseRoleType).weakenFrom(baseclass);
        }
        return baseclass;
    }

    static void mergeSuperinterfaces(ReferenceBinding superTeam, ReferenceBinding srcRole, SourceTypeBinding destRole) {
        ReferenceBinding[] srcSuperIfcs = srcRole.superInterfaces();
        if (srcSuperIfcs == null || srcSuperIfcs.length == 0) {
            return;
        }
        HashSet<ReferenceBinding> newInterfaces = new HashSet<ReferenceBinding>();
        if (destRole.superInterfaces != null) {
            int i = 0;
            while (i < destRole.superInterfaces.length) {
                newInterfaces.add(destRole.superInterfaces[i]);
                ++i;
            }
        }
        ReferenceBinding destTeam = destRole.enclosingType();
        int i = 0;
        while (i < srcSuperIfcs.length) {
            ReferenceBinding newSuperIfc = srcSuperIfcs[i];
            if (!CharOperation.equals(srcSuperIfcs[i].internalName(), destRole.internalName())) {
                if ((newSuperIfc = destTeam.getMemberType(newSuperIfc.internalName())) == null) {
                    newSuperIfc = srcSuperIfcs[i];
                }
                if (newSuperIfc == null) {
                    throw new InternalCompilerError("superinterface not found for " + new String(destRole.internalName()) + ": " + new String(srcSuperIfcs[i].readableName()));
                }
                if (superTeam.isParameterizedType()) {
                    newSuperIfc = (ReferenceBinding)Scope.substitute((Substitution)((ParameterizedTypeBinding)superTeam), newSuperIfc);
                }
                newInterfaces.add(newSuperIfc);
                destRole.scope.compilationUnitScope().recordSuperTypeReference(newSuperIfc);
            }
            ++i;
        }
        destRole.superInterfaces = new ReferenceBinding[newInterfaces.size()];
        System.arraycopy(newInterfaces.toArray(), 0, destRole.superInterfaces, 0, newInterfaces.size());
    }

    public static void addImplicitInheritance(TypeDeclaration roleInterfaceDeclaration, ReferenceBinding superrole) {
        assert ((roleInterfaceDeclaration.binding.tagBits & 0x100L) != 0L) : "binding should be connected";
        int modifiers = roleInterfaceDeclaration.modifiers;
        int inheritedModifiers = superrole.modifiers;
        if (!Protections.isAsVisible(modifiers, inheritedModifiers)) {
            roleInterfaceDeclaration.scope.problemReporter().reducingRoleVisibility(roleInterfaceDeclaration, modifiers, inheritedModifiers);
        }
        ReferenceBinding[] superInterfaces = roleInterfaceDeclaration.binding.superInterfaces;
        ReferenceBinding[] newSuperInterfaces = null;
        int len = 0;
        if (superInterfaces != null) {
            int i = 0;
            while (i < superInterfaces.length) {
                if (TypeBinding.equalsEquals(superInterfaces[i], superrole)) {
                    return;
                }
                ++i;
            }
            len = superInterfaces.length;
            newSuperInterfaces = new ReferenceBinding[len + 1];
            System.arraycopy(superInterfaces, 0, newSuperInterfaces, 0, len);
        } else {
            newSuperInterfaces = new ReferenceBinding[1];
        }
        newSuperInterfaces[len] = superrole;
        roleInterfaceDeclaration.scope.compilationUnitScope().recordSuperTypeReference(superrole);
        roleInterfaceDeclaration.binding.superInterfaces = newSuperInterfaces;
    }

    static void copyAdjustSuperclass(ReferenceBinding tsuperRole, TypeDeclaration destRoleDecl, ArrayList<CopyInheritance.SupertypeObligation> obligations) {
        if (tsuperRole != null && destRoleDecl.superclass == null && CharOperation.equals(tsuperRole.internalName(), IOTConstants.OTCONFINED)) {
            destRoleDecl.superclass = new AstGenerator(destRoleDecl).typeReference(tsuperRole);
            destRoleDecl.superclass.resolvedType = tsuperRole;
            destRoleDecl.binding.superclass = tsuperRole;
            return;
        }
        if (destRoleDecl.binding == null) {
            return;
        }
        ReferenceBinding destTeam = destRoleDecl.binding.enclosingType();
        assert (destTeam != null);
        TypeLevel.checkAdjustSuperclass(destRoleDecl, destTeam, tsuperRole, obligations);
    }

    private static void checkAdjustSuperclass(TypeDeclaration destRoleDecl, ReferenceBinding destTeam, ReferenceBinding tsuperRole, ArrayList<CopyInheritance.SupertypeObligation> obligations) {
        TypeReference newExtends;
        ClassScope destScope = destRoleDecl.scope;
        ReferenceBinding inheritedSuperclass = null;
        ReferenceBinding newSuperclass = destRoleDecl.binding.superclass;
        boolean refineToTeam = false;
        if (tsuperRole != null) {
            inheritedSuperclass = tsuperRole.superclass();
            boolean bl = refineToTeam = !tsuperRole.isTeam() && destRoleDecl.isTeam();
            if (tsuperRole.isTeam() && !destRoleDecl.isTeam()) {
                destScope.problemReporter().regularOverridesTeam(destRoleDecl, tsuperRole);
                return;
            }
        }
        if ((newExtends = destRoleDecl.superclass) == null && newSuperclass != null && !refineToTeam && (newSuperclass.id == 1 || destScope.isOrgObjectteamsTeam(newSuperclass))) {
            newSuperclass = null;
        }
        if (newSuperclass != null && CharOperation.equals(newSuperclass.internalName(), IOTConstants.OTCONFINED) && (inheritedSuperclass == null || CharOperation.equals(inheritedSuperclass.internalName(), IOTConstants.OTCONFINED))) {
            return;
        }
        if (newSuperclass != null && newSuperclass.isDirectRole() && !TeamModel.areCompatibleEnclosings(destTeam, newSuperclass.original().enclosingType())) {
            destScope.problemReporter().extendIncompatibleEnclosingTypes(destRoleDecl, newSuperclass, newSuperclass.enclosingType());
            destRoleDecl.binding.superclass = inheritedSuperclass != null ? inheritedSuperclass : destScope.getJavaLangObject();
            return;
        }
        if (newSuperclass != null) {
            newSuperclass = TypeLevel.strengthenSuper(destTeam, newSuperclass);
        }
        if (inheritedSuperclass != null) {
            inheritedSuperclass = TypeLevel.strengthenSuper(destTeam, inheritedSuperclass);
            if (newSuperclass == null) {
                newSuperclass = inheritedSuperclass;
            } else if (TypeBinding.notEquals(newSuperclass, inheritedSuperclass)) {
                if (newSuperclass.roleModel == null || !newSuperclass.roleModel.hasTSuperRole(inheritedSuperclass)) {
                    CopyInheritance.SupertypeObligation oblig = new CopyInheritance.SupertypeObligation(newSuperclass, inheritedSuperclass, newExtends, tsuperRole);
                    if (obligations != null) {
                        obligations.add(oblig);
                    } else {
                        oblig.check(destRoleDecl);
                    }
                }
                destRoleDecl.getRoleModel()._refinesExtends = true;
            }
        }
        if (newSuperclass != null && !TypeBinding.equalsEquals(newSuperclass, destRoleDecl.binding)) {
            if (newSuperclass.isCompatibleWith(destRoleDecl.binding)) {
                destRoleDecl.scope.problemReporter().hierarchyCircularity(destRoleDecl.binding, newSuperclass, destRoleDecl);
                destRoleDecl.binding.tagBits |= 0x20000L;
                newSuperclass.tagBits |= 0x20000L;
            } else {
                destRoleDecl.binding.superclass = destRoleDecl.binding.superclass.transferTypeArguments(newSuperclass);
                destRoleDecl.scope.compilationUnitScope().recordSuperTypeReference(newSuperclass);
            }
        }
    }

    static ReferenceBinding strengthenSuper(ReferenceBinding destTeam, ReferenceBinding superRole) {
        if (!superRole.isRole()) {
            return superRole;
        }
        if (TeamModel.isTeamContainingRole(destTeam.superclass(), superRole)) {
            return destTeam.getMemberType(superRole.internalName());
        }
        if (destTeam.isRole()) {
            ReferenceBinding[] tsuperTeams = destTeam.roleModel.getTSuperRoleBindings();
            int i = tsuperTeams.length - 1;
            while (i >= 0) {
                if (TypeBinding.equalsEquals(tsuperTeams[i], superRole.enclosingType())) {
                    return destTeam.getMemberType(superRole.internalName());
                }
                if (TeamModel.isTeamContainingRole(tsuperTeams[i], superRole)) {
                    ReferenceBinding strongEnclosing = destTeam.getMemberType(superRole.enclosingType().internalName());
                    if (strongEnclosing != null) {
                        return TypeLevel.strengthenSuper(strongEnclosing, superRole);
                    }
                    return superRole;
                }
                --i;
            }
        }
        return superRole;
    }
}

