/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.samples;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.objectteams.otdt.internal.samples.Messages;
import org.eclipse.objectteams.otdt.internal.samples.OTSamplesPlugin;
import org.eclipse.objectteams.otdt.internal.samples.PDEImages;
import org.eclipse.objectteams.otdt.internal.samples.ProjectNamesPage;
import org.eclipse.objectteams.otdt.internal.samples.ReviewPage;
import org.eclipse.objectteams.otdt.internal.samples.SampleOperation;
import org.eclipse.objectteams.otdt.internal.samples.SelectionPage;
import org.eclipse.objectteams.otdt.ui.help.OTHelpPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.osgi.framework.Bundle;

public class SampleWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private IConfigurationElement[] samples;
    private IConfigurationElement selection;
    private ProjectNamesPage namesPage;
    private ReviewPage lastPage;
    private boolean switchPerspective = true;
    private boolean selectRevealEnabled = true;
    private boolean activitiesEnabled = true;
    private IProject[] createdProjects;
    private PDEImages pdeImages = PDEImages.connect((Object)this);

    public SampleWizard() {
        this.setDefaultPageImageDescriptor(PDEImages.DESC_NEWEXP_WIZ);
        this.samples = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.pde.ui.samples");
        this.namesPage = new ProjectNamesPage(this);
        this.lastPage = new ReviewPage(this);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.ShowSampleAction_title);
    }

    public void dispose() {
        this.pdeImages.disconnect((Object)this);
        super.dispose();
    }

    public IConfigurationElement[] getSamples() {
        return this.samples;
    }

    public void addPages() {
        if (this.selection == null) {
            this.addPage((IWizardPage)new SelectionPage(this));
        }
        this.addPage((IWizardPage)this.namesPage);
        this.addPage((IWizardPage)this.lastPage);
    }

    public boolean performFinish() {
        try {
            String perspId = this.selection.getAttribute("perspectiveId");
            IWorkbenchPage page = OTSamplesPlugin.getActivePage();
            if (perspId != null && this.switchPerspective) {
                PlatformUI.getWorkbench().showPerspective(perspId, page.getWorkbenchWindow());
            }
            SampleOperation op = new SampleOperation(this.selection, this.namesPage.getProjectNames(), new ImportOverwriteQuery());
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
            this.createdProjects = op.getCreatedProjects();
            if (this.selectRevealEnabled) {
                this.selectReveal(this.getShell());
            }
            if (this.activitiesEnabled) {
                this.enableActivities();
            }
        }
        catch (InvocationTargetException e) {
            OTSamplesPlugin.logException(e, null, null);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (CoreException e) {
            OTSamplesPlugin.logException(e, null, null);
            return false;
        }
        catch (OperationCanceledException operationCanceledException) {
            return false;
        }
        return true;
    }

    public void selectReveal(Shell shell) {
        shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                SampleWizard.this.doSelectReveal();
            }
        });
    }

    private void doSelectReveal() {
        if (this.selection == null || this.createdProjects == null) {
            return;
        }
        String viewId = this.selection.getAttribute("targetViewId");
        if (viewId == null) {
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        IViewPart view = page.findView(viewId);
        if (view == null || !(view instanceof ISetSelectionTarget)) {
            return;
        }
        ISetSelectionTarget target = (ISetSelectionTarget)view;
        IConfigurationElement[] projects = this.selection.getChildren("project");
        ArrayList<IResource> items = new ArrayList<IResource>();
        int i = 0;
        while (i < projects.length) {
            IResource resource;
            String path = projects[i].getAttribute("selectReveal");
            if (path != null && (resource = this.createdProjects[i].findMember(path)) != null && resource.exists()) {
                if (resource.getName().equals("Intro0.html")) {
                    resource = this.setBaseTag(this.createdProjects[i], resource);
                }
                items.add(resource);
            }
            ++i;
        }
        if (items.size() > 0) {
            target.selectReveal((ISelection)new StructuredSelection(items));
        }
        this.revealInEditor(items, page);
    }

    private IResource setBaseTag(IProject project, IResource resource) {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            try {
                NullProgressMonitor npm = new NullProgressMonitor();
                Bundle helpBundle = OTHelpPlugin.getDocPlugin();
                String absPath = FileLocator.toFileURL((URL)helpBundle.getEntry("/")).toString();
                String baseTag = "<base href=\"" + absPath + "\">\n";
                IFile newFile = project.getFile("Intro.html");
                ByteArrayInputStream stream = new ByteArrayInputStream(baseTag.getBytes("UTF8"));
                newFile.create((InputStream)stream, false, (IProgressMonitor)npm);
                newFile.appendContents(file.getContents(), 0, (IProgressMonitor)npm);
                stream.close();
                resource.delete(false, (IProgressMonitor)npm);
                return newFile;
            }
            catch (Exception e) {
                OTSamplesPlugin.getDefault().getLog().log((IStatus)OTSamplesPlugin.createErrorStatus("Failed to convert Intro.html", e));
            }
        }
        return resource;
    }

    void revealInEditor(List<IResource> items, IWorkbenchPage page) {
        if (items.size() > 0) {
            for (IResource resource : items) {
                if (!(resource instanceof IFile)) continue;
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)resource));
                }
                catch (PartInitException partInitException) {}
            }
        }
    }

    public void enableActivities() {
        IConfigurationElement[] elements = this.selection.getChildren("activity");
        HashSet<String> activitiesToEnable = new HashSet<String>();
        IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            String id = element.getAttribute("id");
            if (id != null) {
                activitiesToEnable.add(id);
            }
            ++i;
        }
        HashSet<String> set = new HashSet<String>(workbenchActivitySupport.getActivityManager().getEnabledActivityIds());
        set.addAll(activitiesToEnable);
        workbenchActivitySupport.setEnabledActivityIds(set);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        String variable;
        String string = variable = data != null && data instanceof String ? data.toString() : null;
        if (variable != null) {
            int i = 0;
            while (i < this.samples.length) {
                IConfigurationElement element = this.samples[i];
                String id = element.getAttribute("id");
                if (id != null && id.equals(variable)) {
                    this.setSelection(element);
                    break;
                }
                ++i;
            }
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public IConfigurationElement getSelection() {
        return this.selection;
    }

    public void setSelection(IConfigurationElement selection) {
        this.selection = selection;
    }

    public void setSwitchPerspective(boolean switchPerspective) {
        this.switchPerspective = switchPerspective;
    }

    public void setSelectRevealEnabled(boolean selectRevealEnabled) {
        this.selectRevealEnabled = selectRevealEnabled;
    }

    public void setActivitiesEnabled(boolean activitiesEnabled) {
        this.activitiesEnabled = activitiesEnabled;
    }

    public void updateEntries() {
        this.namesPage.updateEntries();
    }

    private class ImportOverwriteQuery
    implements IOverwriteQuery {
        private ImportOverwriteQuery() {
        }

        public String queryOverwrite(String file) {
            String[] returnCodes = new String[]{"YES", "NO", "ALL", "CANCEL"};
            int returnVal = this.openDialog(file);
            return returnVal < 0 ? "CANCEL" : returnCodes[returnVal];
        }

        private int openDialog(final String file) {
            final int[] result = new int[]{1};
            SampleWizard.this.getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    String title = Messages.SampleWizard_title;
                    String msg = NLS.bind((String)Messages.SampleWizard_overwrite, (Object)file);
                    String[] options = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL};
                    MessageDialog dialog = new MessageDialog(SampleWizard.this.getShell(), title, null, msg, 3, options, 0);
                    result[0] = dialog.open();
                }
            });
            return result[0];
        }
    }
}

