/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode.asm;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.objectteams.otredyn.transformer.names.ClassNames;
import org.objectweb.asm.ClassReader;

public class ASMByteCodeAnalyzer {
    boolean useExternalForm = false;
    private Map<String, ClassInformation> classInformationMap = new ConcurrentHashMap<String, ClassInformation>(512, 0.75f, 4);

    public ASMByteCodeAnalyzer(boolean useExternalForm) {
        this.useExternalForm = useExternalForm;
    }

    public ClassInformation getClassInformation(InputStream classStream, String className) {
        try {
            return this.getClassInformation(null, classStream, className);
        }
        catch (IOException e) {
            return null;
        }
    }

    public ClassInformation getClassInformation(byte[] classBytes, String className) {
        try {
            return this.getClassInformation(classBytes, null, className);
        }
        catch (IOException e) {
            return null;
        }
    }

    private ClassInformation getClassInformation(byte[] classBytes, InputStream classStream, String className) throws IOException {
        ClassInformation classInformation = this.classInformationMap.get(className);
        if (classInformation != null) {
            return classInformation;
        }
        ClassReader classReader = classBytes != null ? new ClassReader(classBytes) : new ClassReader(classStream);
        classInformation = new ClassInformation(classReader);
        this.classInformationMap.put(className, classInformation);
        return classInformation;
    }

    public ClassInformation getClassInformation(String className, ClassLoader loader) {
        ClassInformation classInformation = this.classInformationMap.get(className);
        if (classInformation != null) {
            return classInformation;
        }
        try {
            Class<?> clazz = loader.loadClass(className.replace('/', '.'));
            if (clazz != null) {
                return new ClassInformation(clazz);
            }
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        return null;
    }

    public class ClassInformation {
        private int modifiers;
        private String superClassName;
        private String[] superInterfaceNames;

        ClassInformation(ClassReader classReader) {
            this.modifiers = classReader.getAccess();
            this.superClassName = classReader.getSuperName();
            this.superInterfaceNames = classReader.getInterfaces();
        }

        public ClassInformation(Class<?> clazz) {
            this.modifiers = clazz.getModifiers();
            Class<?> superclass = clazz.getSuperclass();
            this.superClassName = superclass != null ? superclass.getName().replace('.', '/') : ClassNames.OBJECT_SLASH;
            Class<?>[] interfaces = clazz.getInterfaces();
            this.superInterfaceNames = new String[interfaces.length];
            int i = 0;
            while (i < interfaces.length) {
                this.superInterfaceNames[i] = interfaces[i].getName().replace('.', '/');
                ++i;
            }
        }

        public boolean isInterface() {
            return (this.modifiers & 0x200) != 0;
        }

        public String getSuperClassName() {
            if (this.superClassName != null) {
                return ASMByteCodeAnalyzer.this.useExternalForm ? this.superClassName.replace('/', '.') : this.superClassName;
            }
            return null;
        }

        public String[] getSuperInterfaceNames() {
            if (this.superInterfaceNames != null && ASMByteCodeAnalyzer.this.useExternalForm) {
                int i = 0;
                while (i < this.superInterfaceNames.length) {
                    this.superInterfaceNames[i] = this.superInterfaceNames[i].replace('/', '.');
                    ++i;
                }
            }
            return this.superInterfaceNames;
        }
    }
}

