/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode.asm;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.objectteams.otredyn.bytecode.AbstractBoundClass;
import org.eclipse.objectteams.otredyn.bytecode.Binding;
import org.eclipse.objectteams.otredyn.bytecode.ClassRepository;
import org.eclipse.objectteams.otredyn.bytecode.asm.AsmBoundClass;
import org.eclipse.objectteams.otredyn.runtime.ClassIdentifierProviderFactory;
import org.eclipse.objectteams.otredyn.runtime.IBinding;
import org.eclipse.objectteams.otredyn.runtime.IClassIdentifierProvider;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Label;

public abstract class Attributes {
    protected static final String ATTRIBUTE_OT_DYN_CALLIN_BINDINGS = "OTDynCallinBindings";
    protected static final String ATTRIBUTE_ROLE_BASE_BINDINGS = "CallinRoleBaseBindings";
    protected static final String ATTRIBUTE_CALLIN_PRECEDENCE = "CallinPrecedence";
    public static final String ATTRIBUTE_OT_CLASS_FLAGS = "OTClassFlags";
    protected static final String ATTRIBUTE_OT_SPECIAL_ACCESS = "OTSpecialAccess";
    public static final String ATTRIBUTE_OT_COMPILER_VERSION = "OTCompilerVersion";
    public static final int OTDRE_FLAG = 32768;
    protected static final Attribute[] attributes = new Attribute[]{new CallinBindingsAttribute(0), new RoleBaseBindingsAttribute(0), new CallinPrecedenceAttribute(0), new OTClassFlagsAttribute(0), new OTSpecialAccessAttribute(), new OTCompilerVersion(0)};

    protected static class CallinBindingsAttribute
    extends Attribute {
        static final short COVARIANT_BASE_RETURN = 8;
        static final short BASE_SUPER_CALL = 16;
        private MultiBinding[] bindings;

        public CallinBindingsAttribute(int bindingsCount) {
            super(Attributes.ATTRIBUTE_OT_DYN_CALLIN_BINDINGS);
            this.bindings = new MultiBinding[bindingsCount];
        }

        private void addBinding(int i, String roleName, String callinLabel, String baseClassName, String[] baseMethodNames, String[] baseMethodSignatures, String[] declaringBaseClassNames, String callinModifierName, int[] callinIds, int[] baseFlags, int flags) {
            int callinModifier = 0;
            callinModifier = "before".equals(callinModifierName) ? 1 : ("after".equals(callinModifierName) ? 3 : 2);
            this.bindings[i] = new MultiBinding(roleName, callinLabel, baseClassName, baseMethodNames, baseMethodSignatures, declaringBaseClassNames, callinModifier, callinIds, baseFlags, flags);
        }

        protected Attribute read(ClassReader cr, int off, int len, char[] buf, int codeOff, Label[] labels) {
            int bindingsCount = cr.readShort(off);
            off += 2;
            CallinBindingsAttribute attr = new CallinBindingsAttribute(bindingsCount);
            int i = 0;
            while (i < bindingsCount) {
                String roleName = cr.readUTF8(off, buf);
                String callinLabel = cr.readUTF8(off += 2, buf);
                off += 2;
                String callinModifier = cr.readUTF8(off += 4, buf);
                int flags = cr.readByte(off += 2);
                String baseClassName = cr.readUTF8(++off, buf);
                off += 2;
                int baseMethodsCount = cr.readShort(off += 6);
                off += 2;
                String[] baseMethodNames = new String[baseMethodsCount];
                String[] baseMethodSignatures = new String[baseMethodsCount];
                String[] declaringBaseClassNames = new String[baseMethodsCount];
                int[] callinIds = new int[baseMethodsCount];
                int[] baseFlags = new int[baseMethodsCount];
                int m = 0;
                while (m < baseMethodsCount) {
                    baseMethodNames[m] = cr.readUTF8(off, buf);
                    baseMethodSignatures[m] = cr.readUTF8(off += 2, buf);
                    declaringBaseClassNames[m] = cr.readUTF8(off += 2, buf);
                    callinIds[m] = cr.readInt(off += 2);
                    baseFlags[m] = cr.readByte(off += 4);
                    ++off;
                    off += 2;
                    ++m;
                }
                attr.addBinding(i, roleName, callinLabel, baseClassName, baseMethodNames, baseMethodSignatures, declaringBaseClassNames, callinModifier, callinIds, baseFlags, flags);
                ++i;
            }
            return attr;
        }

        public MultiBinding[] getBindings() {
            return this.bindings;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            MultiBinding[] multiBindingArray = this.bindings;
            int n = this.bindings.length;
            int n2 = 0;
            while (n2 < n) {
                MultiBinding binding = multiBindingArray[n2];
                buf.append(binding.getBaseClassName());
                int[] callinIds = binding.getCallinIds();
                String[] baseMethodNames = binding.getBaseMethodNames();
                String[] baseMethodSignatures = binding.getBaseMethodSignatures();
                int i = 0;
                while (i < callinIds.length) {
                    buf.append("\n\t{");
                    buf.append(callinIds[i]);
                    buf.append("} ");
                    buf.append(baseMethodNames[i]);
                    buf.append(baseMethodSignatures[i]);
                    ++i;
                }
                ++n2;
            }
            return buf.toString();
        }

        protected static class MultiBinding {
            private String roleClassName;
            private String callinLabel;
            private String baseClassName;
            private String[] baseMethodNames;
            private String[] baseMethodSignatures;
            private String[] declaringBaseClassNames;
            private int callinModifier;
            private int[] callinIds;
            private int[] baseFlags;
            private boolean isHandleCovariantReturn;
            private boolean requireBaseSuperCall;

            MultiBinding(String roleName, String callinLabel, String baseClassName, String[] baseMethodNames, String[] baseMethodSignatures, String[] declaringBaseClassNames, int callinModifier, int[] callinIds, int[] baseFlags, int flags) {
                this.roleClassName = roleName;
                this.callinLabel = callinLabel;
                this.baseClassName = baseClassName;
                this.baseMethodNames = baseMethodNames;
                this.baseMethodSignatures = baseMethodSignatures;
                this.declaringBaseClassNames = declaringBaseClassNames;
                this.callinModifier = callinModifier;
                this.callinIds = callinIds;
                this.baseFlags = baseFlags;
                this.isHandleCovariantReturn = (flags & 8) != 0;
                this.requireBaseSuperCall = (flags & 0x10) != 0;
            }

            protected String getRoleClassName() {
                return this.roleClassName;
            }

            protected String getBaseClassName() {
                return this.baseClassName;
            }

            protected String[] getBaseMethodNames() {
                return this.baseMethodNames;
            }

            protected String[] getBaseMethodSignatures() {
                return this.baseMethodSignatures;
            }

            protected int getCallinModifier() {
                return this.callinModifier;
            }

            protected int[] getCallinIds() {
                return this.callinIds;
            }

            public int[] getBaseFlags() {
                return this.baseFlags;
            }

            protected String getCallinLabel() {
                return this.callinLabel;
            }

            public boolean isHandleCovariantReturn() {
                return this.isHandleCovariantReturn;
            }

            public boolean requiresBaseSuperCall() {
                return this.requireBaseSuperCall;
            }

            public String[] getDeclaringBaseClassName() {
                return this.declaringBaseClassNames;
            }
        }
    }

    protected static class CallinPrecedenceAttribute
    extends Attribute {
        String[] labels;

        public CallinPrecedenceAttribute(int elementCount) {
            super(Attributes.ATTRIBUTE_CALLIN_PRECEDENCE);
            this.labels = new String[elementCount];
        }

        protected Attribute read(ClassReader cr, int off, int len, char[] buf, int codeOff, Label[] labels) {
            int elementCount = cr.readShort(off);
            off += 2;
            CallinPrecedenceAttribute attr = new CallinPrecedenceAttribute(elementCount);
            int i = 0;
            while (i < elementCount) {
                attr.labels[i] = cr.readUTF8(off, buf);
                off += 2;
                ++i;
            }
            return attr;
        }
    }

    protected static class OTClassFlagsAttribute
    extends Attribute {
        int flags;

        protected OTClassFlagsAttribute(int flags) {
            super(Attributes.ATTRIBUTE_OT_CLASS_FLAGS);
            this.flags = flags;
        }

        protected Attribute read(ClassReader cr, int off, int len, char[] buf, int codeOff, Label[] labels) {
            return new OTClassFlagsAttribute(cr.readUnsignedShort(off));
        }
    }

    protected static class OTCompilerVersion
    extends Attribute {
        private int version;

        protected OTCompilerVersion(int version) {
            super(Attributes.ATTRIBUTE_OT_COMPILER_VERSION);
            this.version = version;
        }

        protected Attribute read(ClassReader cr, int off, int len, char[] buf, int codeOff, Label[] labels) {
            int encodedVersion = cr.readUnsignedShort(off);
            if ((encodedVersion & 0x8000) == 0) {
                throw new UnsupportedClassVersionError("OTDRE: Class " + cr.getClassName() + " was compiled for incompatible weaving target OTRE");
            }
            return new OTCompilerVersion(encodedVersion);
        }

        public String toString() {
            return this.type + " " + this.version;
        }
    }

    protected static class OTSpecialAccessAttribute
    extends Attribute {
        private static final int DECAPSULATION_METHOD_ACCESS = 4;
        private static final int CALLOUT_FIELD_ACCESS = 5;
        List<DecapsMethod> methods = new ArrayList<DecapsMethod>();
        List<DecapsField> fields = new ArrayList<DecapsField>();
        List<String> decapsulatedBaseClasses = new ArrayList<String>();

        protected OTSpecialAccessAttribute() {
            super(Attributes.ATTRIBUTE_OT_SPECIAL_ACCESS);
        }

        protected Attribute read(ClassReader cr, int off, int len, char[] buf, int codeOff, Label[] labels) {
            OTSpecialAccessAttribute attr = new OTSpecialAccessAttribute();
            int size = cr.readUnsignedShort(off);
            off += 2;
            int i = 0;
            while (i < size) {
                int kind = cr.readByte(off++);
                switch (kind) {
                    case 4: {
                        attr.readMethodAccess(cr, off, buf);
                        off += 8;
                        break;
                    }
                    case 5: {
                        attr.readFieldAccess(cr, off, buf);
                        off += 9;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected kind in OTSpecialAccess attribute: " + kind);
                    }
                }
                ++i;
            }
            size = cr.readUnsignedShort(off);
            off += 2;
            i = 0;
            while (i < size) {
                int flag;
                String baseClass = cr.readUTF8(off, buf);
                off += 2;
                if ((flag = cr.readByte(off++)) == 1) {
                    this.decapsulatedBaseClasses.add(baseClass);
                }
                ++i;
            }
            return attr;
        }

        private void readMethodAccess(ClassReader cr, int off, char[] buf) {
            String methodName;
            String declaringClass;
            String className = cr.readUTF8(off, buf);
            String encodedName = cr.readUTF8(off + 2, buf);
            String methodDesc = cr.readUTF8(off + 4, buf);
            int accessId = cr.readUnsignedShort(off + 6);
            boolean isStatic = false;
            if (encodedName.charAt(0) == '<') {
                declaringClass = className;
                methodName = encodedName;
                isStatic = true;
            } else {
                int pos = encodedName.indexOf(63);
                if (pos == -1) {
                    pos = encodedName.indexOf(33);
                    isStatic = true;
                }
                declaringClass = encodedName.substring(0, pos);
                methodName = encodedName.substring(pos + 1);
            }
            if (className != null && declaringClass != null && methodName != null && methodDesc != null) {
                this.methods.add(new DecapsMethod(className, declaringClass, methodName, methodDesc, accessId, isStatic));
            } else {
                System.err.println("Class attribute has unexpected null value: " + className + ":" + declaringClass + ":" + methodName + ":" + methodDesc);
            }
        }

        private void readFieldAccess(ClassReader cr, int off, char[] buf) {
            String accessMode;
            int accessId = cr.readUnsignedShort(off);
            int flags = cr.readByte(off + 2);
            String className = cr.readUTF8(off + 3, buf);
            String fieldName = cr.readUTF8(off + 5, buf);
            String fieldDesc = cr.readUTF8(off + 7, buf);
            boolean isStatic = (flags & 2) != 0;
            String string = accessMode = (flags & 1) == 1 ? "set" : "get";
            if (className != null && fieldName != null && fieldDesc != null) {
                this.fields.add(new DecapsField(className, fieldName, fieldDesc, accessId, accessMode, isStatic));
            } else {
                System.err.println("Class attribute has unexpected null value: " + className + ":" + fieldName + ":" + fieldDesc);
            }
        }

        public void registerAt(AsmBoundClass clazz) {
            AbstractBoundClass baseclass;
            ClassRepository repo = ClassRepository.getInstance();
            IClassIdentifierProvider provider = ClassIdentifierProviderFactory.getClassIdentifierProvider();
            for (DecapsMethod dMethod : this.methods) {
                baseclass = repo.getBoundClass(dMethod.declaringClass, dMethod.declaringClass.replace('.', '/'), clazz.getClassLoader());
                baseclass.getMethod(dMethod.name, dMethod.desc, false, dMethod.isStatic);
                clazz.recordAccessId(dMethod.perTeamAccessId);
                clazz.addBinding(new Binding(clazz, dMethod.declaringClass, dMethod.name, dMethod.desc, dMethod.perTeamAccessId, IBinding.BindingType.METHOD_ACCESS));
            }
            for (DecapsField dField : this.fields) {
                baseclass = repo.getBoundClass(dField.baseclass, dField.baseclass.replace('.', '/'), clazz.getClassLoader());
                baseclass.getField(dField.name, dField.desc);
                clazz.recordAccessId(dField.perTeamAccessId);
                clazz.addBinding(new Binding(clazz, dField.baseclass, dField.name, dField.desc, dField.perTeamAccessId, IBinding.BindingType.FIELD_ACCESS));
            }
        }

        class DecapsField {
            String accessMode;
            boolean isStatic;
            @NonNull String baseclass;
            @NonNull String name;
            @NonNull String desc;
            public int perTeamAccessId;

            public DecapsField(@NonNull String baseclass, @NonNull String name, String desc, int accessId, String accessMode, boolean isStatic) {
                this.baseclass = baseclass;
                this.name = name;
                this.desc = desc;
                this.perTeamAccessId = accessId;
                this.accessMode = accessMode;
                this.isStatic = isStatic;
            }
        }

        class DecapsMethod {
            @NonNull String[] weaveIntoClasses;
            @NonNull String declaringClass;
            @NonNull String name;
            @NonNull String desc;
            int perTeamAccessId;
            boolean isStatic;

            DecapsMethod(@NonNull String weaveIntoClasses, @NonNull String declaringClass, @NonNull String name, String desc, int id, boolean isStatic) {
                this.weaveIntoClasses = weaveIntoClasses.split(":");
                this.declaringClass = declaringClass;
                this.name = name;
                this.desc = desc;
                this.perTeamAccessId = id;
                this.isStatic = isStatic;
            }
        }
    }

    protected static class RoleBaseBindingsAttribute
    extends Attribute {
        String[] roles;
        String[] bases;

        protected RoleBaseBindingsAttribute(int elementCount) {
            super(Attributes.ATTRIBUTE_ROLE_BASE_BINDINGS);
            this.roles = new String[elementCount];
            this.bases = new String[elementCount];
        }

        protected Attribute read(ClassReader cr, int off, int len, char[] buf, int codeOff, Label[] labels) {
            int elementCount = cr.readShort(off);
            off += 2;
            RoleBaseBindingsAttribute attr = new RoleBaseBindingsAttribute(elementCount);
            int i = 0;
            while (i < elementCount) {
                attr.roles[i] = cr.readUTF8(off, buf);
                attr.bases[i] = cr.readUTF8(off += 2, buf);
                off += 2;
                ++i;
            }
            return attr;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(this.type).append('\n');
            int i = 0;
            while (i < this.roles.length) {
                buf.append('\t').append(this.roles[i]).append("->").append(this.bases[i]).append('\n');
                ++i;
            }
            return buf.toString();
        }
    }
}

