/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.preferences.presentation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.ui.editor.ProblemEditorPart;
import org.eclipse.emf.common.ui.viewer.ColumnViewerInformationControlToolTipSupport;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.DecoratingColumLabelProvider;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.base.provider.BaseItemProviderAdapterFactory;
import org.eclipse.oomph.preferences.PreferenceNode;
import org.eclipse.oomph.preferences.PreferencesFactory;
import org.eclipse.oomph.preferences.PreferencesPackage;
import org.eclipse.oomph.preferences.Property;
import org.eclipse.oomph.preferences.impl.PreferencesURIHandlerImpl;
import org.eclipse.oomph.preferences.presentation.PreferencesEditorPlugin;
import org.eclipse.oomph.preferences.provider.PreferencesEditPlugin;
import org.eclipse.oomph.preferences.provider.PreferencesItemProviderAdapterFactory;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencesEditor
extends MultiPageEditorPart
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener,
IViewerProvider,
IGotoMarker {
    protected AdapterFactoryEditingDomain editingDomain;
    protected ComposedAdapterFactory adapterFactory;
    protected OutlinePage contentOutlinePage;
    protected IStatusLineManager contentOutlineStatusLineManager;
    protected TreeViewer contentOutlineViewer;
    protected List<PropertySheetPage> propertySheetPages = new ArrayList<PropertySheetPage>();
    protected TreeViewer selectionViewer;
    protected Viewer currentViewer;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected MarkerHelper markerHelper = new EditUIMarkerHelper();
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            if (p instanceof ContentOutline) {
                if (((ContentOutline)p).getCurrentPage() == PreferencesEditor.this.contentOutlinePage) {
                    PreferencesEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)PreferencesEditor.this);
                    PreferencesEditor.this.setCurrentViewer((Viewer)PreferencesEditor.this.contentOutlineViewer);
                }
            } else if (p instanceof PropertySheet) {
                if (PreferencesEditor.this.propertySheetPages.contains(((PropertySheet)p).getCurrentPage())) {
                    PreferencesEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)PreferencesEditor.this);
                    PreferencesEditor.this.handleActivate();
                }
            } else if (p == PreferencesEditor.this) {
                PreferencesEditor.this.handleActivate();
                PreferencesEditor.this.setCurrentViewer((Viewer)PreferencesEditor.this.selectionViewer);
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    protected Collection<Resource> removedResources = new ArrayList<Resource>();
    protected Collection<Resource> changedResources = new ArrayList<Resource>();
    protected Collection<Resource> savedResources = new ArrayList<Resource>();
    protected Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    protected boolean updateProblemIndication = true;
    protected EContentAdapter problemIndicationAdapter = new EContentAdapter(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof Resource) {
                switch (notification.getFeatureID(Resource.class)) {
                    case 4: 
                    case 6: 
                    case 7: {
                        Resource resource = (Resource)notification.getNotifier();
                        Diagnostic diagnostic = PreferencesEditor.this.analyzeResourceProblems(resource, null);
                        if (diagnostic.getSeverity() != 0) {
                            PreferencesEditor.this.resourceToDiagnosticMap.put(resource, diagnostic);
                        } else {
                            PreferencesEditor.this.resourceToDiagnosticMap.remove(resource);
                        }
                        if (!PreferencesEditor.this.updateProblemIndication) return;
                        PreferencesEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                PreferencesEditor.this.updateProblemIndication();
                            }
                        });
                    }
                    default: {
                        return;
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }

        protected void setTarget(Resource target) {
            this.basicSetTarget((Notifier)target);
        }

        protected void unsetTarget(Resource target) {
            this.basicUnsetTarget((Notifier)target);
            PreferencesEditor.this.resourceToDiagnosticMap.remove(target);
            if (PreferencesEditor.this.updateProblemIndication) {
                PreferencesEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        PreferencesEditor.this.updateProblemIndication();
                    }
                });
            }
        }
    };
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected ResourceSet resourceSet;
                    protected Collection<Resource> changedResources;
                    protected Collection<Resource> removedResources;

                    ResourceDeltaVisitor() {
                        this.resourceSet = (this).PreferencesEditor.this.editingDomain.getResourceSet();
                        this.changedResources = new ArrayList<Resource>();
                        this.removedResources = new ArrayList<Resource>();
                    }

                    public boolean visit(IResourceDelta delta) {
                        if (delta.getResource().getType() == 1) {
                            Resource resource;
                            if ((delta.getKind() == 2 || delta.getKind() == 4) && (resource = this.resourceSet.getResource(URI.createPlatformResourceURI((String)delta.getFullPath().toString(), (boolean)true), false)) != null) {
                                if (delta.getKind() == 2) {
                                    this.removedResources.add(resource);
                                } else {
                                    if ((delta.getFlags() & 0x20000) != 0) {
                                        DiagnosticDecorator.DiagnosticAdapter.update((Notifier)resource, (Diagnostic)(this).PreferencesEditor.this.markerHelper.getMarkerDiagnostics((Object)resource, (IFile)delta.getResource()));
                                    }
                                    if ((delta.getFlags() & 0x100) != 0 && !(this).PreferencesEditor.this.savedResources.remove(resource)) {
                                        this.changedResources.add(resource);
                                    }
                                }
                            }
                            return false;
                        }
                        return true;
                    }

                    public Collection<Resource> getChangedResources() {
                        return this.changedResources;
                    }

                    public Collection<Resource> getRemovedResources() {
                        return this.removedResources;
                    }
                }
                final ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                if (!visitor.getRemovedResources().isEmpty()) {
                    PreferencesEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        public void run() {
                            (this).PreferencesEditor.this.removedResources.addAll(visitor.getRemovedResources());
                            if (!PreferencesEditor.this.isDirty()) {
                                PreferencesEditor.this.getSite().getPage().closeEditor((IEditorPart)PreferencesEditor.this, false);
                            }
                        }
                    });
                }
                if (!visitor.getChangedResources().isEmpty()) {
                    PreferencesEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        public void run() {
                            (this).PreferencesEditor.this.changedResources.addAll(visitor.getChangedResources());
                            if (PreferencesEditor.this.getSite().getPage().getActiveEditor() == PreferencesEditor.this) {
                                PreferencesEditor.this.handleActivate();
                            }
                        }
                    });
                }
            }
            catch (CoreException exception) {
                PreferencesEditorPlugin.INSTANCE.log((Object)exception);
            }
        }
    };

    protected void handleActivate() {
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    protected void handleChangedResources() {
        if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
            if (this.isDirty()) {
                this.changedResources.addAll((Collection<Resource>)this.editingDomain.getResourceSet().getResources());
            }
            this.editingDomain.getCommandStack().flush();
            this.updateProblemIndication = false;
            for (Resource resource : this.changedResources) {
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException exception) {
                    if (this.resourceToDiagnosticMap.containsKey(resource)) continue;
                    this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
                }
            }
            if (AdapterFactoryEditingDomain.isStale((Object)this.editorSelection)) {
                this.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            this.updateProblemIndication = true;
            this.updateProblemIndication();
        }
    }

    protected void updateProblemIndication() {
        if (this.updateProblemIndication) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(0, "org.eclipse.oomph.preferences.editor", 0, null, new Object[]{this.editingDomain.getResourceSet()});
            for (Diagnostic childDiagnostic : this.resourceToDiagnosticMap.values()) {
                if (childDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(childDiagnostic);
            }
            int lastEditorPage = this.getPageCount() - 1;
            if (lastEditorPage >= 0 && this.getEditor(lastEditorPage) instanceof ProblemEditorPart) {
                ((ProblemEditorPart)this.getEditor(lastEditorPage)).setDiagnostic((Diagnostic)diagnostic);
                if (diagnostic.getSeverity() != 0) {
                    this.setActivePage(lastEditorPage);
                }
            } else if (diagnostic.getSeverity() != 0) {
                ProblemEditorPart problemEditorPart = new ProblemEditorPart();
                problemEditorPart.setDiagnostic((Diagnostic)diagnostic);
                problemEditorPart.setMarkerHelper(this.markerHelper);
                try {
                    this.addPage(++lastEditorPage, (IEditorPart)problemEditorPart, this.getEditorInput());
                    this.setPageText(lastEditorPage, problemEditorPart.getPartName());
                    this.setActivePage(lastEditorPage);
                    this.showTabs();
                }
                catch (PartInitException exception) {
                    PreferencesEditorPlugin.INSTANCE.log((Object)exception);
                }
            }
            if (this.markerHelper.hasMarkers((Object)this.editingDomain.getResourceSet())) {
                this.markerHelper.deleteMarkers((Object)this.editingDomain.getResourceSet());
                if (diagnostic.getSeverity() != 0) {
                    try {
                        this.markerHelper.createMarkers((Diagnostic)diagnostic);
                    }
                    catch (CoreException exception) {
                        PreferencesEditorPlugin.INSTANCE.log((Object)exception);
                    }
                }
            }
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)PreferencesEditor.getString("_UI_FileConflict_label"), (String)PreferencesEditor.getString("_WARN_FileConflict"));
    }

    public PreferencesEditor() {
        this.initializeEditingDomain();
    }

    protected void initializeEditingDomain() {
        this.initializeEditingDomainGen();
        this.editingDomain.getResourceSet().getURIConverter().getURIHandlers().add(0, (Object)new PreferencesURIHandlerImpl());
    }

    protected void initializeEditingDomainGen() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new PreferencesItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new BaseItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                PreferencesEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        PreferencesEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            PreferencesEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                        Iterator<PropertySheetPage> i = (this).PreferencesEditor.this.propertySheetPages.iterator();
                        while (i.hasNext()) {
                            PropertySheetPage propertySheetPage = i.next();
                            if (propertySheetPage.getControl().isDisposed()) {
                                i.remove();
                                continue;
                            }
                            propertySheetPage.refresh();
                        }
                    }
                });
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    protected void firePropertyChange(int action) {
        super.firePropertyChange(action);
    }

    public void setSelectionToViewer(Collection<?> collection) {
        final Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (PreferencesEditor.this.currentViewer != null) {
                        PreferencesEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            this.getSite().getShell().getDisplay().asyncExec(runnable);
        }
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        PreferencesEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    public Viewer getViewer() {
        return this.currentViewer;
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance(), LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)this.editingDomain, (Viewer)viewer));
    }

    public void createModel() {
        this.editingDomain.getResourceSet().getLoadOptions().put("SYNCHRONIZED_PREFERENCES", Boolean.TRUE);
        this.createModelGen();
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        if (resourceURI.segmentCount() == 1) {
            this.editingDomain.getResourceSet().eAdapters().add((Object)new SelectChangesListener());
        }
    }

    public void createModelGen() {
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        Exception exception = null;
        Resource resource = null;
        try {
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception e) {
            exception = e;
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
        Diagnostic diagnostic = this.analyzeResourceProblems(resource, exception);
        if (diagnostic.getSeverity() != 0) {
            this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
        }
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.problemIndicationAdapter);
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        if (!resource.getErrors().isEmpty() || !resource.getWarnings().isEmpty()) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "org.eclipse.oomph.preferences.editor", 0, PreferencesEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, "org.eclipse.oomph.preferences.editor", 0, PreferencesEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    public void createPages() {
        this.createPagesGen();
        EList resources = this.editingDomain.getResourceSet().getResources();
        if (!resources.isEmpty()) {
            this.selectionViewer.setInput(((Resource)resources.get(0)).getContents().get(0));
        }
    }

    public void createPagesGen() {
        this.createModel();
        if (!this.getEditingDomain().getResourceSet().getResources().isEmpty()) {
            Tree tree = new Tree(this.getContainer(), 2);
            this.selectionViewer = new TreeViewer(tree);
            this.setCurrentViewer((Viewer)this.selectionViewer);
            this.selectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
            this.selectionViewer.setLabelProvider((IBaseLabelProvider)new DecoratingColumLabelProvider((ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory), (ILabelDecorator)new DiagnosticDecorator((EditingDomain)this.editingDomain, (StructuredViewer)this.selectionViewer, PreferencesEditorPlugin.getPlugin().getDialogSettings())));
            this.selectionViewer.setInput((Object)this.editingDomain.getResourceSet());
            this.selectionViewer.setSelection((ISelection)new StructuredSelection(this.editingDomain.getResourceSet().getResources().get(0)), true);
            new AdapterFactoryTreeEditor(this.selectionViewer.getTree(), (AdapterFactory)this.adapterFactory);
            new ColumnViewerInformationControlToolTipSupport((ColumnViewer)this.selectionViewer, (LocationListener)new DiagnosticDecorator.EditingDomainLocationListener((EditingDomain)this.editingDomain, (StructuredViewer)this.selectionViewer));
            this.createContextMenuFor((StructuredViewer)this.selectionViewer);
            int pageIndex = this.addPage((Control)tree);
            this.setPageText(pageIndex, PreferencesEditor.getString("_UI_SelectionPage_label"));
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    PreferencesEditor.this.setActivePage(0);
                }
            });
        }
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    PreferencesEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                PreferencesEditor.this.updateProblemIndication();
            }
        });
    }

    protected void hideTabs() {
        if (this.getPageCount() <= 1) {
            this.setPageText(0, "");
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y + 6);
            }
        }
    }

    protected void showTabs() {
        if (this.getPageCount() > 1) {
            this.setPageText(0, PreferencesEditor.getString("_UI_SelectionPage_label"));
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(-1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y - 6);
            }
        }
    }

    protected void pageChange(int pageIndex) {
        super.pageChange(pageIndex);
        if (this.contentOutlinePage != null) {
            this.handleContentOutlineSelection(this.contentOutlinePage.getSelection());
        }
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.showOutlineView() ? this.getContentOutlinePage() : null;
        }
        if (key.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        if (key.equals(IGotoMarker.class)) {
            return this;
        }
        return super.getAdapter(key);
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            this.contentOutlinePage = new OutlinePage(this.editingDomain, this.selectionViewer){

                protected void createContextMenuFor(StructuredViewer viewer) {
                    PreferencesEditor.this.createContextMenuFor(viewer);
                }

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                    PreferencesEditor.this.contentOutlineStatusLineManager = statusLineManager;
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    PreferencesEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }

                protected void handleContentOutlineSelection(ISelection selection) {
                    PreferencesEditor.this.handleContentOutlineSelection(selection);
                }

                protected void setSelection(IStructuredSelection selection) {
                    TreeViewer oldSelectionViewer = PreferencesEditor.this.selectionViewer;
                    PreferencesEditor.this.selectionViewer = null;
                    this.getTreeViewer().setSelection((ISelection)selection);
                    PreferencesEditor.this.selectionViewer = oldSelectionViewer;
                }
            };
        }
        return this.contentOutlinePage;
    }

    public IPropertySheetPage getPropertySheetPage() {
        ExtendedPropertySheetPage propertySheetPage = new ExtendedPropertySheetPage(this.editingDomain, ExtendedPropertySheetPage.Decoration.LIVE, PreferencesEditorPlugin.getPlugin().getDialogSettings()){

            public void setSelectionToViewer(List<?> selection) {
                PreferencesEditor.this.setSelectionToViewer(selection);
                PreferencesEditor.this.setFocus();
            }

            public void setActionBars(IActionBars actionBars) {
                super.setActionBars(actionBars);
                PreferencesEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
            }
        };
        propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        this.propertySheetPages.add((PropertySheetPage)propertySheetPage);
        return propertySheetPage;
    }

    public void handleContentOutlineSelection(ISelection selection) {
        Iterator selectedElements;
        if (this.selectionViewer != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (selectedElements = ((IStructuredSelection)selection).iterator()).hasNext()) {
            Object selectedElement = selectedElements.next();
            ArrayList<Object> selectionList = new ArrayList<Object>();
            selectionList.addAll(this.unwrap(selectedElement));
            while (selectedElements.hasNext()) {
                selectionList.add(this.unwrap(selectedElements.next()));
            }
            this.selectionViewer.setSelection((ISelection)new StructuredSelection(selectionList));
        }
    }

    private List<? extends Object> unwrap(Object object) {
        if (object instanceof OutlinePage.Wrapper) {
            return ((OutlinePage.Wrapper)object).getWrappedObjects();
        }
        return Collections.singletonList(object);
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        if (!"preference".equals(((Resource)this.editingDomain.getResourceSet().getResources().get(0)).getURI().scheme())) {
            saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
            saveOptions.put("LINE_DELIMITER", "");
        }
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                boolean first = true;
                for (Resource resource : PreferencesEditor.this.editingDomain.getResourceSet().getResources()) {
                    if (!first && resource.getContents().isEmpty() && !PreferencesEditor.this.isPersisted(resource) || PreferencesEditor.this.editingDomain.isReadOnly(resource)) continue;
                    try {
                        long timeStamp = resource.getTimeStamp();
                        resource.save(saveOptions);
                        if (resource.getTimeStamp() != timeStamp) {
                            PreferencesEditor.this.savedResources.add(resource);
                        }
                    }
                    catch (Exception exception) {
                        PreferencesEditor.this.resourceToDiagnosticMap.put(resource, PreferencesEditor.this.analyzeResourceProblems(resource, exception));
                    }
                    first = false;
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            PreferencesEditorPlugin.INSTANCE.log(exception);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    protected boolean isPersisted(Resource resource) {
        boolean result = false;
        try {
            InputStream stream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            this.doSaveAs(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), (IEditorInput)new FileEditorInput(file));
        }
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
        ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(uri);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        NullProgressMonitor progressMonitor = this.getActionBars().getStatusLineManager() != null ? this.getActionBars().getStatusLineManager().getProgressMonitor() : new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    public void gotoMarker(IMarker marker) {
        List targetObjects = this.markerHelper.getTargetObjects((Object)this.editingDomain, marker);
        if (!targetObjects.isEmpty()) {
            this.setSelectionToViewer(targetObjects);
        }
    }

    public void initGen(IEditorSite site, IEditorInput editorInput) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        this.initGen(site, editorInput);
        IContextService contextService = (IContextService)site.getService(IContextService.class);
        contextService.activateContext("org.eclipse.oomph.preferences.editor.context");
    }

    public void setFocus() {
        this.getControl(this.getActivePage()).setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
        this.setStatusLineManager(selection);
    }

    public void setStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager;
        IStatusLineManager iStatusLineManager = statusLineManager = this.currentViewer != null && this.currentViewer == this.contentOutlineViewer ? this.contentOutlineStatusLineManager : this.getActionBars().getStatusLineManager();
        if (statusLineManager != null) {
            if (selection instanceof IStructuredSelection) {
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage(PreferencesEditor.getString("_UI_NoObjectSelected"));
                        break;
                    }
                    case 1: {
                        String text = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory).getText(collection.iterator().next());
                        statusLineManager.setMessage(PreferencesEditor.getString("_UI_SingleObjectSelected", text));
                        break;
                    }
                    default: {
                        statusLineManager.setMessage(PreferencesEditor.getString("_UI_MultiObjectSelected", Integer.toString(collection.size())));
                        break;
                    }
                }
            } else {
                statusLineManager.setMessage("");
            }
        }
    }

    private static String getString(String key) {
        return PreferencesEditorPlugin.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return PreferencesEditorPlugin.INSTANCE.getString(key, new Object[]{s1});
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void dispose() {
        this.disposeGen();
        for (Resource resource : this.editingDomain.getResourceSet().getResources()) {
            resource.unload();
        }
    }

    public void disposeGen() {
        this.updateProblemIndication = false;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.getSite().getPage().removePartListener(this.partListener);
        this.adapterFactory.dispose();
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        for (PropertySheetPage propertySheetPage : this.propertySheetPages) {
            propertySheetPage.dispose();
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        super.dispose();
    }

    protected boolean showOutlineView() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class OutlinePage
    extends ContentOutlinePage {
        private static final Object PREFERENCE_NODE_IMAGE = PreferencesEditPlugin.INSTANCE.getImage("full/obj16/PreferenceNode");
        private static final Object PROPERTY_IMAGE = PreferencesEditPlugin.INSTANCE.getImage("full/obj16/Property");
        private TreeViewer contentOutlineViewer;
        private AdapterFactoryEditingDomain editingDomain;
        private TreeViewer selectionViewer;
        private Map<Object, Object> selectionMap = new HashMap<Object, Object>();
        private Map<URI, PreferenceNodePresentation> preferencesNodes = new HashMap<URI, PreferenceNodePresentation>();

        public OutlinePage(AdapterFactoryEditingDomain editingDomain, TreeViewer selectionViewer) {
            this.editingDomain = editingDomain;
            this.selectionViewer = selectionViewer;
        }

        protected abstract void handleContentOutlineSelection(ISelection var1);

        protected abstract void createContextMenuFor(StructuredViewer var1);

        protected abstract void setSelection(IStructuredSelection var1);

        public void createControl(Composite parent) {
            super.createControl(parent);
            this.contentOutlineViewer = this.getTreeViewer();
            this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            this.contentOutlineViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.editingDomain.getAdapterFactory()));
            this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.editingDomain.getAdapterFactory()));
            this.createContextMenuFor((StructuredViewer)this.contentOutlineViewer);
            this.update();
            this.selectionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (OutlinePage.this.selectionViewer != null && !selection.isEmpty()) {
                        ArrayList<Object> selectionList = new ArrayList<Object>();
                        Object[] objectArray = selection.toArray();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object object = objectArray[n2];
                            OutlinePage.this.collectSelection(selectionList, object);
                            ++n2;
                        }
                        if (!selectionList.isEmpty()) {
                            OutlinePage.this.setSelection((IStructuredSelection)new StructuredSelection(selectionList));
                        }
                    }
                }
            });
            this.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    TreeViewer oldSelectionViewer = OutlinePage.this.selectionViewer;
                    OutlinePage.this.selectionViewer = null;
                    OutlinePage.this.handleContentOutlineSelection(event.getSelection());
                    OutlinePage.this.selectionViewer = oldSelectionViewer;
                }
            });
        }

        protected void collectSelection(List<Object> selection, Object object) {
            Object value = this.selectionMap.get(object);
            if (value != null) {
                selection.add(value);
            }
        }

        public void update() {
            Resource resource;
            this.selectionMap.clear();
            this.preferencesNodes.clear();
            if (!this.editingDomain.getResourceSet().getResources().isEmpty() && !(resource = (Resource)this.editingDomain.getResourceSet().getResources().get(0)).getContents().isEmpty()) {
                PreferenceNode rootPreferfenceNode = (PreferenceNode)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)PreferencesPackage.Literals.PREFERENCE_NODE);
                this.contentOutlineViewer.setInput((Object)new ItemProvider(this.traverse(rootPreferfenceNode)));
            }
        }

        private List<PreferenceNodePresentation> traverse(PreferenceNode preferenceNode) {
            UniqueEList result = new UniqueEList();
            for (PreferenceNode node : preferenceNode.getChildren()) {
                String name = node.getName();
                if ("project".equals(name)) {
                    for (PreferenceNode projectNode : node.getChildren()) {
                        for (PreferenceNode child : projectNode.getChildren()) {
                            URI path = URI.createURI((String)child.getName());
                            result.add(this.traverse(projectNode, path, child));
                        }
                    }
                    continue;
                }
                if ("bundle_defaults".equals(name) || "default".equals(name) || "configuration".equals(name) || "instance".equals(name) || "secure".equals(name)) {
                    for (PreferenceNode child : node.getChildren()) {
                        URI path = URI.createURI((String)child.getName());
                        result.add(this.traverse(node, path, child));
                    }
                    continue;
                }
                result.add(this.traverse(preferenceNode, URI.createURI((String)node.getName()), node));
            }
            return result;
        }

        private PreferenceNodePresentation traverse(PreferenceNode rootPreferenceNode, URI path, PreferenceNode preferenceNode) {
            PreferenceNodePresentation preferenceNodePresentation = this.preferencesNodes.get(path);
            if (preferenceNodePresentation == null) {
                PreferenceNodePresentation parentPreferenceNodePresentation;
                preferenceNodePresentation = new PreferenceNodePresentation(preferenceNode);
                this.preferencesNodes.put(path, preferenceNodePresentation);
                if (path.segmentCount() > 1 && (parentPreferenceNodePresentation = this.preferencesNodes.get(path.trimSegments(1))) != null) {
                    EList children = parentPreferenceNodePresentation.getChildren();
                    int index = children.size();
                    int i = 0;
                    int size = index;
                    while (i < size) {
                        if (children.get(i) instanceof PropertyPresentation) break;
                        ++i;
                    }
                    children.add(index, (Object)preferenceNodePresentation);
                }
            } else {
                preferenceNodePresentation.getWrappedObjects().add(preferenceNode);
                this.selectionMap.put(preferenceNode, preferenceNodePresentation);
            }
            for (PreferenceNode node : preferenceNode.getChildren()) {
                String name = node.getName();
                if (!URI.validSegment((String)name)) {
                    name = URI.encodeSegment((String)name, (boolean)false);
                }
                this.traverse(rootPreferenceNode, path.appendSegment(name), node);
            }
            for (Property property : preferenceNode.getProperties()) {
                preferenceNodePresentation.addProperty(rootPreferenceNode, property);
            }
            return preferenceNodePresentation;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class PreferenceNodePresentation
        extends ItemProvider
        implements Wrapper {
            private List<PreferenceNode> preferencesNodes;

            public PreferenceNodePresentation(PreferenceNode preferenceNode) {
                super(preferenceNode.getName(), PREFERENCE_NODE_IMAGE);
                this.preferencesNodes = new ArrayList<PreferenceNode>();
                this.preferencesNodes.add(preferenceNode);
                OutlinePage.this.selectionMap.put(preferenceNode, this);
            }

            public void addProperty(PreferenceNode rootPreferenceNode, Property property) {
                String name = property.getName();
                PropertyPresentation propertyPresentation = null;
                for (Object child : this.getChildren()) {
                    if (!(child instanceof PropertyPresentation)) continue;
                    propertyPresentation = (PropertyPresentation)child;
                    if (name.equals(propertyPresentation.getText())) break;
                    propertyPresentation = null;
                }
                if (propertyPresentation == null) {
                    propertyPresentation = new PropertyPresentation(property);
                    this.getChildren().add((Object)propertyPresentation);
                } else {
                    propertyPresentation.getWrappedObjects().add(property);
                }
                URI absolutePath = rootPreferenceNode.getAbsolutePath();
                String value = property.getValue();
                propertyPresentation.getChildren().add((Object)new PropertyPresentation(String.valueOf(PreferencesFactory.eINSTANCE.convertURI(absolutePath)) + "=" + value, property));
            }

            public List<PreferenceNode> getWrappedObjects() {
                return this.preferencesNodes;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class PropertyPresentation
        extends ItemProvider
        implements Wrapper {
            private List<Property> properties;

            public PropertyPresentation(Property property) {
                super(property.getName(), PROPERTY_IMAGE);
                this.properties = new ArrayList<Property>();
                this.properties.add(property);
            }

            public PropertyPresentation(String label, Property property) {
                super(label, PROPERTY_IMAGE);
                this.properties = new ArrayList<Property>();
                this.properties.add(property);
                OutlinePage.this.selectionMap.put(property, this);
            }

            public List<Property> getWrappedObjects() {
                return this.properties;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Wrapper {
            public List<? extends EObject> getWrappedObjects();
        }
    }

    public class ReverseAdapterFactoryContentProvider
    extends AdapterFactoryContentProvider {
        public ReverseAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getElements(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public Object[] getChildren(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public boolean hasChildren(Object object) {
            Object parent = super.getParent(object);
            return parent != null;
        }

        public Object getParent(Object object) {
            return null;
        }
    }

    private class SelectChangesListener
    extends EContentAdapter {
        protected List<Object> selection;

        private SelectChangesListener() {
        }

        public synchronized void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            boolean dispatch = false;
            if (this.selection == null) {
                this.selection = new ArrayList<Object>();
                dispatch = true;
            }
            switch (notification.getEventType()) {
                case 3: {
                    this.selection.add(notification.getNewValue());
                    break;
                }
                case 5: {
                    this.selection.addAll((List)notification.getNewValue());
                    break;
                }
                default: {
                    this.selection.add(notification.getNotifier());
                }
            }
            if (dispatch) {
                final Display display = PreferencesEditor.this.getSite().getShell().getDisplay();
                display.asyncExec(new Runnable(){

                    public void run() {
                        if (!((SelectChangesListener)SelectChangesListener.this).PreferencesEditor.this.selectionViewer.getControl().isDisposed()) {
                            display.timerExec(5000, new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run() {
                                    SelectChangesListener selectChangesListener = SelectChangesListener.this;
                                    synchronized (selectChangesListener) {
                                        if (!((SelectChangesListener)(this).SelectChangesListener.this).PreferencesEditor.this.selectionViewer.getControl().isDisposed()) {
                                            List<Object> newSelection = (this).SelectChangesListener.this.selection;
                                            (this).SelectChangesListener.this.selection = null;
                                            if (((SelectChangesListener)(this).SelectChangesListener.this).PreferencesEditor.this.contentOutlinePage != null) {
                                                ((SelectChangesListener)(this).SelectChangesListener.this).PreferencesEditor.this.contentOutlinePage.update();
                                            }
                                            PreferencesEditor.this.setSelectionToViewer(newSelection);
                                        }
                                    }
                                }
                            });
                        }
                    }
                });
            }
        }
    }
}

