/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.version.ui.quickfixes;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.oomph.version.Markers;
import org.eclipse.oomph.version.ui.quickfixes.AbstractDocumentResolution;

public class ReplaceResolution
extends AbstractDocumentResolution {
    private String problemType;
    private String replacement;

    public ReplaceResolution(IMarker marker, String problemType, String replacement) {
        super(marker, ReplaceResolution.getLabel(marker, problemType, replacement), replacement == null ? "icons/correction_delete.gif" : "icons/correction_change.gif");
        this.problemType = problemType;
        this.replacement = replacement == null ? "" : replacement;
    }

    private static String getLabel(IMarker marker, String problemType, String replacement) {
        if ("schema.builder".equals(problemType)) {
            return replacement == null ? "Remove the schema builder" : "Add the schema builder";
        }
        if ("feature.nature".equals(problemType)) {
            return "Add the feature builder";
        }
        if ("debug.option".equals(problemType)) {
            return "Change the debug option";
        }
        return replacement == null ? "Remove the reference" : (Markers.getQuickFixAlternativeReplacement((IMarker)marker) == null ? "Change the version" : "Change to the extact version");
    }

    public String getDescription() {
        if (this.replacement.length() != 0) {
            return String.valueOf(this.getLabel()) + " to " + this.replacement;
        }
        return super.getDescription();
    }

    protected boolean isApplicable(IMarker marker) {
        boolean actualReplacement;
        if (!this.problemType.equals(Markers.getProblemType((IMarker)marker))) {
            return false;
        }
        if (Markers.getQuickFixPattern((IMarker)marker) == null) {
            return false;
        }
        boolean expectedReplacement = this.replacement.length() != 0;
        boolean bl = actualReplacement = this.getQuickFixReplacement(marker) != null;
        return actualReplacement == expectedReplacement;
    }

    protected String getQuickFixReplacement(IMarker marker) {
        return Markers.getQuickFixReplacement((IMarker)marker);
    }

    protected boolean apply(IMarker marker, IDocument document) throws Exception {
        String content = document.get();
        String regEx = Markers.getQuickFixPattern((IMarker)marker);
        String replacement = this.getQuickFixReplacement(marker);
        Pattern pattern = Pattern.compile(regEx, 40);
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            int end;
            int start;
            if (replacement != null && replacement.length() != 0) {
                start = matcher.start(1);
                end = matcher.end(1);
            } else {
                start = matcher.start();
                end = matcher.end();
                replacement = "";
            }
            document.replace(start, end - start, replacement);
            return true;
        }
        return false;
    }
}

