/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util.gui.resource;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import org.apache.batik.util.gui.resource.ActionMap;
import org.apache.batik.util.gui.resource.JComponentModifier;
import org.apache.batik.util.gui.resource.MissingListenerException;
import org.apache.batik.util.resources.ResourceFormatException;
import org.apache.batik.util.resources.ResourceManager;

public class MenuFactory
extends ResourceManager {
    private static final String TYPE_MENU = "MENU";
    private static final String TYPE_ITEM = "ITEM";
    private static final String TYPE_RADIO = "RADIO";
    private static final String TYPE_CHECK = "CHECK";
    private static final String SEPARATOR = "-";
    private static final String TYPE_SUFFIX = ".type";
    private static final String TEXT_SUFFIX = ".text";
    private static final String MNEMONIC_SUFFIX = ".mnemonic";
    private static final String ACCELERATOR_SUFFIX = ".accelerator";
    private static final String ACTION_SUFFIX = ".action";
    private static final String SELECTED_SUFFIX = ".selected";
    private static final String ENABLED_SUFFIX = ".enabled";
    private static final String ICON_SUFFIX = ".icon";
    private ActionMap actions;
    private ButtonGroup buttonGroup;

    public MenuFactory(ResourceBundle rb, ActionMap am) {
        super(rb);
        this.actions = am;
        this.buttonGroup = null;
    }

    public JMenuBar createJMenuBar(String name) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        return this.createJMenuBar(name, null);
    }

    public JMenuBar createJMenuBar(String name, String specialization) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JMenuBar result = new JMenuBar();
        List menus = this.getSpecializedStringList(name, specialization);
        Iterator it = menus.iterator();
        while (it.hasNext()) {
            result.add(this.createJMenuComponent((String)it.next(), specialization));
        }
        return result;
    }

    protected String getSpecializedString(String name, String specialization) {
        String s;
        try {
            s = this.getString(name + '.' + specialization);
        }
        catch (MissingResourceException mre) {
            s = this.getString(name);
        }
        return s;
    }

    protected List getSpecializedStringList(String name, String specialization) {
        List l;
        try {
            l = this.getStringList(name + '.' + specialization);
        }
        catch (MissingResourceException mre) {
            l = this.getStringList(name);
        }
        return l;
    }

    protected boolean getSpecializedBoolean(String name, String specialization) {
        boolean b;
        try {
            b = this.getBoolean(name + '.' + specialization);
        }
        catch (MissingResourceException mre) {
            b = this.getBoolean(name);
        }
        return b;
    }

    protected JComponent createJMenuComponent(String name, String specialization) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        if (name.equals(SEPARATOR)) {
            this.buttonGroup = null;
            return new JSeparator();
        }
        String type = this.getSpecializedString(name + TYPE_SUFFIX, specialization);
        JMenuItem item = null;
        if (type.equals(TYPE_RADIO)) {
            if (this.buttonGroup == null) {
                this.buttonGroup = new ButtonGroup();
            }
        } else {
            this.buttonGroup = null;
        }
        if (type.equals(TYPE_MENU)) {
            item = this.createJMenu(name, specialization);
        } else if (type.equals(TYPE_ITEM)) {
            item = this.createJMenuItem(name, specialization);
        } else if (type.equals(TYPE_RADIO)) {
            item = this.createJRadioButtonMenuItem(name, specialization);
            this.buttonGroup.add(item);
        } else if (type.equals(TYPE_CHECK)) {
            item = this.createJCheckBoxMenuItem(name, specialization);
        } else {
            throw new ResourceFormatException("Malformed resource", this.bundle.getClass().getName(), name + TYPE_SUFFIX);
        }
        return item;
    }

    public JMenu createJMenu(String name) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        return this.createJMenu(name, null);
    }

    public JMenu createJMenu(String name, String specialization) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JMenu result = new JMenu(this.getSpecializedString(name + TEXT_SUFFIX, specialization));
        this.initializeJMenuItem(result, name, specialization);
        List items = this.getSpecializedStringList(name, specialization);
        Iterator it = items.iterator();
        while (it.hasNext()) {
            result.add(this.createJMenuComponent((String)it.next(), specialization));
        }
        return result;
    }

    public JMenuItem createJMenuItem(String name) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        return this.createJMenuItem(name, null);
    }

    public JMenuItem createJMenuItem(String name, String specialization) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JMenuItem result = new JMenuItem(this.getSpecializedString(name + TEXT_SUFFIX, specialization));
        this.initializeJMenuItem(result, name, specialization);
        return result;
    }

    public JRadioButtonMenuItem createJRadioButtonMenuItem(String name) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        return this.createJRadioButtonMenuItem(name, null);
    }

    public JRadioButtonMenuItem createJRadioButtonMenuItem(String name, String specialization) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JRadioButtonMenuItem result = new JRadioButtonMenuItem(this.getSpecializedString(name + TEXT_SUFFIX, specialization));
        this.initializeJMenuItem(result, name, specialization);
        try {
            result.setSelected(this.getSpecializedBoolean(name + SELECTED_SUFFIX, specialization));
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        return result;
    }

    public JCheckBoxMenuItem createJCheckBoxMenuItem(String name) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        return this.createJCheckBoxMenuItem(name, null);
    }

    public JCheckBoxMenuItem createJCheckBoxMenuItem(String name, String specialization) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JCheckBoxMenuItem result = new JCheckBoxMenuItem(this.getSpecializedString(name + TEXT_SUFFIX, specialization));
        this.initializeJMenuItem(result, name, specialization);
        try {
            result.setSelected(this.getSpecializedBoolean(name + SELECTED_SUFFIX, specialization));
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        return result;
    }

    protected void initializeJMenuItem(JMenuItem item, String name, String specialization) throws ResourceFormatException, MissingListenerException {
        block15: {
            String str;
            try {
                Action a = this.actions.getAction(this.getSpecializedString(name + ACTION_SUFFIX, specialization));
                if (a == null) {
                    throw new MissingListenerException("", "Action", name + ACTION_SUFFIX);
                }
                item.setAction(a);
                item.setText(this.getSpecializedString(name + TEXT_SUFFIX, specialization));
                if (a instanceof JComponentModifier) {
                    ((JComponentModifier)((Object)a)).addJComponent(item);
                }
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            try {
                String s = this.getSpecializedString(name + ICON_SUFFIX, specialization);
                URL url = this.actions.getClass().getResource(s);
                if (url != null) {
                    item.setIcon(new ImageIcon(url));
                }
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            try {
                str = this.getSpecializedString(name + MNEMONIC_SUFFIX, specialization);
                if (str.length() != 1) {
                    throw new ResourceFormatException("Malformed mnemonic", this.bundle.getClass().getName(), name + MNEMONIC_SUFFIX);
                }
                item.setMnemonic(str.charAt(0));
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            try {
                if (item instanceof JMenu) break block15;
                str = this.getSpecializedString(name + ACCELERATOR_SUFFIX, specialization);
                KeyStroke ks = KeyStroke.getKeyStroke(str);
                if (ks != null) {
                    item.setAccelerator(ks);
                    break block15;
                }
                throw new ResourceFormatException("Malformed accelerator", this.bundle.getClass().getName(), name + ACCELERATOR_SUFFIX);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        try {
            item.setEnabled(this.getSpecializedBoolean(name + ENABLED_SUFFIX, specialization));
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
    }
}

