/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.actions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.oomph.preferences.PreferenceNode;
import org.eclipse.oomph.preferences.PreferencesFactory;
import org.eclipse.oomph.preferences.PreferencesPackage;
import org.eclipse.oomph.preferences.Property;
import org.eclipse.oomph.setup.CompoundTask;
import org.eclipse.oomph.setup.PreferenceTask;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.SetupTaskContainer;
import org.eclipse.oomph.setup.ui.actions.AbstractContainerAction;
import org.eclipse.oomph.setup.util.SetupUtil;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class PreferenceRecorderAction
extends AbstractContainerAction {
    private final boolean withDialog;
    private PreferenceNode rootPreferenceNode;
    private EContentAdapter preferenceAdapter;

    public PreferenceRecorderAction(boolean withDialog) {
        super("Record" + (withDialog ? "" : " Without Dialog"), 2);
        this.withDialog = withDialog;
        if (withDialog) {
            this.setToolTipText("Open the Preferences dialog and record changes into the selected setup task container");
        } else {
            this.setToolTipText("Record preference changes into the selected setup task container (without dialog)");
        }
    }

    protected boolean runInit(SetupTaskContainer container) {
        this.preferenceAdapter = this.createPreferenceAdapter();
        this.rootPreferenceNode = org.eclipse.oomph.preferences.util.PreferencesUtil.getRootPreferenceNode((boolean)true);
        this.rootPreferenceNode.eAdapters().add((Object)this.preferenceAdapter);
        return true;
    }

    protected void runModify(SetupTaskContainer container) {
        if (this.withDialog) {
            PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, null, null, null);
            dialog.open();
        }
    }

    protected void runDone(SetupTaskContainer container) {
        this.rootPreferenceNode.eAdapters().remove((Object)this.preferenceAdapter);
        this.rootPreferenceNode = null;
        this.preferenceAdapter = null;
    }

    protected void updatePreference(URI key, String value) {
        String path = PreferencesFactory.eINSTANCE.convertURI(key);
        TreeIterator it = this.getContainer().eResource().getAllContents();
        while (it.hasNext()) {
            PreferenceTask preferenceTask;
            EObject object = (EObject)it.next();
            if (!(object instanceof PreferenceTask) || !path.equals((preferenceTask = (PreferenceTask)object).getKey())) continue;
            preferenceTask.setValue(SetupUtil.escape((String)value));
            this.expandItem((EObject)preferenceTask);
            return;
        }
        PreferenceTask task = SetupFactory.eINSTANCE.createPreferenceTask();
        task.setKey(path);
        task.setValue(SetupUtil.escape((String)value));
        String pluginID = key.segment(0).toString();
        CompoundTask compoundTask = this.getCompoundTask(pluginID);
        compoundTask.getSetupTasks().add((Object)task);
        this.expandItem((EObject)task);
    }

    private CompoundTask getCompoundTask(String pluginID) {
        EList setupTasks = this.getContainer().getSetupTasks();
        for (SetupTask setupTask : setupTasks) {
            CompoundTask compoundTask;
            if (!(setupTask instanceof CompoundTask) || !pluginID.equals((compoundTask = (CompoundTask)setupTask).getName())) continue;
            return compoundTask;
        }
        CompoundTask compoundTask = SetupFactory.eINSTANCE.createCompoundTask(pluginID);
        compoundTask.setName(pluginID);
        setupTasks.add((Object)compoundTask);
        return compoundTask;
    }

    private EContentAdapter createPreferenceAdapter() {
        return new EContentAdapter(){
            private Map<Property, URI> paths = new HashMap<Property, URI>();

            protected void setTarget(EObject target) {
                Property property;
                URI absolutePath;
                super.setTarget(target);
                if (target instanceof Property && ("instance".equals((absolutePath = (property = (Property)target).getAbsolutePath()).authority()) || "configuration".equals(absolutePath.authority()))) {
                    this.paths.put(property, absolutePath);
                }
            }

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                if (!notification.isTouch()) {
                    switch (notification.getEventType()) {
                        case 1: {
                            if (notification.getFeature() != PreferencesPackage.Literals.PROPERTY__VALUE) break;
                            Property property = (Property)notification.getNotifier();
                            this.notifyChanged(property, property.getValue());
                            break;
                        }
                        case 3: {
                            if (notification.getFeature() != PreferencesPackage.Literals.PREFERENCE_NODE__PROPERTIES) break;
                            Property property = (Property)notification.getNewValue();
                            this.notifyChanged(property, property.getValue());
                            break;
                        }
                        case 4: {
                            if (notification.getFeature() != PreferencesPackage.Literals.PREFERENCE_NODE__PROPERTIES) break;
                            Property property = (Property)notification.getOldValue();
                            this.notifyChanged(property, null);
                        }
                    }
                }
            }

            private void notifyChanged(Property property, String value) {
                URI absolutePath = this.paths.get(property);
                if (absolutePath != null) {
                    PreferenceRecorderAction.this.updatePreference(absolutePath, value);
                }
            }
        };
    }
}

