/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.internal.ui;

import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.oomph.targlets.internal.core.TargletContainerDescriptorManager;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class NewTargletContainerWizardPage
extends WizardPage {
    private static final String DEFAULT_ID_PREFIX = "Default";
    private String containerID = "Default";

    public NewTargletContainerWizardPage() {
        super("AddTargletContainer");
        this.setTitle("Add Targlet Container");
        this.setMessage("Enter the ID of the new targlet container.");
    }

    public String getContainerID() {
        return this.containerID;
    }

    public void createControl(Composite parent) {
        final Set ids = TargletContainerDescriptorManager.getContainerIDs((IProgressMonitor)new NullProgressMonitor());
        int i = 1;
        while (ids.contains(this.containerID)) {
            this.containerID = DEFAULT_ID_PREFIX + ++i;
        }
        Composite composite = SWTFactory.createComposite((Composite)parent, (int)2, (int)1, (int)1808, (int)0, (int)0);
        Label label = new Label(composite, 0);
        label.setText("Targlet Container ID:");
        label.setLayoutData((Object)new GridData());
        final Text text = new Text(composite, 2048);
        text.setText(this.containerID);
        text.setLayoutData((Object)new GridData(768));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewTargletContainerWizardPage.this.containerID = text.getText();
                if (NewTargletContainerWizardPage.this.containerID.trim().length() == 0) {
                    NewTargletContainerWizardPage.this.setErrorMessage("Container ID must be specified and non-empty.");
                    NewTargletContainerWizardPage.this.setPageComplete(false);
                    return;
                }
                if (ids.contains(NewTargletContainerWizardPage.this.containerID)) {
                    NewTargletContainerWizardPage.this.setErrorMessage("Container ID must be unique across all target definitions.");
                    NewTargletContainerWizardPage.this.setPageComplete(false);
                    return;
                }
                NewTargletContainerWizardPage.this.setErrorMessage(null);
                NewTargletContainerWizardPage.this.setPageComplete(true);
            }
        });
        this.setControl((Control)composite);
    }

    public void storeSettings() {
    }
}

