/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.recorder;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.BaseFactory;
import org.eclipse.oomph.preferences.PreferencesFactory;
import org.eclipse.oomph.setup.CompoundTask;
import org.eclipse.oomph.setup.PreferenceTask;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.SetupTaskContainer;
import org.eclipse.oomph.setup.impl.PreferenceTaskImpl;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.ui.SetupEditorSupport;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.recorder.Messages;
import org.eclipse.oomph.setup.ui.recorder.RecorderManager;
import org.eclipse.oomph.setup.util.SetupUtil;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.OomphPlugin;
import org.eclipse.oomph.util.Pair;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RecorderTransaction {
    private static final Pattern LINE_SEPARATOR_PATTERN = Pattern.compile("\r\n?|\n\r?");
    private static final String POLICIES_FILE_NAME = "policies.properties";
    private static final String POLICIES_EXT_POINT = "org.eclipse.oomph.setup.ui.preferencePolicies";
    private static final String POLICY_RECORD = "record";
    private static final String POLICY_IGNORE = "ignore";
    private static final String REMOVE_PREFERENCE_MARKER = "REMOVE_PREFERENCE_MARKER";
    private static RecorderTransaction instance;
    private static final Map<String, String> DEFAULT_POLICIES_LOCAL;
    public static final Map<String, String> DEFAULT_POLICIES;
    private final Resource resource;
    private final Map<String, Boolean> cleanPolicies = new HashMap<String, Boolean>();
    private final Map<String, Boolean> policies = new HashMap<String, Boolean>();
    private final Set<URI> preferencesToRemove = new HashSet<URI>();
    private Map<URI, Pair<String, String>> preferences;
    private SetupTaskContainer preferenceContainer;
    private Annotation recorderAnnotation;
    private SetupTaskContainer rootObject;
    private boolean forceDirty;
    private CommitHandler commitHandler;
    private Map<String, PreferenceTask> commitResult;

    static {
        DEFAULT_POLICIES_LOCAL = RecorderTransaction.getDefaultPolicies();
        DEFAULT_POLICIES = Collections.unmodifiableMap(DEFAULT_POLICIES_LOCAL);
    }

    RecorderTransaction(SetupTaskContainer rootObject) {
        this.rootObject = rootObject;
        this.resource = rootObject.eResource();
        SetupTaskContainer eObject = rootObject;
        while (eObject != null) {
            if (eObject instanceof Scope) {
                this.findRecorderAnnotation((SetupTaskContainer)((Scope)eObject));
                if (this.recorderAnnotation == null) break;
                EMap details = this.recorderAnnotation.getDetails();
                for (Map.Entry entry : details) {
                    String value = (String)entry.getValue();
                    if (POLICY_RECORD.equals(value)) {
                        this.cleanPolicies.put((String)entry.getKey(), true);
                        continue;
                    }
                    if (!POLICY_IGNORE.equals(value)) continue;
                    this.cleanPolicies.put((String)entry.getKey(), false);
                }
                break;
            }
            eObject = eObject.eContainer();
        }
    }

    public IEditorPart getEditor() {
        return null;
    }

    public void close() {
        RecorderManager.INSTANCE.done();
        instance = null;
    }

    public Resource getResource() {
        return this.resource;
    }

    public SetupTaskContainer getRootObject() {
        return this.rootObject;
    }

    public boolean isDirty() {
        if (this.forceDirty) {
            return true;
        }
        if (!this.policies.isEmpty()) {
            return true;
        }
        return this.preferences != null && !this.preferences.isEmpty();
    }

    public boolean isForceDirty() {
        return this.forceDirty;
    }

    public void setForceDirty(boolean forceDirty) {
        this.forceDirty = forceDirty;
    }

    public Map<String, Boolean> getPolicies(boolean clean) {
        if (clean) {
            return this.cleanPolicies;
        }
        return this.policies;
    }

    public void setPolicies(Map<String, Boolean> policies) {
        this.resetPolicies();
        if (policies != null) {
            this.policies.putAll(policies);
        }
    }

    public void resetPolicies() {
        this.policies.clear();
    }

    public Boolean getPolicy(String key) {
        Boolean policy = this.policies.get(key);
        if (policy != null) {
            return policy;
        }
        return this.cleanPolicies.get(key);
    }

    public void setPolicy(String key, boolean policy) {
        Boolean cleanPolicy = this.cleanPolicies.get(key);
        if (cleanPolicy != null && cleanPolicy.equals(policy)) {
            this.policies.remove(key);
        } else {
            this.policies.put(key, policy);
        }
    }

    public boolean setPolicy(String key, String value) {
        if (POLICY_RECORD.equals(value)) {
            this.setPolicy(key, true);
            return true;
        }
        if (POLICY_IGNORE.equals(value)) {
            this.setPolicy(key, false);
            return true;
        }
        return false;
    }

    public void removePolicy(String key) {
        this.policies.remove(key);
    }

    public Map<URI, Pair<String, String>> getPreferences() {
        return this.preferences;
    }

    public void setPreferences(Map<URI, Pair<String, String>> preferences) {
        this.preferences = preferences;
    }

    public void removePreferences(Collection<URI> keys) {
        this.preferencesToRemove.addAll(keys);
    }

    public CommitHandler getCommitHandler() {
        return this.commitHandler;
    }

    public void setCommitHandler(CommitHandler commitHandler) {
        this.commitHandler = commitHandler;
    }

    public Map<String, PreferenceTask> getCommitResult() {
        return this.commitResult;
    }

    public boolean isCommitted() {
        return this.commitResult != null;
    }

    public Map<String, PreferenceTask> commit() {
        if (this.commitResult == null) {
            this.commitResult = new HashMap<String, PreferenceTask>();
            if (this.isDirty()) {
                this.doCommit(this.commitResult);
            }
        }
        return this.commitResult;
    }

    protected abstract void doCommit(Map<String, PreferenceTask> var1);

    protected final List<? extends Object> applyChanges(Map<String, PreferenceTask> preferenceTasks) {
        ArrayList<Object> recorderObjects = new ArrayList<Object>();
        if (this.recorderAnnotation == null) {
            CompoundTask preferenceCompound = SetupFactory.eINSTANCE.createCompoundTask(Messages.RecorderTransaction_preferenceCompound_name);
            this.preferenceContainer = preferenceCompound;
            this.rootObject.getSetupTasks().add(0, (Object)preferenceCompound);
            this.recorderAnnotation = BaseFactory.eINSTANCE.createAnnotation("http://www.eclipse.org/oomph/setup/UserPreferences");
            this.preferenceContainer.getAnnotations().add((Object)this.recorderAnnotation);
        }
        this.migrateOldTasks();
        Iterator<Map.Entry<String, Boolean>> it = this.policies.entrySet().iterator();
        while (it.hasNext()) {
            String defaultValue;
            Map.Entry<String, Boolean> entry = it.next();
            String key = entry.getKey();
            boolean value = entry.getValue();
            if (!(value ? POLICY_RECORD : POLICY_IGNORE).equals(defaultValue = DEFAULT_POLICIES.get(key))) continue;
            it.remove();
            this.cleanPolicies.put(key, value);
        }
        if (!this.policies.isEmpty()) {
            recorderObjects.add(this.recorderAnnotation);
            EMap details = this.recorderAnnotation.getDetails();
            Map workspacePolicies = null;
            boolean workspacePoliciesChanged = false;
            IFile workspacePoliciesFile = RecorderTransaction.getWorkspacePropertiesFile();
            for (Map.Entry<String, Boolean> entry : this.policies.entrySet()) {
                String path = entry.getKey();
                boolean policy = entry.getValue();
                details.put((Object)path, (Object)(policy ? POLICY_RECORD : POLICY_IGNORE));
                this.cleanPolicies.put(path, policy);
                if (policy) continue;
                URI key = PreferencesFactory.eINSTANCE.createURI(path);
                this.preferencesToRemove.add(key);
                if (workspacePoliciesFile == null) continue;
                if (workspacePolicies == null && workspacePoliciesFile.isAccessible()) {
                    workspacePolicies = PropertiesUtil.loadProperties((File)workspacePoliciesFile.getLocation().toFile());
                }
                if (workspacePolicies == null || POLICY_IGNORE.equals(workspacePolicies.get(path))) continue;
                workspacePolicies.put(path, POLICY_IGNORE);
                DEFAULT_POLICIES_LOCAL.put(path, POLICY_IGNORE);
                workspacePoliciesChanged = true;
            }
            if (workspacePoliciesChanged) {
                try {
                    PropertiesUtil.saveProperties((File)workspacePoliciesFile.getLocation().toFile(), workspacePolicies, (boolean)true);
                    workspacePoliciesFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception ex) {
                    SetupUIPlugin.INSTANCE.log(ex);
                }
            }
            this.policies.clear();
        }
        if (!this.preferencesToRemove.isEmpty()) {
            if (this.preferences == null) {
                this.preferences = new HashMap<URI, Pair<String, String>>();
            }
            for (URI key : this.preferencesToRemove) {
                this.preferences.put(key, (Pair<String, String>)new Pair(null, (Object)REMOVE_PREFERENCE_MARKER));
            }
        }
        if (this.preferences != null) {
            RecorderTransaction.record(this.preferences, (EList<SetupTask>)this.preferenceContainer.getSetupTasks(), recorderObjects, preferenceTasks);
            this.preferences = null;
            if (this.commitHandler != null) {
                for (PreferenceTask preferenceTask : preferenceTasks.values()) {
                    this.commitHandler.handlePreferenceTask(preferenceTask);
                }
            }
        }
        this.preferencesToRemove.clear();
        return recorderObjects;
    }

    protected void initializePolicies() {
        boolean changed = false;
        for (Map.Entry<String, String> entry : DEFAULT_POLICIES.entrySet()) {
            try {
                String key = entry.getKey();
                if (this.cleanPolicies.containsKey(key)) continue;
                changed |= this.setPolicy(key, entry.getValue());
            }
            catch (Exception ex) {
                SetupUIPlugin.INSTANCE.log(ex, 2);
            }
        }
        if (changed) {
            this.commit();
            this.commitResult = null;
        }
    }

    private static Map<String, String> getPoliciesFromProperties() {
        LinkedHashMap<String, String> policies = new LinkedHashMap<String, String>();
        OomphPlugin.BundleFile policiesFile = SetupUIPlugin.INSTANCE.getRootFile().getChild(POLICIES_FILE_NAME);
        if (policiesFile != null) {
            String contents = policiesFile.getContentsString();
            String[] lines = LINE_SEPARATOR_PATTERN.split(contents);
            int i = 0;
            while (i < lines.length) {
                try {
                    int pos;
                    String line = lines[i].trim();
                    if (line.length() != 0 && (pos = line.lastIndexOf(61)) != -1) {
                        String key = line.substring(0, pos).trim();
                        String value = line.substring(pos + 1).trim();
                        policies.put(key, value);
                    }
                }
                catch (Exception ex) {
                    SetupUIPlugin.INSTANCE.log(ex, 2);
                }
                ++i;
            }
        }
        return policies;
    }

    private static Map<String, String> getPoliciesFromExtensions() {
        LinkedHashMap<String, String> policies = new LinkedHashMap<String, String>();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensionRegistry.getConfigurationElementsFor(POLICIES_EXT_POINT);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            try {
                String pluginRelativePath = configurationElement.getAttribute("pluginRelativePath");
                while (pluginRelativePath != null && pluginRelativePath.startsWith("/")) {
                    pluginRelativePath = pluginRelativePath.substring(1);
                }
                if (!StringUtil.isEmpty((String)pluginRelativePath)) {
                    String policy = configurationElement.getAttribute("policy");
                    IContributor contributor = configurationElement.getContributor();
                    String contributorName = contributor.getName();
                    String key = "/instance/" + contributorName + "/" + pluginRelativePath;
                    policies.put(key, policy);
                }
            }
            catch (Exception ex) {
                SetupUIPlugin.INSTANCE.log(ex, 2);
            }
            ++n2;
        }
        return policies;
    }

    private static Map<String, String> getDefaultPolicies() {
        Map<String, String> policies = RecorderTransaction.getPoliciesFromProperties();
        policies.putAll(RecorderTransaction.getPoliciesFromExtensions());
        return policies;
    }

    private void findRecorderAnnotation(SetupTaskContainer container) {
        if (container instanceof CompoundTask) {
            CompoundTask compound = (CompoundTask)container;
            this.recorderAnnotation = compound.getAnnotation("http://www.eclipse.org/oomph/setup/UserPreferences");
            if (this.recorderAnnotation != null) {
                this.preferenceContainer = compound;
                return;
            }
        }
        for (SetupTask setupTask : container.getSetupTasks()) {
            if (!(setupTask instanceof SetupTaskContainer)) continue;
            this.findRecorderAnnotation((SetupTaskContainer)setupTask);
            if (this.recorderAnnotation == null) continue;
            return;
        }
    }

    private void migrateOldTasks() {
        this.migrateOldTasksRecursively(this.rootObject);
        EList pluginCompounds = this.preferenceContainer.getSetupTasks();
        ECollections.sort((EList)pluginCompounds, (Comparator)new Comparator<SetupTask>(){

            @Override
            public int compare(SetupTask o1, SetupTask o2) {
                if (o1 instanceof CompoundTask) {
                    if (o2 instanceof CompoundTask) {
                        String n1 = StringUtil.safe((String)((CompoundTask)o1).getName()).toLowerCase();
                        String n2 = StringUtil.safe((String)((CompoundTask)o2).getName()).toLowerCase();
                        return n1.compareTo(n2);
                    }
                    return -1;
                }
                if (o2 instanceof CompoundTask) {
                    return 1;
                }
                return 0;
            }
        });
        for (SetupTask pluginCompound : pluginCompounds) {
            if (!(pluginCompound instanceof CompoundTask)) continue;
            EList preferenceTasks = ((CompoundTask)pluginCompound).getSetupTasks();
            ECollections.sort((EList)preferenceTasks, (Comparator)new Comparator<SetupTask>(){

                @Override
                public int compare(SetupTask o1, SetupTask o2) {
                    if (o1 instanceof PreferenceTask) {
                        if (o2 instanceof PreferenceTask) {
                            String n1 = StringUtil.safe((String)((PreferenceTask)o1).getKey()).toLowerCase();
                            String n2 = StringUtil.safe((String)((PreferenceTask)o2).getKey()).toLowerCase();
                            return n1.compareTo(n2);
                        }
                        return -1;
                    }
                    if (o2 instanceof PreferenceTask) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
    }

    private void migrateOldTasksRecursively(SetupTaskContainer container) {
        if (container == this.preferenceContainer) {
            return;
        }
        EList setupTasks = container.getSetupTasks();
        SetupTask[] setupTaskArray = (SetupTask[])setupTasks.toArray((Object[])new SetupTask[setupTasks.size()]);
        int n = setupTaskArray.length;
        int n2 = 0;
        while (n2 < n) {
            SetupTask task = setupTaskArray[n2];
            if (task.getRestrictions().isEmpty()) {
                if (task instanceof PreferenceTask) {
                    URI keyURI;
                    PreferenceTask preferenceTask = (PreferenceTask)task;
                    String key = preferenceTask.getKey();
                    if (key != null && (keyURI = URI.createURI((String)key)).segmentCount() > 1) {
                        String pluginID = keyURI.segment(1).toString();
                        CompoundTask pluginCompound = (CompoundTask)RecorderTransaction.getPreferenceTask((EList<SetupTask>)this.preferenceContainer.getSetupTasks(), SetupPackage.Literals.COMPOUND_TASK__NAME, pluginID, true);
                        pluginCompound.getSetupTasks().add((Object)preferenceTask);
                        EObject eContainer = preferenceTask.eContainer();
                        while (eContainer instanceof CompoundTask) {
                            CompoundTask oldCompound = (CompoundTask)eContainer;
                            if (oldCompound.getSetupTasks().isEmpty()) {
                                eContainer = oldCompound.eContainer();
                                EcoreUtil.remove((EObject)oldCompound);
                                continue;
                            }
                            break;
                        }
                    }
                } else if (task instanceof SetupTaskContainer) {
                    this.migrateOldTasksRecursively((SetupTaskContainer)task);
                }
            }
            ++n2;
        }
    }

    private static SetupTask getPreferenceTask(EList<SetupTask> tasks, EAttribute key, String value, boolean createOnDemand) {
        int position = 0;
        String value1 = StringUtil.safe((String)value).toLowerCase();
        for (SetupTask task : tasks) {
            if (task.eClass().getEAllStructuralFeatures().contains((Object)key)) {
                String value2 = StringUtil.safe((String)((String)task.eGet((EStructuralFeature)key))).toLowerCase();
                int compare = value2.compareTo(value1);
                if (compare == 0) {
                    return task;
                }
                if (compare >= 0) continue;
                ++position;
                continue;
            }
            ++position;
        }
        if (!createOnDemand) {
            return null;
        }
        EClass eClass = key.getEContainingClass();
        SetupTask task = (SetupTask)EcoreUtil.create((EClass)eClass);
        task.eSet((EStructuralFeature)key, (Object)value);
        tasks.add(position, (Object)task);
        return task;
    }

    private static IFile getWorkspacePropertiesFile() {
        try {
            return ResourcesPlugin.getWorkspace().getRoot().getProject("org.eclipse.oomph.setup.ui").getFile(POLICIES_FILE_NAME);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    private static SetupTaskContainer getRootObject(Resource resource, String fragment) {
        EObject eObject;
        if (!StringUtil.isEmpty((String)fragment) && (eObject = resource.getEObject(fragment)) instanceof SetupTaskContainer) {
            return (SetupTaskContainer)eObject;
        }
        return (SetupTaskContainer)resource.getContents().get(0);
    }

    private static void record(Map<URI, Pair<String, String>> preferences, EList<SetupTask> setupTasks, List<Object> recorderObjects, Map<String, PreferenceTask> preferenceTasks) {
        for (Map.Entry<URI, Pair<String, String>> entry : preferences.entrySet()) {
            PreferenceTask preferenceTask;
            String oldValue;
            boolean remove;
            URI key = entry.getKey();
            PreferenceTaskImpl.PreferenceHandler handler = PreferenceTaskImpl.PreferenceHandler.getHandler((URI)key);
            String newValue = (String)entry.getValue().getElement2();
            boolean bl = remove = newValue == REMOVE_PREFERENCE_MARKER;
            if (!remove && handler.isNeeded(oldValue = SetupUtil.escape((String)((String)entry.getValue().getElement1())), newValue = SetupUtil.escape((String)newValue))) {
                newValue = handler.delta();
            }
            String pluginID = key.segment(0).toString();
            String path = PreferencesFactory.eINSTANCE.convertURI(key);
            CompoundTask pluginCompound = (CompoundTask)RecorderTransaction.getPreferenceTask(setupTasks, SetupPackage.Literals.COMPOUND_TASK__NAME, pluginID, !remove);
            if (pluginCompound == null || (preferenceTask = (PreferenceTask)RecorderTransaction.getPreferenceTask((EList<SetupTask>)pluginCompound.getSetupTasks(), SetupPackage.Literals.PREFERENCE_TASK__KEY, path, !remove)) == null) continue;
            if (remove) {
                EcoreUtil.remove((EObject)preferenceTask);
                if (pluginCompound.getSetupTasks().isEmpty()) {
                    recorderObjects.add(pluginCompound.eContainer());
                    EcoreUtil.remove((EObject)pluginCompound);
                } else {
                    recorderObjects.add(pluginCompound);
                }
            } else {
                String value = preferenceTask.getValue();
                handler.isNeeded(value, newValue);
                newValue = handler.merge();
                preferenceTask.setValue(newValue);
                recorderObjects.add(preferenceTask);
            }
            if (preferenceTasks == null) continue;
            preferenceTasks.put(path, preferenceTask);
        }
    }

    public static List<SetupTask> record(Map<URI, Pair<String, String>> preferences) {
        BasicEList setupTasks = new BasicEList();
        ArrayList<Object> recorderObjects = new ArrayList<Object>();
        RecorderTransaction.record(preferences, (EList<SetupTask>)setupTasks, recorderObjects, null);
        return setupTasks;
    }

    public static RecorderTransaction open() {
        if (instance == null) {
            URI targetURI = RecorderManager.INSTANCE.getRecorderTarget();
            final String targetFragment = targetURI.fragment();
            final URI targetResourceURI = targetURI.trimFragment();
            final IEditorPart[] editor = new IEditorPart[1];
            final CountDownLatch editorLoadedLatch = new CountDownLatch(1);
            IWorkbench workbench = null;
            try {
                workbench = PlatformUI.getWorkbench();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (workbench != null) {
                IWorkbenchPage page;
                IWorkbenchWindow[] windows;
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (window == null && (windows = workbench.getWorkbenchWindows()).length != 0) {
                    window = windows[0];
                }
                IWorkbenchPage iWorkbenchPage = page = window != null ? window.getActivePage() : null;
                if (page != null) {
                    UIUtil.syncExec((Runnable)new Runnable(){

                        public void run() {
                            editor[0] = SetupEditorSupport.getEditor(page, targetResourceURI, false, new SetupEditorSupport.LoadHandler(){

                                protected void loaded(IEditorPart editor, EditingDomain domain, Resource resource) {
                                    SetupTaskContainer rootObject = RecorderTransaction.getRootObject(resource, targetFragment);
                                    instance = (RecorderTransaction)new EditorTransaction(editor, domain, rootObject);
                                    editorLoadedLatch.countDown();
                                }
                            });
                        }
                    });
                }
            }
            if (editor[0] != null) {
                try {
                    editorLoadedLatch.await();
                }
                catch (InterruptedException ex) {
                    throw new Error(ex);
                }
            } else {
                ResourceSet resourceSet = SetupCoreUtil.createResourceSet();
                Resource resource = resourceSet.getResource(targetResourceURI, true);
                SetupTaskContainer rootObject = RecorderTransaction.getRootObject(resource, targetFragment);
                instance = new ResourceTransaction(rootObject);
            }
        }
        return instance;
    }

    public static RecorderTransaction open(IEditorPart editor) {
        if (instance != null) {
            throw new IllegalStateException("A recorder transaction is already open");
        }
        EditingDomain domain = ((IEditingDomainProvider)editor).getEditingDomain();
        instance = new EditorTransaction(editor, domain, (Resource)domain.getResourceSet().getResources().get(0));
        return instance;
    }

    public static RecorderTransaction openTmp(Resource resource) {
        SetupTaskContainer rootObject = RecorderTransaction.getRootObject(resource, null);
        return new TmpTransaction(rootObject);
    }

    static RecorderTransaction getInstance() {
        return instance;
    }

    public static interface CommitHandler {
        public void handlePreferenceTask(PreferenceTask var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EditorTransaction
    extends RecorderTransaction {
        private final IEditorPart editor;
        private final EditingDomain domain;
        private final boolean editorWasClean;

        public EditorTransaction(IEditorPart editor, EditingDomain domain, Resource resource) {
            this(editor, domain, (SetupTaskContainer)RecorderManager.INSTANCE.getRecorderTargetObject(resource.getResourceSet()));
        }

        public EditorTransaction(IEditorPart editor, EditingDomain domain, SetupTaskContainer rootObject) {
            super(rootObject);
            this.editor = editor;
            this.domain = domain;
            this.editorWasClean = !editor.isDirty();
            this.initializePolicies();
        }

        @Override
        public IEditorPart getEditor() {
            return this.editor;
        }

        @Override
        protected void doCommit(final Map<String, PreferenceTask> preferenceTasks) {
            ISelection selection = ((ISelectionProvider)this.editor).getSelection();
            final List oldSelection = selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).toList() : Collections.emptyList();
            final ChangeCommand command = new ChangeCommand((Notifier)this.domain.getResourceSet()){
                List<? extends Object> recorderObjects;
                List<? extends Object> affectedObjects;
                {
                    super($anonymous0);
                    this.recorderObjects = Collections.emptyList();
                    this.affectedObjects = Collections.emptyList();
                }

                public String getLabel() {
                    return Messages.RecorderTransaction_changeCommand_label;
                }

                public String getDescription() {
                    return Messages.RecorderTransaction_changeCommand_description;
                }

                public Collection<?> getAffectedObjects() {
                    return this.affectedObjects;
                }

                protected void doExecute() {
                    this.recorderObjects = EditorTransaction.this.applyChanges(preferenceTasks);
                    this.affectedObjects = this.recorderObjects;
                }

                public void undo() {
                    super.undo();
                    this.affectedObjects = oldSelection;
                }

                public void redo() {
                    super.redo();
                    this.affectedObjects = this.recorderObjects;
                }
            };
            UIUtil.syncExec((Runnable)new Runnable(){

                public void run() {
                    CommandStack commandStack = EditorTransaction.this.domain.getCommandStack();
                    commandStack.execute((Command)command);
                    if (EditorTransaction.this.editorWasClean && EditorTransaction.this.editor.isDirty()) {
                        EditorTransaction.this.editor.doSave((IProgressMonitor)new NullProgressMonitor());
                    }
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResourceTransaction
    extends RecorderTransaction {
        public ResourceTransaction(SetupTaskContainer rootObject) {
            super(rootObject);
            this.initializePolicies();
        }

        @Override
        protected void doCommit(Map<String, PreferenceTask> preferenceTasks) {
            List<? extends Object> recorderObjects = this.applyChanges(preferenceTasks);
            if (recorderObjects != null) {
                try {
                    this.getResource().save(Collections.singletonMap("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER"));
                }
                catch (IOException ex) {
                    SetupUIPlugin.INSTANCE.log(ex);
                }
            }
        }
    }

    private static final class TmpTransaction
    extends ResourceTransaction {
        public TmpTransaction(SetupTaskContainer rootObject) {
            super(rootObject);
        }

        public void close() {
        }
    }
}

