/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.AbstractObservableList;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.runtime.Assert;

public class MultiList<E>
extends AbstractObservableList<E> {
    private List<IObservableList<E>> lists;
    private Object elementType;
    private IListChangeListener<E> listChangeListener;
    private IStaleListener staleListener;
    private Boolean stale;

    @Deprecated
    public MultiList(IObservableList<E>[] lists) {
        this(Realm.getDefault(), lists, null);
    }

    public MultiList(List<IObservableList<E>> lists) {
        this(Realm.getDefault(), lists, null);
    }

    @Deprecated
    public MultiList(IObservableList<E>[] lists, Object elementType) {
        this(Realm.getDefault(), lists, elementType);
    }

    public MultiList(List<IObservableList<E>> lists, Object elementType) {
        this(Realm.getDefault(), lists, elementType);
    }

    public MultiList(Realm realm, IObservableList<E>[] lists) {
        this(realm, lists, null);
    }

    @Deprecated
    public MultiList(Realm realm, IObservableList<E>[] lists, Object elementType) {
        super(realm);
        this.lists = new ArrayList<IObservableList<E>>(lists.length);
        this.lists.addAll(Arrays.asList(lists));
        this.elementType = elementType;
        IObservableList<E>[] iObservableListArray = lists;
        int n = lists.length;
        int n2 = 0;
        while (n2 < n) {
            IObservableList<E> list = iObservableListArray[n2];
            Assert.isTrue((boolean)realm.equals(list.getRealm()), (String)"All source lists in a MultiList must belong to the same realm");
            ++n2;
        }
    }

    public MultiList(Realm realm, List<IObservableList<E>> lists, Object elementType) {
        super(realm);
        this.lists = lists;
        this.elementType = elementType;
        for (IObservableList<IObservableList<E>> list : lists) {
            Assert.isTrue((boolean)realm.equals(list.getRealm()), (String)"All source lists in a MultiList must belong to the same realm");
        }
    }

    @Override
    protected void firstListenerAdded() {
        if (this.listChangeListener == null) {
            this.listChangeListener = event -> this.getRealm().exec(() -> {
                this.stale = null;
                this.listChanged(event);
                if (this.isStale()) {
                    this.fireStale();
                }
            });
        }
        if (this.staleListener == null) {
            this.staleListener = staleEvent -> this.getRealm().exec(this::makeStale);
        }
        for (IObservableList<E> list : this.lists) {
            list.addListChangeListener(this.listChangeListener);
            list.addStaleListener(this.staleListener);
            this.stale = this.computeStaleness();
        }
    }

    @Override
    protected void lastListenerRemoved() {
        if (this.listChangeListener != null) {
            for (IObservableList<E> list : this.lists) {
                list.removeListChangeListener(this.listChangeListener);
            }
            this.listChangeListener = null;
        }
        if (this.staleListener != null) {
            for (IObservableList<E> list : this.lists) {
                list.removeStaleListener(this.staleListener);
            }
            this.staleListener = null;
        }
        this.stale = null;
    }

    private void makeStale() {
        if (this.stale == null || !this.stale.booleanValue()) {
            this.stale = true;
            this.fireStale();
        }
    }

    private void listChanged(ListChangeEvent<? extends E> event) {
        IObservableList<? extends E> source = event.getObservableList();
        this.fireListChange(this.offsetListDiff(this.computeOffset(source), event.diff));
    }

    private int computeOffset(List<? extends E> chanedList) {
        int offset = 0;
        for (IObservableList<E> list : this.lists) {
            if (chanedList == list) {
                return offset;
            }
            offset += list.size();
        }
        throw new IllegalArgumentException("MultiList received a ListChangeEvent from an observable list that is not one of its sources.");
    }

    private ListDiff<E> offsetListDiff(int offset, ListDiff<? extends E> diff) {
        List differences = this.offsetListDiffEntries(offset, diff.getDifferences());
        return Diffs.createListDiff(differences);
    }

    private List<ListDiffEntry<E>> offsetListDiffEntries(int offset, ListDiffEntry<? extends E>[] entries) {
        ArrayList<ListDiffEntry<ListDiffEntry<? extends E>>> offsetEntries = new ArrayList<ListDiffEntry<ListDiffEntry<? extends E>>>(entries.length);
        ListDiffEntry<? extends E>[] listDiffEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            ListDiffEntry<? extends E> entry = listDiffEntryArray[n2];
            offsetEntries.add(this.offsetListDiffEntry(offset, entry));
            ++n2;
        }
        return offsetEntries;
    }

    private ListDiffEntry<E> offsetListDiffEntry(int offset, ListDiffEntry<? extends E> entry) {
        return Diffs.createListDiffEntry(offset + entry.getPosition(), entry.isAddition(), entry.getElement());
    }

    @Override
    protected int doGetSize() {
        int size = 0;
        for (IObservableList<E> list : this.lists) {
            size += list.size();
        }
        return size;
    }

    @Override
    public Object getElementType() {
        return this.elementType;
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.checkRealm();
        for (IObservableList<E> list : this.lists) {
            list.clear();
        }
    }

    @Override
    public E get(int index) {
        this.getterCalled();
        int offset = 0;
        for (IObservableList<E> list : this.lists) {
            if (index - offset < list.size()) {
                return list.get(index - offset);
            }
            offset += list.size();
        }
        throw new IndexOutOfBoundsException("index: " + index + ", size: " + offset);
    }

    @Override
    public boolean contains(Object o) {
        this.getterCalled();
        for (IObservableList<E> list : this.lists) {
            if (!list.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        this.getterCalled();
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List that = (List)o;
        if (this.doGetSize() != that.size()) {
            return false;
        }
        int subListIndex = 0;
        for (IObservableList<E> list : this.lists) {
            List subList;
            if (!list.equals(subList = that.subList(subListIndex, subListIndex + list.size()))) {
                return false;
            }
            subListIndex += list.size();
        }
        return true;
    }

    @Override
    public int hashCode() {
        this.getterCalled();
        return this.lists.hashCode();
    }

    @Override
    public int indexOf(Object o) {
        this.getterCalled();
        int offset = 0;
        for (IObservableList<E> list : this.lists) {
            int index = list.indexOf(o);
            if (index != -1) {
                return offset + index;
            }
            offset += list.size();
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        this.getterCalled();
        for (IObservableList<E> list : this.lists) {
            if (list.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        this.getterCalled();
        return new MultiListItr();
    }

    @Override
    public int lastIndexOf(Object o) {
        this.getterCalled();
        int offset = this.size();
        for (IObservableList<E> list : this.lists) {
            offset -= list.size();
            int index = list.indexOf(o);
            if (index == -1) continue;
            return offset + index;
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        this.getterCalled();
        return new MultiListListItr(index);
    }

    @Override
    public E move(int oldIndex, int newIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        this.checkRealm();
        int i = this.indexOf(o);
        if (i != -1) {
            this.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public E remove(int index) {
        int offset = 0;
        for (IObservableList<E> list : this.lists) {
            if (index - offset < list.size()) {
                return list.remove(index - offset);
            }
            offset += list.size();
        }
        throw new IndexOutOfBoundsException("index: " + index + ", size: " + offset);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (IObservableList<E> list : this.lists) {
            changed |= list.removeAll(c);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        for (IObservableList<E> list : this.lists) {
            changed |= list.retainAll(c);
        }
        return changed;
    }

    @Override
    public E set(int index, E o) {
        int offset = 0;
        for (IObservableList<E> list : this.lists) {
            if (index - offset < list.size()) {
                return list.set(index - offset, o);
            }
            offset += list.size();
        }
        throw new IndexOutOfBoundsException("index: " + index + ", size: " + offset);
    }

    @Override
    public boolean isStale() {
        this.getterCalled();
        if (this.staleListener == null || this.listChangeListener == null) {
            return this.computeStaleness();
        }
        if (this.stale == null) {
            this.stale = this.computeStaleness();
        }
        return this.stale;
    }

    private boolean computeStaleness() {
        boolean stale = false;
        for (IObservableList<E> list : this.lists) {
            if (!list.isStale()) continue;
            stale = true;
            break;
        }
        return stale;
    }

    private void getterCalled() {
        ObservableTracker.getterCalled(this);
    }

    @Override
    public synchronized void dispose() {
        if (this.lists != null) {
            if (this.listChangeListener != null) {
                for (IObservableList<E> list : this.lists) {
                    list.removeListChangeListener(this.listChangeListener);
                }
            }
            if (this.staleListener != null) {
                for (IObservableList<E> list : this.lists) {
                    list.removeStaleListener(this.staleListener);
                }
            }
        }
        this.listChangeListener = null;
        this.staleListener = null;
        this.lists = null;
        this.elementType = null;
        this.stale = null;
        super.dispose();
    }

    private final class MultiListItr
    implements Iterator<E> {
        private List<Iterator<E>> iters;
        private int iterIndex = 0;

        private MultiListItr() {
            this.iters = new ArrayList(MultiList.this.lists.size());
            for (IObservableList list : MultiList.this.lists) {
                this.iters.add(list.iterator());
            }
        }

        @Override
        public boolean hasNext() {
            int i = this.iterIndex;
            while (i < this.iters.size()) {
                if (this.iters.get(i).hasNext()) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        @Override
        public E next() {
            while (this.iterIndex < this.iters.size() && !this.iters.get(this.iterIndex).hasNext()) {
                ++this.iterIndex;
            }
            return this.iters.get(this.iterIndex).next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class MultiListListItr
    implements ListIterator<E> {
        private List<ListIterator<E>> iters;
        private int iterIndex;

        private MultiListListItr(int initialIndex) {
            this.iters = new ArrayList(MultiList.this.lists.size());
            int offset = 0;
            int i = 0;
            while (i < MultiList.this.lists.size()) {
                IObservableList list = (IObservableList)MultiList.this.lists.get(i);
                if (offset <= initialIndex) {
                    if (offset + list.size() > initialIndex) {
                        this.iters.add(list.listIterator(initialIndex - offset));
                        this.iterIndex = i;
                    } else {
                        this.iters.add(list.listIterator(list.size()));
                    }
                } else {
                    this.iters.add(list.listIterator());
                }
                offset += list.size();
                ++i;
            }
        }

        @Override
        public void add(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            int i = this.iterIndex;
            while (i < this.iters.size()) {
                if (this.iters.get(i).hasNext()) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        @Override
        public boolean hasPrevious() {
            int i = this.iterIndex;
            while (i >= 0) {
                if (this.iters.get(i).hasPrevious()) {
                    return true;
                }
                --i;
            }
            return false;
        }

        @Override
        public E next() {
            while (this.iterIndex < this.iters.size() && !this.iters.get(this.iterIndex).hasNext()) {
                ++this.iterIndex;
            }
            return this.iters.get(this.iterIndex).next();
        }

        @Override
        public int nextIndex() {
            int offset = 0;
            int i = 0;
            while (i < this.iterIndex) {
                offset += this.iters.get(i).nextIndex();
                ++i;
            }
            return offset + this.iters.get(this.iterIndex).nextIndex();
        }

        @Override
        public E previous() {
            while (this.iterIndex >= 0 && !this.iters.get(this.iterIndex).hasPrevious()) {
                --this.iterIndex;
            }
            return this.iters.get(this.iterIndex).previous();
        }

        @Override
        public int previousIndex() {
            int offset = 0;
            int i = 0;
            while (i < this.iterIndex) {
                offset += this.iters.get(i).nextIndex();
                ++i;
            }
            return offset + this.iters.get(this.iterIndex).previousIndex();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E o) {
            this.iters.get(this.iterIndex).set(o);
        }
    }
}

