/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.util;

import java.util.ArrayList;

public final class StringUtils {
    public static final String[] splitOnSpace(String string) {
        int index = string.indexOf(32);
        if (index == -1) {
            return new String[]{string};
        }
        ArrayList<String> split = new ArrayList<String>();
        while (index != -1) {
            split.add(string.substring(0, index));
            string = string.substring(index + 1);
            index = string.indexOf(32);
        }
        if (!string.equals("")) {
            split.add(string);
        }
        return split.toArray(new String[split.size()]);
    }

    public static final String[] split(String string, char character) {
        int index = string.indexOf(character);
        if (index == -1) {
            return new String[]{string};
        }
        ArrayList<String> split = new ArrayList<String>();
        while (index != -1) {
            split.add(string.substring(0, index));
            string = string.substring(index + 1);
            index = string.indexOf(character);
        }
        if (!string.equals("")) {
            split.add(string);
        }
        return split.toArray(new String[split.size()]);
    }

    public static final String[] split(String string, String delimiter) {
        int index = string.indexOf(delimiter);
        if (index == -1) {
            return new String[]{string};
        }
        int length = delimiter.length();
        ArrayList<String> split = new ArrayList<String>();
        while (index != -1) {
            split.add(string.substring(0, index));
            string = string.substring(index + length);
            index = string.indexOf(delimiter);
        }
        if (!string.equals("")) {
            split.add(string);
        }
        return split.toArray(new String[split.size()]);
    }

    public static final String[] split(String string, String delimiter, int limit) {
        int index = string.indexOf(delimiter);
        if (index == -1) {
            return new String[]{string};
        }
        int count = 0;
        int length = delimiter.length();
        ArrayList<String> split = new ArrayList<String>(limit);
        while (index != -1 && count < limit - 1) {
            split.add(string.substring(0, index));
            string = string.substring(index + length);
            index = string.indexOf(delimiter);
            ++count;
        }
        if (!string.equals("")) {
            split.add(string);
        }
        return split.toArray(new String[split.size()]);
    }

    public static final String splitSubstring(String string, String delimiter, int pos) {
        int index = string.indexOf(delimiter);
        if (index == -1) {
            return string;
        }
        int count = 0;
        int length = delimiter.length();
        while (count < pos) {
            string = string.substring(index + length);
            index = string.indexOf(delimiter);
            ++count;
        }
        return index == -1 ? string : string.substring(0, index);
    }

    public static final String xmlDecode(String string) {
        if (string.equals("")) {
            return string;
        }
        int index = string.indexOf("&amp;");
        while (index != -1) {
            string = String.valueOf(string.substring(0, index)) + '&' + string.substring(index + 5);
            index = string.indexOf("&amp;", index + 1);
        }
        index = string.indexOf("&quot;");
        while (index != -1) {
            string = String.valueOf(string.substring(0, index)) + '\"' + string.substring(index + 6);
            index = string.indexOf("&quot;", index + 1);
        }
        index = string.indexOf("&apos;");
        while (index != -1) {
            string = String.valueOf(string.substring(0, index)) + '\'' + string.substring(index + 6);
            index = string.indexOf("&apos;", index + 1);
        }
        index = string.indexOf("&lt;");
        while (index != -1) {
            string = String.valueOf(string.substring(0, index)) + '<' + string.substring(index + 4);
            index = string.indexOf("&lt;", index + 1);
        }
        index = string.indexOf("&gt;");
        while (index != -1) {
            string = String.valueOf(string.substring(0, index)) + '>' + string.substring(index + 4);
            index = string.indexOf("&gt;", index + 1);
        }
        return string;
    }

    public static final String xmlEncode(String string) {
        if (string.equals("")) {
            return string;
        }
        int index = string.indexOf(38);
        while (index != -1) {
            string = String.valueOf(string.substring(0, index)) + "&amp;" + string.substring(index + 1);
            index = string.indexOf(38, index + 1);
        }
        index = string.indexOf(34);
        while (index != -1) {
            string = String.valueOf(string.substring(0, index)) + "&quot;" + string.substring(index + 1);
            index = string.indexOf(34, index + 1);
        }
        index = string.indexOf(39);
        while (index != -1) {
            string = String.valueOf(string.substring(0, index)) + "&apos;" + string.substring(index + 1);
            index = string.indexOf(39, index + 1);
        }
        index = string.indexOf(60);
        while (index != -1) {
            string = String.valueOf(string.substring(0, index)) + "&lt;" + string.substring(index + 1);
            index = string.indexOf(60, index + 1);
        }
        index = string.indexOf(62);
        while (index != -1) {
            string = String.valueOf(string.substring(0, index)) + "&gt;" + string.substring(index + 1);
            index = string.indexOf(62, index + 1);
        }
        return string;
    }

    public static boolean contains(String string, String target) {
        return string.contains(target);
    }

    public static String replaceAll(String string, String target, String replace) {
        int index = string.indexOf(target);
        if (index == -1) {
            return string;
        }
        return String.valueOf(string.substring(0, index)) + replace + StringUtils.replaceAll(string.substring(index + target.length()), target, replace);
    }

    public static String replaceAllIgnoreCase(String string, String target, String replace) {
        int index = string.toLowerCase().indexOf(target.toLowerCase());
        if (index == -1) {
            return string;
        }
        return String.valueOf(string.substring(0, index)) + replace + StringUtils.replaceAllIgnoreCase(string.substring(index + target.length()), target, replace);
    }

    public static String replaceFirst(String string, String target, String replace) {
        int index = string.indexOf(target);
        if (index == -1) {
            return string;
        }
        return String.valueOf(string.substring(0, index)) + replace + string.substring(index + target.length());
    }
}

