/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui;

import java.io.File;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.TrustCertificateDialog;
import org.eclipse.equinox.internal.p2.ui.dialogs.UserValidationDialog;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.repository.artifact.spi.IArtifactUIServices;
import org.eclipse.equinox.p2.repository.spi.PGPPublicKeyService;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ValidationDialogServiceUI
extends UIServices
implements IArtifactUIServices {
    private final IProvisioningAgent agent;
    private Display display;
    private Consumer<String> linkHandler = link -> {
        if (PlatformUI.isWorkbenchRunning()) {
            try {
                URL url = new URL((String)link);
                PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(url);
            }
            catch (Exception x) {
                ProvUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.equinox.p2.ui", x.getMessage(), (Throwable)x));
            }
        }
    };
    private IShellProvider shellProvider = () -> ProvUI.getDefaultParentShell();

    public ValidationDialogServiceUI() {
        this(null);
    }

    public ValidationDialogServiceUI(IProvisioningAgent agent) {
        this.agent = agent;
    }

    public UIServices.AuthenticationInfo getUsernamePassword(String location) {
        UIServices.AuthenticationInfo[] result = new UIServices.AuthenticationInfo[1];
        if (!this.suppressAuthentication() && !this.isHeadless()) {
            this.getDisplay().syncExec(() -> {
                String message;
                Shell shell = this.shellProvider.getShell();
                UserValidationDialog dialog = new UserValidationDialog(shell, ProvUIMessages.ServiceUI_LoginRequired, null, message = NLS.bind((String)ProvUIMessages.ServiceUI_LoginDetails, (Object)location));
                int dialogCode = dialog.open();
                if (dialogCode == 0) {
                    authenticationInfoArray[0] = dialog.getResult();
                } else if (dialogCode == 1) {
                    authenticationInfoArray[0] = AUTHENTICATION_PROMPT_CANCELED;
                }
            });
        }
        return result[0];
    }

    private boolean suppressAuthentication() {
        Job job = Job.getJobManager().currentJob();
        if (job != null) {
            return job.getProperty(LoadMetadataRepositoryJob.SUPPRESS_AUTHENTICATION_JOB_MARKER) != null;
        }
        return false;
    }

    public UIServices.TrustInfo getTrustInfo(Certificate[][] untrustedChains, String[] unsignedDetail) {
        return this.getTrustInfo(untrustedChains, Collections.emptyList(), unsignedDetail);
    }

    public UIServices.TrustInfo getTrustInfo(Certificate[][] untrustedChains, Collection<PGPPublicKey> untrustedPublicKeys, final String[] unsignedDetail) {
        if (untrustedChains == null) {
            untrustedChains = new Certificate[][]{};
        }
        boolean trustUnsigned = true;
        boolean persistTrust = false;
        ArrayList trustedCertificates = new ArrayList();
        ArrayList trustedKeys = new ArrayList();
        if (!this.isHeadless() && unsignedDetail != null && unsignedDetail.length > 0) {
            final boolean[] result = new boolean[1];
            this.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = ValidationDialogServiceUI.this.shellProvider.getShell();
                    OkCancelErrorDialog dialog = new OkCancelErrorDialog(shell, ProvUIMessages.ServiceUI_warning_title, null, this.createStatus(), 2);
                    result[0] = dialog.open() == 0;
                }

                private IStatus createStatus() {
                    MultiStatus parent = new MultiStatus("org.eclipse.equinox.p2.ui", 0, ProvUIMessages.ServiceUI_unsigned_message, null);
                    String[] stringArray = unsignedDetail;
                    int n = unsignedDetail.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String element = stringArray[n2];
                        parent.add((IStatus)new Status(2, "org.eclipse.equinox.p2.ui", element));
                        ++n2;
                    }
                    return parent;
                }
            });
            trustUnsigned = result[0];
        }
        if (!trustUnsigned) {
            return new UIServices.TrustInfo(trustedCertificates, trustedKeys, persistTrust, trustUnsigned);
        }
        if (!(this.isHeadless() || untrustedChains.length <= 0 && untrustedPublicKeys.isEmpty())) {
            return this.getTrustInfo(Arrays.stream(untrustedChains).collect(Collectors.toMap(certificateArray -> Arrays.asList(certificateArray), it -> Set.of(), (e1, e2) -> e1, LinkedHashMap::new)), untrustedPublicKeys.stream().collect(Collectors.toMap(Function.identity(), it -> Set.of(), (e1, e2) -> e1, LinkedHashMap::new)), null, null);
        }
        return new UIServices.TrustInfo(trustedCertificates, trustedKeys, persistTrust, trustUnsigned);
    }

    public UIServices.TrustInfo getTrustInfo(Map<List<Certificate>, Set<IArtifactKey>> untrustedCertificates, Map<PGPPublicKey, Set<IArtifactKey>> untrustedPGPKeys, Set<IArtifactKey> unsignedArtifacts, Map<IArtifactKey, File> artifacts) {
        TreeNode[] input;
        boolean trustUnsigned = true;
        AtomicBoolean persistTrust = new AtomicBoolean();
        AtomicBoolean trustAlways = new AtomicBoolean();
        ArrayList<Certificate> trustedCertificates = new ArrayList<Certificate>();
        ArrayList<PGPPublicKey> trustedKeys = new ArrayList<PGPPublicKey>();
        if (!this.isHeadless() && (input = this.createTreeNodes(untrustedCertificates, untrustedPGPKeys, unsignedArtifacts, artifacts)).length != 0) {
            trustUnsigned = unsignedArtifacts == null || unsignedArtifacts.isEmpty();
            ArrayList result = new ArrayList();
            this.getDisplay().syncExec(() -> {
                Shell shell = this.shellProvider.getShell();
                TrustCertificateDialog trustCertificateDialog = new TrustCertificateDialog(shell, input);
                if (trustCertificateDialog.open() == 0) {
                    Object[] dialogResult = trustCertificateDialog.getResult();
                    if (dialogResult != null) {
                        result.addAll(Arrays.asList(dialogResult));
                    }
                    persistTrust.set(trustCertificateDialog.isRememberSelectedSigners());
                    trustAlways.set(trustCertificateDialog.isTrustAlways());
                }
            });
            for (Object o : result) {
                if (o instanceof TreeNode) {
                    o = ((TreeNode)o).getValue();
                }
                if (o instanceof Certificate) {
                    trustedCertificates.add((Certificate)o);
                    continue;
                }
                if (o instanceof PGPPublicKey) {
                    trustedKeys.add((PGPPublicKey)o);
                    continue;
                }
                if (o != null) continue;
                trustUnsigned = true;
            }
        }
        return new UIServices.TrustInfo(trustedCertificates, trustedKeys, persistTrust.get(), trustUnsigned, trustAlways.get());
    }

    private TreeNode[] createTreeNodes(Map<List<Certificate>, Set<IArtifactKey>> untrustedCertificates, Map<PGPPublicKey, Set<IArtifactKey>> untrustedPGPKeys, Set<IArtifactKey> unsignedArtifacts, Map<IArtifactKey, File> artifacts) {
        Set<IArtifactKey> associatedArtifacts;
        PGPPublicKey key;
        ArrayList<ExtendedTreeNode> children = new ArrayList<ExtendedTreeNode>();
        if (untrustedCertificates != null && !untrustedCertificates.isEmpty()) {
            for (Map.Entry<List<Certificate>, Set<IArtifactKey>> entry : untrustedCertificates.entrySet()) {
                ExtendedTreeNode parent = null;
                key = entry.getKey();
                associatedArtifacts = entry.getValue();
                for (Certificate certificate : key) {
                    ExtendedTreeNode node = new ExtendedTreeNode(certificate, associatedArtifacts);
                    if (parent == null) {
                        children.add(node);
                    } else {
                        node.setParent(parent);
                        parent.setChildren(new TreeNode[]{node});
                    }
                    parent = node;
                }
            }
        }
        if (untrustedPGPKeys != null && !untrustedPGPKeys.isEmpty()) {
            PGPPublicKeyService keyService = this.agent == null ? null : (PGPPublicKeyService)this.agent.getService(PGPPublicKeyService.class);
            for (Map.Entry<PGPPublicKey, Set<IArtifactKey>> entry : untrustedPGPKeys.entrySet()) {
                key = entry.getKey();
                associatedArtifacts = entry.getValue();
                ExtendedTreeNode node = new ExtendedTreeNode(key, associatedArtifacts);
                children.add(node);
                this.expandChildren(node, key, keyService, new HashSet<PGPPublicKey>(), Integer.getInteger("p2.pgp.trust.depth", 3));
            }
        }
        if (unsignedArtifacts != null && !unsignedArtifacts.isEmpty()) {
            ExtendedTreeNode node = new ExtendedTreeNode(null, unsignedArtifacts);
            children.add(node);
        }
        return (TreeNode[])children.toArray(TreeNode[]::new);
    }

    private void expandChildren(TreeNode result, PGPPublicKey key, PGPPublicKeyService keyService, Set<PGPPublicKey> visited, int remainingDepth) {
        Set certifications;
        if (keyService != null && remainingDepth > 0 && visited.add(key) && (certifications = keyService.getVerifiedCertifications(key)) != null && !certifications.isEmpty()) {
            ArrayList<TreeNode> children = new ArrayList<TreeNode>();
            for (PGPPublicKey certifyingKey : certifications) {
                if (!visited.add(certifyingKey)) continue;
                TreeNode treeNode = new TreeNode((Object)certifyingKey);
                children.add(treeNode);
            }
            if (!children.isEmpty()) {
                result.setChildren((TreeNode[])children.toArray(TreeNode[]::new));
                children.forEach(child -> {
                    child.setParent(result);
                    PGPPublicKey certifyingKey = (PGPPublicKey)child.getValue();
                    visited.remove(certifyingKey);
                    this.expandChildren((TreeNode)child, certifyingKey, keyService, visited, remainingDepth - 1);
                    visited.add(certifyingKey);
                });
            }
        }
    }

    public UIServices.AuthenticationInfo getUsernamePassword(String location, UIServices.AuthenticationInfo previousInfo) {
        UIServices.AuthenticationInfo[] result = new UIServices.AuthenticationInfo[1];
        if (!this.suppressAuthentication() && !this.isHeadless()) {
            this.getDisplay().syncExec(() -> {
                Shell shell = this.shellProvider.getShell();
                String message = null;
                message = previousInfo.saveResult() ? NLS.bind((String)ProvUIMessages.ProvUIMessages_SavedNotAccepted_EnterFor_0, (Object)location) : NLS.bind((String)ProvUIMessages.ProvUIMessages_NotAccepted_EnterFor_0, (Object)location);
                UserValidationDialog dialog = new UserValidationDialog(previousInfo, shell, ProvUIMessages.ServiceUI_LoginRequired, null, message);
                int dialogCode = dialog.open();
                if (dialogCode == 0) {
                    authenticationInfoArray[0] = dialog.getResult();
                } else if (dialogCode == 1) {
                    authenticationInfoArray[0] = AUTHENTICATION_PROMPT_CANCELED;
                }
            });
        }
        return result[0];
    }

    public void showInformationMessage(String title, String text, String linkText) {
        if (this.isHeadless()) {
            super.showInformationMessage(title, text, linkText);
            return;
        }
        this.getDisplay().syncExec(() -> {
            MessageDialogWithLink dialog = new MessageDialogWithLink(this.shellProvider.getShell(), title, null, text, 2, new String[]{IDialogConstants.OK_LABEL}, 0, linkText, this.linkHandler);
            dialog.open();
        });
    }

    public Consumer<String> getLinkHandler() {
        return this.linkHandler;
    }

    public void setLinkHandler(Consumer<String> linkHandler) {
        this.linkHandler = linkHandler;
    }

    public IShellProvider getShellProvider() {
        return this.shellProvider;
    }

    public void setShellProvider(IShellProvider shellProvider) {
        this.shellProvider = shellProvider;
    }

    public Display getDisplay() {
        if (this.display == null && PlatformUI.isWorkbenchRunning()) {
            this.display = PlatformUI.getWorkbench().getDisplay();
        }
        return this.display;
    }

    public void setDisplay(Display display) {
        if (this.display != null && this.display != display) {
            throw new IllegalStateException("Cannot change the display");
        }
        this.display = display;
    }

    private boolean isHeadless() {
        return this.getDisplay() == null;
    }

    private static class ExtendedTreeNode
    extends TreeNode
    implements IAdaptable {
        private final Set<IArtifactKey> artifacts;

        public ExtendedTreeNode(Object value) {
            super(value);
            this.artifacts = null;
        }

        public ExtendedTreeNode(Object value, Set<IArtifactKey> artifacts) {
            super(value);
            this.artifacts = artifacts;
        }

        public <T> T getAdapter(Class<T> adapter) {
            if (adapter.isInstance((Object)this)) {
                return adapter.cast((Object)this);
            }
            if (adapter.isInstance(this.getValue())) {
                return adapter.cast(this.value);
            }
            if (adapter == IArtifactKey[].class && this.artifacts != null) {
                return adapter.cast(this.artifacts.toArray(IArtifactKey[]::new));
            }
            return null;
        }
    }

    static final class MessageDialogWithLink
    extends MessageDialog {
        private final String linkText;
        private final Consumer<String> linkOpener;

        MessageDialogWithLink(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, String linkText, Consumer<String> linkOpener) {
            super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
            this.linkText = linkText;
            this.linkOpener = linkOpener;
        }

        protected Control createCustomArea(Composite parent) {
            if (this.linkText == null) {
                return super.createCustomArea(parent);
            }
            Link link = new Link(parent, 0);
            link.setText(this.linkText);
            link.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.linkOpener.accept(e.text)));
            return link;
        }
    }

    static class OkCancelErrorDialog
    extends ErrorDialog {
        public OkCancelErrorDialog(Shell parentShell, String dialogTitle, String message, IStatus status, int displayMask) {
            super(parentShell, dialogTitle, message, status, displayMask);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, ProvUIMessages.ServiceUI_InstallAnywayAction_Label, true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
            this.createDetailsButton(parent);
        }
    }
}

