/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.repository;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.artifact.repository.Activator;
import org.eclipse.equinox.internal.p2.artifact.repository.ArtifactRequest;
import org.eclipse.equinox.internal.p2.artifact.repository.Messages;
import org.eclipse.equinox.internal.p2.artifact.repository.MirrorEvent;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactDescriptor;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStepHandler;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.repository.IStateful;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.osgi.util.NLS;

public class MirrorRequest
extends ArtifactRequest {
    public static final int ARTIFACT_PROCESSING_ERROR = 2;
    public static final boolean DOWNLOAD_STATS_ENABLED = !"false".equals(Activator.getContext().getProperty("eclipse.p2.reportDownloadStatistics"));
    private static final int MAX_RETRY_REQUEST = 200;
    private static final String PROP_STATS_URI = "p2.statsURI";
    private static final String PROP_DOWNLOAD_STATS = "download.stats";
    private String downloadStatsParamters;
    protected final IArtifactRepository target;
    private final Map<String, String> targetDescriptorProperties;
    private final Map<String, String> targetRepositoryProperties;
    protected IArtifactDescriptor descriptor;

    public MirrorRequest(IArtifactKey key, IArtifactRepository targetRepository, Map<String, String> targetDescriptorProperties, Map<String, String> targetRepositoryProperties, Transport transport) {
        this(key, targetRepository, targetDescriptorProperties, targetRepositoryProperties, transport, null);
    }

    public MirrorRequest(IArtifactKey key, IArtifactRepository targetRepository, Map<String, String> targetDescriptorProperties, Map<String, String> targetRepositoryProperties, Transport transport, String statsParameters) {
        super(key, transport);
        this.target = targetRepository;
        if (targetDescriptorProperties == null || targetDescriptorProperties.isEmpty()) {
            this.targetDescriptorProperties = null;
        } else {
            this.targetDescriptorProperties = new HashMap<String, String>();
            this.targetDescriptorProperties.putAll(targetDescriptorProperties);
        }
        if (targetRepositoryProperties == null || targetRepositoryProperties.isEmpty()) {
            this.targetRepositoryProperties = null;
        } else {
            this.targetRepositoryProperties = new HashMap<String, String>();
            this.targetRepositoryProperties.putAll(targetRepositoryProperties);
        }
        this.downloadStatsParamters = statsParameters;
    }

    @Override
    protected void setSourceRepository(IArtifactRepository value) {
        if (value != this.getSourceRepository()) {
            this.descriptor = null;
        }
        super.setSourceRepository(value);
    }

    @Override
    public void perform(IArtifactRepository sourceRepository, IProgressMonitor monitor) {
        IArtifactDescriptor[] descriptors;
        monitor.subTask(NLS.bind((String)Messages.downloading, (Object)this.getArtifactKey().getId()));
        this.setSourceRepository(sourceRepository);
        if (this.target.contains(this.getArtifactKey())) {
            this.setResult((IStatus)new Status(0, "org.eclipse.equinox.p2.artifact.repository", NLS.bind((String)Messages.available_already_in, (Object)this.getArtifactKey())));
            return;
        }
        IArtifactDescriptor optimized = null;
        IArtifactDescriptor canonical = null;
        if (this.descriptor == null && (descriptors = this.source.getArtifactDescriptors(this.getArtifactKey())).length > 0) {
            IArtifactDescriptor[] iArtifactDescriptorArray = descriptors;
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                IArtifactDescriptor descriptor2 = iArtifactDescriptorArray[n2];
                if (descriptor2.getProperty("format") == null) {
                    canonical = descriptor2;
                } else if (ProcessingStepHandler.canProcess(descriptor2)) {
                    optimized = descriptor2;
                }
                ++n2;
            }
            boolean chooseCanonical = this.source.getLocation().getScheme().equals("file");
            IArtifactDescriptor iArtifactDescriptor = this.descriptor = chooseCanonical ? canonical : optimized;
            if (this.descriptor == null) {
                IArtifactDescriptor iArtifactDescriptor2 = this.descriptor = !chooseCanonical ? canonical : optimized;
            }
        }
        if (this.descriptor == null) {
            this.setResult((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", NLS.bind((String)Messages.artifact_not_found, (Object)this.getArtifactKey())));
            return;
        }
        IArtifactDescriptor destinationDescriptor = this.getDestinationDescriptor(this.descriptor, this.descriptor == canonical);
        IStatus status = this.transfer(destinationDescriptor, this.descriptor, monitor);
        if (status.getSeverity() == 8) {
            this.setResult(status);
            return;
        }
        if (monitor.isCanceled()) {
            this.setResult(Status.CANCEL_STATUS);
            return;
        }
        if (status.isOK()) {
            this.setResult(status);
            return;
        }
        if (this.target.contains(destinationDescriptor)) {
            this.target.removeDescriptor(destinationDescriptor);
        }
        if (this.descriptor == canonical || canonical == null) {
            this.setResult(status);
            return;
        }
        IStatus canonicalStatus = this.transfer(this.getDestinationDescriptor(canonical, true), canonical, monitor);
        if (canonicalStatus.getSeverity() < status.getSeverity()) {
            this.setResult(canonicalStatus);
        } else {
            this.setResult((IStatus)new MultiStatus("org.eclipse.equinox.p2.artifact.repository", canonicalStatus.getCode() != 0 ? canonicalStatus.getCode() : status.getCode(), new IStatus[]{status, canonicalStatus}, Messages.MirrorRequest_multipleDownloadProblems, null));
        }
    }

    private IArtifactDescriptor getDestinationDescriptor(IArtifactDescriptor sourceDescriptor, boolean isCanonical) {
        IArtifactDescriptor destinationDescriptor = this.target.createArtifactDescriptor(sourceDescriptor.getArtifactKey());
        if (this.targetDescriptorProperties != null && destinationDescriptor instanceof ArtifactDescriptor) {
            ((ArtifactDescriptor)destinationDescriptor).addProperties(this.targetDescriptorProperties);
        }
        if (this.targetRepositoryProperties != null && destinationDescriptor instanceof SimpleArtifactDescriptor) {
            ((SimpleArtifactDescriptor)destinationDescriptor).addRepositoryProperties(this.targetRepositoryProperties);
        }
        return destinationDescriptor;
    }

    protected IStatus transfer(IArtifactDescriptor destinationDescriptor, IArtifactDescriptor sourceDescriptor, IProgressMonitor monitor) {
        MultiStatus allResults = new MultiStatus("org.eclipse.equinox.p2.artifact.repository", 0, NLS.bind((String)Messages.MirrorRequest_transferFailed, (Object)sourceDescriptor), null);
        IStatus lastResult = Status.OK_STATUS;
        int counter = 0;
        do {
            lastResult = this.transferSingle(destinationDescriptor, sourceDescriptor, monitor);
            allResults.add(lastResult);
            if (!(lastResult.getException() instanceof Error)) continue;
            throw (Error)lastResult.getException();
        } while (lastResult.getSeverity() == 4 && lastResult.getCode() == 13 && counter++ < 200);
        IProvisioningEventBus bus = (IProvisioningEventBus)this.source.getProvisioningAgent().getService(IProvisioningEventBus.class);
        if (bus != null) {
            bus.publishEvent((EventObject)new MirrorEvent(this.source, sourceDescriptor, (IStatus)(lastResult.isOK() ? lastResult : (allResults.getChildren().length <= 1 ? lastResult : allResults))));
        }
        if (lastResult.isOK()) {
            this.collectStats(sourceDescriptor, monitor);
            return lastResult;
        }
        if (allResults.getChildren().length <= 1) {
            return lastResult;
        }
        return allResults;
    }

    private void collectStats(IArtifactDescriptor sourceDescriptor, IProgressMonitor monitor) {
        URI statsURI;
        if (!DOWNLOAD_STATS_ENABLED) {
            return;
        }
        String statsProperty = sourceDescriptor.getProperty(PROP_DOWNLOAD_STATS);
        if (statsProperty == null) {
            return;
        }
        String statsRoot = (String)sourceDescriptor.getRepository().getProperties().get(PROP_STATS_URI);
        if (statsRoot == null) {
            return;
        }
        try {
            statsURI = URIUtil.append((URI)new URI(statsRoot), (String)statsProperty);
            if (this.downloadStatsParamters != null) {
                try {
                    statsURI = new URI(statsURI.getScheme(), statsURI.getUserInfo(), statsURI.getHost(), statsURI.getPort(), statsURI.getPath(), (String)(statsURI.getQuery() == null ? this.downloadStatsParamters : this.downloadStatsParamters + "&" + statsURI.getQuery()), statsURI.getFragment());
                }
                catch (URISyntaxException uRISyntaxException) {
                    LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.artifact.repository", "Unable to create download statistics due to invalid URL query: " + statsRoot + " suffix: " + statsProperty + " query: " + this.downloadStatsParamters));
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.artifact.repository", "Unable to report download statistics due to invalid URL: " + statsRoot + " suffix: " + statsProperty));
            return;
        }
        try {
            this.transport.getLastModified(statsURI, monitor);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception e) {
            LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.artifact.repository", "Failure reporting download statistics to URL: " + String.valueOf(statsURI), (Throwable)e));
        }
    }

    private IStatus transferSingle(IArtifactDescriptor destinationDescriptor, IArtifactDescriptor sourceDescriptor, IProgressMonitor monitor) {
        IStatus status;
        block16: {
            OutputStream destination;
            try {
                destination = this.target.getOutputStream(destinationDescriptor);
            }
            catch (ProvisionException e) {
                return e.getStatus();
            }
            status = null;
            Throwable priorException = null;
            try {
                try {
                    status = this.getArtifact(sourceDescriptor, destination, monitor);
                    if (destination instanceof IStateful && status != null && !status.isOK()) {
                        IStatus destStatus = ((IStateful)destination).getStatus();
                        IStatus root = MirrorRequest.extractRootCause(status);
                        Throwable e = root != null ? root.getException() : null;
                        ((IStateful)destination).setStatus((IStatus)new MultiStatus("org.eclipse.equinox.p2.artifact.repository", status.getCode(), new IStatus[]{status, destStatus}, status.getMessage(), e));
                    }
                }
                catch (RuntimeException e) {
                    priorException = e;
                    throw e;
                }
                catch (Error e) {
                    priorException = e;
                    throw e;
                }
            }
            catch (Throwable throwable) {
                block15: {
                    try {
                        destination.close();
                    }
                    catch (IOException e) {
                        if (priorException != null) break block15;
                        if (status != null && status.getSeverity() == 4 && status.getCode() == 13) {
                            return new MultiStatus("org.eclipse.equinox.p2.artifact.repository", status.getCode(), new IStatus[]{status}, NLS.bind((String)Messages.error_closing_stream, (Object)this.getArtifactKey(), (Object)this.target.getLocation()), (Throwable)e);
                        }
                        return new Status(4, "org.eclipse.equinox.p2.artifact.repository", NLS.bind((String)Messages.error_closing_stream, (Object)this.getArtifactKey(), (Object)this.target.getLocation()), (Throwable)e);
                    }
                }
                throw throwable;
            }
            try {
                destination.close();
            }
            catch (IOException e) {
                if (priorException != null) break block16;
                if (status != null && status.getSeverity() == 4 && status.getCode() == 13) {
                    return new MultiStatus("org.eclipse.equinox.p2.artifact.repository", status.getCode(), new IStatus[]{status}, NLS.bind((String)Messages.error_closing_stream, (Object)this.getArtifactKey(), (Object)this.target.getLocation()), (Throwable)e);
                }
                return new Status(4, "org.eclipse.equinox.p2.artifact.repository", NLS.bind((String)Messages.error_closing_stream, (Object)this.getArtifactKey(), (Object)this.target.getLocation()), (Throwable)e);
            }
        }
        return status;
    }

    protected IStatus getArtifact(IArtifactDescriptor sourceDescriptor, OutputStream destination, IProgressMonitor monitor) {
        return this.getSourceRepository().getArtifact(sourceDescriptor, destination, monitor);
    }

    private static IStatus extractRootCause(IStatus status) {
        if (status == null) {
            return null;
        }
        if (!status.isMultiStatus()) {
            return MirrorRequest.constraintStatus(status);
        }
        IStatus[] children = ((MultiStatus)status).getChildren();
        if (children == null) {
            return MirrorRequest.constraintStatus(status);
        }
        IStatus[] iStatusArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus element = iStatusArray[n2];
            IStatus deeper = MirrorRequest.extractRootCause(element);
            if (deeper != null) {
                return deeper;
            }
            ++n2;
        }
        return MirrorRequest.constraintStatus(status);
    }

    private static IStatus constraintStatus(IStatus status) {
        return status.getSeverity() == 4 && status.getException() != null ? status : null;
    }

    public String toString() {
        return Messages.mirroring + String.valueOf(this.getArtifactKey()) + " into " + String.valueOf(this.target);
    }
}

