/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ResourceWorkingSetFilter;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.WorkingSetFilterActionGroup;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.SearchPattern;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.model.ResourceFactory;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class FilteredResourcesSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog";
    private static final String WORKINGS_SET_SETTINGS = "WorkingSet";
    private static final String SHOW_DERIVED = "ShowDerived";
    private static final String FILTER_BY_LOCATION = "FilterByLocation";
    private static final char START_SYMBOL = '>';
    private static final char END_SYMBOL = '<';
    private static final char BLANK = ' ';
    private static final boolean autoInfixSearch = true;
    private ShowDerivedResourcesAction showDerivedResourcesAction;
    private ResourceItemLabelProvider resourceItemLabelProvider;
    private ResourceItemDetailsLabelProvider resourceItemDetailsLabelProvider;
    private WorkingSetFilterActionGroup workingSetFilterActionGroup;
    private CustomWorkingSetFilter workingSetFilter = new CustomWorkingSetFilter();
    private FilterResourcesByLocation filterResourceByLocation = new FilterResourcesByLocation();
    private GroupResourcesByLocationAction groupResourcesByLocationAction;
    private String title;
    private FilteredItemsSelectionDialog.ItemsFilter latestFilter;
    private IContainer container;
    private IContainer searchContainer;
    private int typeMask;
    private boolean isDerived;
    private final Map<String, CollationKey> collationKeyCache = new ConcurrentHashMap<String, CollationKey>();
    private final Comparator<String> collator = new Comparator<String>(){
        Collator c = Collator.getInstance();

        @Override
        public int compare(String s1, String s2) {
            CollationKey ck1 = FilteredResourcesSelectionDialog.this.collationKeyCache.computeIfAbsent(s1, this.c::getCollationKey);
            CollationKey ck2 = FilteredResourcesSelectionDialog.this.collationKeyCache.computeIfAbsent(s2, this.c::getCollationKey);
            return ck1.compareTo(ck2);
        }
    };

    private int getDefaultMatchRules() {
        return 675;
    }

    public FilteredResourcesSelectionDialog(Shell shell, boolean multi, IContainer container, int typesMask) {
        super(shell, multi);
        IWorkbenchPage activePage;
        this.setSelectionHistory(new ResourceSelectionHistory());
        this.setTitle(IDEWorkbenchMessages.OpenResourceDialog_title);
        this.setMessage(IDEWorkbenchMessages.OpenResourceDialog_message);
        IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (ww != null && (activePage = ww.getActivePage()) != null) {
            IResource resource = null;
            IEditorPart activeEditor = activePage.getActiveEditor();
            if (activeEditor != null && activeEditor == activePage.getActivePart()) {
                IEditorInput editorInput = activeEditor.getEditorInput();
                resource = ResourceUtil.getResource(editorInput);
            } else {
                IStructuredSelection structuredSelection;
                ISelection selection = ww.getSelectionService().getSelection();
                if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1) {
                    resource = ResourceUtil.getResource(structuredSelection.getFirstElement());
                }
            }
            if (resource != null) {
                if (!(resource instanceof IContainer)) {
                    resource = resource.getParent();
                }
                this.searchContainer = (IContainer)resource;
            }
        }
        this.container = container;
        this.typeMask = typesMask;
        this.resourceItemLabelProvider = new ResourceItemLabelProvider();
        this.resourceItemDetailsLabelProvider = new ResourceItemDetailsLabelProvider();
        this.setListLabelProvider((ILabelProvider)this.resourceItemLabelProvider);
        this.setDetailsLabelProvider((ILabelProvider)this.resourceItemDetailsLabelProvider);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.ide.open_resource_dialog");
    }

    public void setTitle(String title) {
        super.setTitle(title);
        this.title = title;
    }

    private void setSubtitle(String text) {
        if (text == null || text.isEmpty()) {
            this.getShell().setText(this.title);
        } else {
            this.getShell().setText(this.title + " - " + text);
        }
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings dialogSettings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(FilteredResourcesSelectionDialog.class)).getDialogSettings();
        IDialogSettings settings = dialogSettings.getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = dialogSettings.addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    protected void storeDialog(IDialogSettings settings) {
        super.storeDialog(settings);
        settings.put(SHOW_DERIVED, this.showDerivedResourcesAction.isChecked());
        settings.put(FILTER_BY_LOCATION, this.groupResourcesByLocationAction.isChecked());
        XMLMemento memento = XMLMemento.createWriteRoot((String)"workingSet");
        this.workingSetFilterActionGroup.saveState((IMemento)memento);
        this.workingSetFilterActionGroup.dispose();
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
            settings.put(WORKINGS_SET_SETTINGS, writer.getBuffer().toString());
        }
        catch (IOException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 4, "", (Throwable)e));
        }
    }

    protected void restoreDialog(IDialogSettings settings) {
        super.restoreDialog(settings);
        boolean showDerived = settings.getBoolean(SHOW_DERIVED);
        this.showDerivedResourcesAction.setChecked(showDerived);
        this.isDerived = showDerived;
        boolean groupByLoation = settings.getBoolean(FILTER_BY_LOCATION);
        this.groupResourcesByLocationAction.setChecked(groupByLoation);
        this.filterResourceByLocation.setEnabled(groupByLoation);
        this.addListFilter(this.filterResourceByLocation);
        String setting = settings.get(WORKINGS_SET_SETTINGS);
        if (setting != null) {
            try {
                XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(setting));
                this.workingSetFilterActionGroup.restoreState((IMemento)memento);
            }
            catch (WorkbenchException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 4, "", (Throwable)e));
            }
        }
        this.addListFilter(this.workingSetFilter);
        this.applyFilter();
    }

    protected void fillViewMenu(IMenuManager menuManager) {
        super.fillViewMenu(menuManager);
        this.showDerivedResourcesAction = new ShowDerivedResourcesAction();
        menuManager.add((IAction)this.showDerivedResourcesAction);
        this.groupResourcesByLocationAction = new GroupResourcesByLocationAction();
        menuManager.add((IAction)this.groupResourcesByLocationAction);
        this.workingSetFilterActionGroup = new WorkingSetFilterActionGroup(this.getShell(), event -> {
            String property = event.getProperty();
            if ("changeWorkingSet".equals(property)) {
                IWorkingSet workingSet = (IWorkingSet)event.getNewValue();
                if (!(workingSet == null || workingSet.isAggregateWorkingSet() && workingSet.isEmpty())) {
                    this.workingSetFilter.setWorkingSet(workingSet);
                    this.setSubtitle(workingSet.getLabel());
                } else {
                    IWorkbenchPage page;
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window != null && (workingSet = (page = window.getActivePage()).getAggregateWorkingSet()).isAggregateWorkingSet() && workingSet.isEmpty()) {
                        workingSet = null;
                    }
                    this.workingSetFilter.setWorkingSet(workingSet);
                    this.setSubtitle(null);
                }
                this.scheduleRefresh();
            }
        });
        menuManager.add((IContributionItem)new Separator());
        this.workingSetFilterActionGroup.fillContextMenu(menuManager);
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    public Object[] getResult() {
        Object[] result = super.getResult();
        if (result == null) {
            return null;
        }
        ArrayList<Object> resultToReturn = new ArrayList<Object>();
        Object[] objectArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IResource) {
                resultToReturn.add(element);
            }
            ++n2;
        }
        return resultToReturn.toArray();
    }

    public int open() {
        IWorkspace workspace;
        IStatus result;
        String text;
        ISelection selection;
        IWorkbenchWindow window;
        if (this.getInitialPattern() == null && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (selection = window.getSelectionService().getSelection()) instanceof ITextSelection && (text = ((ITextSelection)selection).getText()) != null && (text = text.trim()).length() > 0 && (result = (workspace = ResourcesPlugin.getWorkspace()).validateName(text, 1)).isOK()) {
            this.setInitialPattern(text);
        }
        return super.open();
    }

    public boolean close() {
        this.collationKeyCache.clear();
        return super.close();
    }

    public String getElementName(Object item) {
        IResource resource = (IResource)item;
        return resource.getName();
    }

    protected IStatus validateItem(Object item) {
        return new Status(0, WorkbenchPlugin.PI_WORKBENCH, 0, "", null);
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        this.latestFilter = new ResourceFilter(this.container, this.searchContainer, this.isDerived, this.typeMask);
        return this.latestFilter;
    }

    protected void applyFilter() {
        super.applyFilter();
    }

    protected Comparator<IResource> getItemsComparator() {
        String pattern = this.latestFilter != null ? this.latestFilter.getPattern() : null;
        return (resource1, resource2) -> {
            int comparability;
            String n2;
            String s1 = resource1.getName();
            String s2 = resource2.getName();
            int s1Dot = s1.lastIndexOf(46);
            int s2Dot = s2.lastIndexOf(46);
            String n1 = s1Dot == -1 ? s1 : s1.substring(0, s1Dot);
            String string2 = n2 = s2Dot == -1 ? s2 : s2.substring(0, s2Dot);
            if (pattern != null) {
                char patternFirstChar;
                int patternDot = pattern.lastIndexOf(46);
                String patternNoExtension = patternDot == -1 ? pattern : pattern.substring(0, patternDot);
                boolean m1 = patternNoExtension.equals(n1);
                boolean m2 = patternNoExtension.equals(n2);
                if (!m1 || !m2) {
                    if (m1) {
                        return -1;
                    }
                    if (m2) {
                        return 1;
                    }
                }
                if ((patternFirstChar = this.getFirstFileNameChar(pattern)) != '\u0000') {
                    m1 = (patternFirstChar = Character.toLowerCase(patternFirstChar)) == Character.toLowerCase(s1.charAt(0));
                    boolean bl = m2 = patternFirstChar == Character.toLowerCase(s2.charAt(0));
                    if (!m1 || !m2) {
                        if (m1) {
                            return -1;
                        }
                        if (m2) {
                            return 1;
                        }
                    }
                }
            }
            if ((comparability = this.collator.compare(n1, n2)) != 0) {
                return comparability;
            }
            if ((s1Dot != -1 || s2Dot != -1) && (comparability = this.collator.compare(s1, s2)) != 0) {
                return comparability;
            }
            if (this.searchContainer != null) {
                IContainer c11 = resource1.getParent();
                IContainer c21 = resource2.getParent();
                comparability = this.pathDistance(c11) - this.pathDistance(c21);
                if (comparability != 0) {
                    return comparability;
                }
            }
            IPath p1 = resource1.getFullPath();
            IPath p2 = resource2.getFullPath();
            int c12 = p1.segmentCount() - 1;
            int c22 = p2.segmentCount() - 1;
            int i = 0;
            while (i < c12 && i < c22) {
                comparability = this.collator.compare(p1.segment(i), p2.segment(i));
                if (comparability != 0) {
                    return comparability;
                }
                ++i;
            }
            comparability = c12 - c22;
            return comparability;
        };
    }

    private char getFirstFileNameChar(String pattern) {
        int i = 0;
        while (i < pattern.length()) {
            char ch = pattern.charAt(i);
            if (ch != '*') {
                return ch;
            }
            ++i;
        }
        return '\u0000';
    }

    private int pathDistance(IContainer item) {
        IPath containerPath = this.searchContainer.getFullPath();
        IPath itemPath = item.getFullPath();
        if (itemPath.equals((Object)containerPath)) {
            return 0;
        }
        int matching = containerPath.matchingFirstSegments(itemPath);
        if (matching == 0) {
            return 0x3FFFFFFF;
        }
        int containerSegmentCount = containerPath.segmentCount();
        if (matching == containerSegmentCount) {
            return itemPath.segmentCount() - matching;
        }
        return 0x1FFFFFFF + containerSegmentCount - matching;
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        if (itemsFilter instanceof ResourceFilter) {
            IResource[] members = this.container.members();
            progressMonitor.beginTask(WorkbenchMessages.FilteredItemsSelectionDialog_searchJob_taskName, members.length);
            ResourceProxyVisitor visitor = new ResourceProxyVisitor(contentProvider, (ResourceFilter)itemsFilter, progressMonitor);
            if (visitor.visit(this.container.createProxy())) {
                IResource[] iResourceArray = members;
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    if (member.isAccessible()) {
                        member.accept((IResourceProxyVisitor)visitor, 0);
                    }
                    progressMonitor.worked(1);
                    if (progressMonitor.isCanceled()) break;
                    ++n2;
                }
            }
        }
        progressMonitor.done();
    }

    private boolean parentIsRoot(IResource resource) {
        if (resource.getParent() == null) {
            return false;
        }
        return resource.getParent().getType() == 8;
    }

    private static boolean isMatchPrefix(String pattern) {
        if (pattern.length() == 0) {
            return false;
        }
        char first = pattern.charAt(0);
        return pattern.length() > 1 && first == '>';
    }

    private static boolean isMatchSuffix(String pattern) {
        if (pattern.length() <= 1) {
            return false;
        }
        char last = pattern.charAt(pattern.length() - 1);
        boolean matchPrefix = FilteredResourcesSelectionDialog.isMatchPrefix(pattern);
        return pattern.length() > (matchPrefix ? 2 : 1) && (last == '<' || last == ' ');
    }

    private static class CustomWorkingSetFilter
    extends ViewerFilter {
        private ResourceWorkingSetFilter resourceWorkingSetFilter = new ResourceWorkingSetFilter();

        private CustomWorkingSetFilter() {
        }

        public void setWorkingSet(IWorkingSet workingSet) {
            this.resourceWorkingSetFilter.setWorkingSet(workingSet);
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return this.resourceWorkingSetFilter.select(viewer, parentElement, element);
        }
    }

    private class FilterResourcesByLocation
    extends ViewerFilter {
        private boolean enabled;

        private FilterResourcesByLocation() {
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
            if (!this.enabled) {
                return elements;
            }
            LinkedHashMap<IPath, IResource> bestResourceForPath = new LinkedHashMap<IPath, IResource>();
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IResource currentResource;
                IResource otherResource;
                Object item = objectArray[n2];
                if (item instanceof IResource && ((otherResource = (IResource)bestResourceForPath.get((currentResource = (IResource)item).getLocation())) == null || otherResource.getFullPath().segmentCount() > currentResource.getFullPath().segmentCount())) {
                    bestResourceForPath.put(currentResource.getLocation(), currentResource);
                }
                ++n2;
            }
            return bestResourceForPath.values().toArray(new IResource[bestResourceForPath.size()]);
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return true;
        }
    }

    private class GroupResourcesByLocationAction
    extends Action {
        public GroupResourcesByLocationAction() {
            super(IDEWorkbenchMessages.FilteredResourcesSelectionDialog_groupResourcesWithSameUndelyingLocation, 2);
        }

        public void run() {
            FilteredResourcesSelectionDialog.this.filterResourceByLocation.setEnabled(this.isChecked());
            FilteredResourcesSelectionDialog.this.scheduleRefresh();
            FilteredResourcesSelectionDialog.this.applyFilter();
        }
    }

    protected class ResourceFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private boolean showDerived;
        private IContainer filterContainer;
        private SearchPattern containerPattern;
        private SearchPattern relativeContainerPattern;
        SearchPattern namePattern;
        SearchPattern extensionPattern;
        private int filterTypeMask;

        public ResourceFilter(IContainer container, boolean showDerived, int typeMask) {
            super((FilteredItemsSelectionDialog)FilteredResourcesSelectionDialog.this, new SearchPattern(FilteredResourcesSelectionDialog.this.getDefaultMatchRules()));
            this.showDerived = false;
            this.filterContainer = container;
            this.showDerived = showDerived;
            this.filterTypeMask = typeMask;
        }

        private ResourceFilter(IContainer container, IContainer searchContainer, boolean showDerived, int typeMask) {
            this(container, showDerived, typeMask);
            Object filenamePattern;
            String stringPattern = this.patternMatcher.getInitialPattern();
            int sep = stringPattern.lastIndexOf(47);
            if (sep != -1) {
                filenamePattern = stringPattern.substring(sep + 1, stringPattern.length());
                if (sep > 0) {
                    if (((String)filenamePattern).isEmpty()) {
                        filenamePattern = "**";
                    }
                    Object containerPattern = stringPattern.substring(FilteredResourcesSelectionDialog.isMatchPrefix(stringPattern) ? 1 : 0, sep);
                    if (searchContainer != null) {
                        this.relativeContainerPattern = new SearchPattern(2);
                        this.relativeContainerPattern.setPattern(searchContainer.getFullPath().append((String)containerPattern).toString());
                    }
                    if (!((String)containerPattern).startsWith(Character.toString('*'))) {
                        if (!((String)containerPattern).startsWith(Character.toString('/'))) {
                            containerPattern = "/" + (String)containerPattern;
                        }
                        containerPattern = "*" + (String)containerPattern;
                    }
                    this.containerPattern = new SearchPattern(3);
                    this.containerPattern.setPattern((String)containerPattern);
                }
                if (FilteredResourcesSelectionDialog.isMatchPrefix(stringPattern)) {
                    filenamePattern = ">" + (String)filenamePattern;
                }
                this.patternMatcher.setPattern((String)filenamePattern);
            } else {
                filenamePattern = stringPattern;
            }
            int lastPatternDot = ((String)filenamePattern).lastIndexOf(46);
            if (lastPatternDot != -1) {
                this.namePattern = new SearchPattern(filteredResourcesSelectionDialog.getDefaultMatchRules());
                Object namePatternStr = ((String)filenamePattern).substring(0, lastPatternDot);
                if (FilteredResourcesSelectionDialog.isMatchSuffix(stringPattern) && !((String)namePatternStr).endsWith("*")) {
                    namePatternStr = (String)namePatternStr + "<";
                }
                this.namePattern.setPattern((String)namePatternStr);
                this.extensionPattern = new SearchPattern();
                this.extensionPattern.setPattern(((String)filenamePattern).substring(lastPatternDot + 1));
            }
        }

        public ResourceFilter() {
            this(filteredResourcesSelectionDialog.container, filteredResourcesSelectionDialog.searchContainer, filteredResourcesSelectionDialog.isDerived, filteredResourcesSelectionDialog.typeMask);
        }

        public boolean isConsistentItem(Object item) {
            if (!(item instanceof IResource)) {
                return false;
            }
            IResource resource = (IResource)item;
            return this.filterContainer.findMember(resource.getFullPath()) != null;
        }

        public boolean matchItem(Object item) {
            if (!(item instanceof IResource)) {
                return false;
            }
            IResource resource = (IResource)item;
            return (this.filterTypeMask & resource.getType()) != 0 && this.matchName(resource) && (this.showDerived || !resource.isDerived());
        }

        private boolean matchName(IResource resource) {
            String name = resource.getName();
            if (this.nameMatches(name)) {
                if (this.containerPattern != null) {
                    String containerPath = resource.getParent().getFullPath().toString();
                    if (this.containerPattern.matches(containerPath)) {
                        return true;
                    }
                    if (this.relativeContainerPattern != null) {
                        return this.relativeContainerPattern.matches(containerPath);
                    }
                    return false;
                }
                return true;
            }
            return false;
        }

        private boolean nameMatches(String name) {
            int lastDot;
            if (this.namePattern != null && (lastDot = name.lastIndexOf(46)) != -1 && this.namePattern.matches(name.substring(0, lastDot)) && this.extensionPattern.matches(name.substring(lastDot + 1))) {
                return true;
            }
            return this.matches(name);
        }

        public boolean isSubFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            if (!super.isSubFilter(filter)) {
                return false;
            }
            if (filter instanceof ResourceFilter) {
                ResourceFilter resourceFilter = (ResourceFilter)filter;
                if (this.showDerived == resourceFilter.showDerived) {
                    if (this.containerPattern == null) {
                        return resourceFilter.containerPattern == null;
                    }
                    if (resourceFilter.containerPattern == null) {
                        return false;
                    }
                    return this.containerPattern.equals(resourceFilter.containerPattern);
                }
            }
            return false;
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter iFilter) {
            if (!super.equalsFilter(iFilter)) {
                return false;
            }
            if (iFilter instanceof ResourceFilter) {
                ResourceFilter resourceFilter = (ResourceFilter)iFilter;
                if (this.showDerived == resourceFilter.showDerived) {
                    if (this.containerPattern == null) {
                        return resourceFilter.containerPattern == null;
                    }
                    if (resourceFilter.containerPattern == null) {
                        return false;
                    }
                    return this.containerPattern.equals(resourceFilter.containerPattern);
                }
            }
            return false;
        }

        public boolean isShowDerived() {
            return this.showDerived;
        }
    }

    private class ResourceItemDetailsLabelProvider
    extends ResourceItemLabelProvider {
        private ResourceItemDetailsLabelProvider() {
        }

        @Override
        public Image getImage(Object element) {
            if (!(element instanceof IResource)) {
                return super.getImage(element);
            }
            IResource resource = (IResource)element;
            if (FilteredResourcesSelectionDialog.this.parentIsRoot(resource)) {
                return this.provider.getImage((Object)resource);
            }
            return this.provider.getImage((Object)resource.getParent());
        }

        @Override
        public String getText(Object element) {
            if (!(element instanceof IResource)) {
                return super.getText(element);
            }
            IContainer parent = ((IResource)element).getParent();
            if (parent.getType() == 8) {
                return ((IResource)element).getName();
            }
            return parent.getFullPath().makeRelative().toString();
        }

        @Override
        public void labelProviderChanged(LabelProviderChangedEvent event) {
            Object[] l = this.listeners.getListeners();
            int i = 0;
            while (i < this.listeners.size()) {
                ((ILabelProviderListener)l[i]).labelProviderChanged(event);
                ++i;
            }
        }
    }

    private class ResourceItemLabelProvider
    extends LabelProvider
    implements ILabelProviderListener,
    DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private ListenerList<ILabelProviderListener> listeners = new ListenerList();
        ILabelProvider provider = WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider();

        public ResourceItemLabelProvider() {
            this.provider.addListener((ILabelProviderListener)this);
        }

        public Image getImage(Object element) {
            if (!(element instanceof IResource)) {
                return super.getImage(element);
            }
            IResource res = (IResource)element;
            return this.provider.getImage((Object)res);
        }

        public String getText(Object element) {
            if (!(element instanceof IResource)) {
                return super.getText(element);
            }
            IResource res = (IResource)element;
            StringBuilder str = new StringBuilder(res.getName());
            if (!FilteredResourcesSelectionDialog.this.parentIsRoot(res)) {
                str.append(" - ");
                str.append(res.getParent().getFullPath().makeRelative().toString());
            }
            return str.toString();
        }

        public StyledString getStyledText(Object element) {
            if (!(element instanceof IResource)) {
                return new StyledString(super.getText(element));
            }
            IResource resource = (IResource)element;
            String searchFieldString = ((Text)FilteredResourcesSelectionDialog.this.getPatternControl()).getText();
            int fileNameIndex = searchFieldString.lastIndexOf(47);
            if (fileNameIndex != -1 && fileNameIndex != searchFieldString.length() - 1) {
                searchFieldString = searchFieldString.substring(fileNameIndex + 1);
            }
            String resourceName = resource.getName();
            StyledString.Styler boldStyler = new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    textStyle.font = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
                }
            };
            StyledString str = this.styleResourceExtensionMatch(resource, searchFieldString, boldStyler);
            if (str.getStyleRanges().length > 0) {
                resourceName = resourceName.substring(0, resourceName.lastIndexOf(46));
                searchFieldString = searchFieldString.substring(0, searchFieldString.lastIndexOf(46));
            }
            this.getMatchPositions(resourceName, searchFieldString).stream().forEach(position -> str.setStyle(position.offset, position.length, boldStyler));
            if (!FilteredResourcesSelectionDialog.this.parentIsRoot(resource)) {
                str.append(" - ", StyledString.QUALIFIER_STYLER);
                str.append(resource.getParent().getFullPath().makeRelative().toString(), StyledString.QUALIFIER_STYLER);
            }
            return str;
        }

        private StyledString styleResourceExtensionMatch(IResource resource, String matchingString, StyledString.Styler styler) {
            StyledString str = new StyledString(resource.getName());
            Object resourceExtension = resource.getFileExtension();
            if (resourceExtension == null) {
                return str;
            }
            int matchingExtensionIndex = matchingString.lastIndexOf(46);
            if (matchingExtensionIndex == -1) {
                return str;
            }
            resourceExtension = "." + (String)resourceExtension;
            int resourceExtensionIndex = resource.getName().length() - ((String)resourceExtension).length();
            String matchingExtension = matchingString.substring(matchingExtensionIndex, matchingString.length());
            for (Position markPosition : this.getMatchPositions((String)resourceExtension, matchingExtension)) {
                str.setStyle(resourceExtensionIndex + markPosition.offset, markPosition.length, styler);
            }
            return str;
        }

        private List<Position> getMatchPositions(String string, String matching) {
            int matchingIndex;
            String[] regions;
            char lastChar;
            ArrayList<Position> positions = new ArrayList<Position>();
            if (matching.isEmpty() || string.isEmpty()) {
                return positions;
            }
            if (matching.charAt(0) == '>') {
                matching = matching.substring(1);
            }
            if ((lastChar = matching.charAt(matching.length() - 1)) == ' ' || lastChar == '<') {
                matching = matching.substring(0, matching.length() - 1);
            }
            if (matching.indexOf(63) == -1 && matching.indexOf(42) == -1) {
                regions = matching.split("(?=[A-Z0-9])");
            } else {
                regions = matching.toLowerCase().split("[?*]");
                string = string.toLowerCase();
            }
            int currentIndex = 0;
            boolean regionsDontMatch = false;
            String[] stringArray = regions;
            int n = regions.length;
            int n2 = 0;
            while (n2 < n) {
                String region = stringArray[n2];
                if (!region.isEmpty()) {
                    int startlocation = string.substring(currentIndex).indexOf(region);
                    if (startlocation == -1) {
                        regionsDontMatch = true;
                        break;
                    }
                    positions.add(new Position(currentIndex += startlocation, region.length()));
                    currentIndex += region.length();
                }
                ++n2;
            }
            if (regionsDontMatch && (matchingIndex = string.toLowerCase().indexOf(matching.toLowerCase())) > -1) {
                positions.add(new Position(matchingIndex, matching.length()));
            }
            return positions;
        }

        public void dispose() {
            this.provider.removeListener((ILabelProviderListener)this);
            this.provider.dispose();
            super.dispose();
        }

        public void addListener(ILabelProviderListener listener) {
            this.listeners.add((Object)listener);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.listeners.remove((Object)listener);
        }

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            Object[] l = this.listeners.getListeners();
            int i = 0;
            while (i < this.listeners.size()) {
                ((ILabelProviderListener)l[i]).labelProviderChanged(event);
                ++i;
            }
        }
    }

    private static class ResourceProxyVisitor
    implements IResourceProxyVisitor {
        private FilteredItemsSelectionDialog.AbstractContentProvider proxyContentProvider;
        private ResourceFilter resourceFilter;
        private IProgressMonitor progressMonitor;

        public ResourceProxyVisitor(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, ResourceFilter resourceFilter, IProgressMonitor progressMonitor) throws CoreException {
            this.proxyContentProvider = contentProvider;
            this.resourceFilter = resourceFilter;
            this.progressMonitor = progressMonitor;
        }

        public boolean visit(IResourceProxy proxy) {
            if (this.progressMonitor.isCanceled()) {
                return false;
            }
            IResource resource = proxy.requestResource();
            this.proxyContentProvider.add((Object)resource, (FilteredItemsSelectionDialog.ItemsFilter)this.resourceFilter);
            if (resource.getType() == 2 && resource.isDerived() && !this.resourceFilter.isShowDerived()) {
                return false;
            }
            return resource.getType() != 1;
        }
    }

    private class ResourceSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        private ResourceSelectionHistory() {
        }

        protected Object restoreItemFromMemento(IMemento element) {
            ResourceFactory resourceFactory = new ResourceFactory();
            return resourceFactory.createElement(element);
        }

        protected void storeItemToMemento(Object item, IMemento element) {
            IResource resource = (IResource)item;
            ResourceFactory resourceFactory = new ResourceFactory(resource);
            resourceFactory.saveState(element);
        }
    }

    private class ShowDerivedResourcesAction
    extends Action {
        public ShowDerivedResourcesAction() {
            super(IDEWorkbenchMessages.FilteredResourcesSelectionDialog_showDerivedResourcesAction, 2);
        }

        public void run() {
            FilteredResourcesSelectionDialog.this.isDerived = this.isChecked();
            FilteredResourcesSelectionDialog.this.applyFilter();
        }
    }
}

