/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.extensionlocation;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.extensionlocation.Activator;
import org.eclipse.equinox.internal.p2.extensionlocation.Constants;
import org.eclipse.equinox.internal.p2.extensionlocation.ExtensionLocationMetadataRepositoryFactory;
import org.eclipse.equinox.internal.p2.extensionlocation.Messages;
import org.eclipse.equinox.internal.p2.extensionlocation.SiteListener;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.IRepositoryReference;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.spi.AbstractMetadataRepository;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public class ExtensionLocationMetadataRepository
extends AbstractMetadataRepository
implements Constants {
    public static final String TYPE = "org.eclipse.equinox.p2.extensionlocation.metadataRepository";
    public static final Integer VERSION = 1;
    public static final List<String> STANDARD_P2_REPOSITORY_FILE_NAMES = Arrays.asList("artifacts.jar", "content.jar", "artifacts.xml", "content.xml", "compositeArtifacts.xml", "compositeContent.xml", "compositeArtifacts.jar", "compositeContent.jar");
    IMetadataRepository metadataRepository;
    private File base;
    private Object state = SiteListener.UNINITIALIZED;

    public static URI getLocalRepositoryLocation(URI location) {
        BundleContext context = Activator.getContext();
        String stateDirName = Integer.toString(location.toString().hashCode());
        File bundleData = context.getDataFile(null);
        return new File(bundleData, stateDirName).toURI();
    }

    public ExtensionLocationMetadataRepository(IProvisioningAgent agent, URI location, IMetadataRepository repository, IProgressMonitor monitor) throws ProvisionException {
        super(agent, Activator.getRepositoryName(location), TYPE, VERSION.toString(), location, null, null, null);
        this.metadataRepository = repository;
        this.base = ExtensionLocationMetadataRepository.getBaseDirectory(location);
    }

    public synchronized void ensureInitialized() {
        if (this.state == SiteListener.INITIALIZED || this.state == SiteListener.INITIALIZING) {
            return;
        }
        SiteListener.synchronizeRepositories(this, null, this.base);
    }

    void reload() {
        try {
            ExtensionLocationMetadataRepositoryFactory factory = new ExtensionLocationMetadataRepositoryFactory();
            factory.setAgent(this.getProvisioningAgent());
            ExtensionLocationMetadataRepository repo = (ExtensionLocationMetadataRepository)factory.load(this.getLocation(), 0, null);
            this.metadataRepository = repo.metadataRepository;
            this.base = repo.base;
        }
        catch (ProvisionException e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    void state(Object value) {
        this.state = value;
    }

    public Collection<IRepositoryReference> getReferences() {
        return Collections.emptyList();
    }

    public void addInstallableUnits(Collection<IInstallableUnit> installableUnits) {
        throw new UnsupportedOperationException();
    }

    public void removeAll() {
        throw new UnsupportedOperationException();
    }

    public boolean removeInstallableUnits(Collection<IInstallableUnit> installableUnits) {
        throw new UnsupportedOperationException();
    }

    public IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
        this.ensureInitialized();
        return this.metadataRepository.query(query, monitor);
    }

    public boolean contains(IInstallableUnit element) {
        return this.metadataRepository.contains((Object)element);
    }

    public static void validate(URI location, IProgressMonitor monitor) throws ProvisionException {
        File base = ExtensionLocationMetadataRepository.getBaseDirectory(location);
        if (new File(base, ".eclipseextension").exists() || location.getPath().endsWith(".eclipseextension")) {
            return;
        }
        if (ExtensionLocationMetadataRepository.containsUpdateSiteFile(base)) {
            String message = NLS.bind((String)Messages.error_update_site, (Object)location.toString());
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", 1000, message, null));
        }
        if (ExtensionLocationMetadataRepository.containsStandardP2Repository(base)) {
            String message = NLS.bind((String)Messages.error_p2_repository, (Object)location.toString());
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", 1000, message, null));
        }
    }

    private static boolean containsStandardP2Repository(File base) {
        File[] foundRepos = base.listFiles((dir, name) -> STANDARD_P2_REPOSITORY_FILE_NAMES.contains(name));
        return foundRepos.length > 0;
    }

    private static boolean containsUpdateSiteFile(File base) {
        String[] fileNames = base.list();
        if (fileNames == null) {
            return false;
        }
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            if (fileName.endsWith(".xml") && fileName.contains("site")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static File getBaseDirectory(URI uri) throws ProvisionException {
        if (!"file".equals(uri.getScheme())) {
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", 1000, Messages.not_file_protocol, null));
        }
        File base = URIUtil.toFile((URI)uri);
        String path = base.getAbsolutePath();
        if (path.endsWith(".eclipseextension")) {
            base = new File(path.substring(0, path.length() - ".eclipseextension".length()));
        }
        if (!base.isDirectory()) {
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", 1000, NLS.bind((String)Messages.not_directory, (Object)uri.toString()), null));
        }
        if (ExtensionLocationMetadataRepository.isBaseDirectory(base)) {
            return base;
        }
        File eclipseBase = new File(base, "eclipse");
        if (ExtensionLocationMetadataRepository.isBaseDirectory(eclipseBase)) {
            return eclipseBase;
        }
        throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", 1000, NLS.bind((String)Messages.not_eclipse_extension, (Object)uri.toString()), null));
    }

    private static boolean isBaseDirectory(File base) {
        File plugins = new File(base, "plugins");
        File features = new File(base, "features");
        return plugins.isDirectory() || features.isDirectory();
    }

    public Map<String, String> getProperties() {
        this.ensureInitialized();
        return this.metadataRepository.getProperties();
    }

    public void initialize(AbstractMetadataRepository.RepositoryState repositoryState) {
    }

    public String setProperty(String key, String value, IProgressMonitor monitor) {
        try {
            this.ensureInitialized();
            String oldValue = this.metadataRepository.setProperty(key, value);
            if (oldValue == value || oldValue != null && oldValue.equals(value)) {
                String string = oldValue;
                return string;
            }
            if (!"org.eclipse.update.site.list".equals(key) && !"org.eclipse.update.site.policy".equals(key)) {
                String string = oldValue;
                return string;
            }
            this.state = SiteListener.UNINITIALIZED;
            this.ensureInitialized();
            String string = oldValue;
            return string;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }
}

