/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.PathVariablesGroup;

public class PathVariableEditDialog
extends SelectionDialog {
    private PathVariablesGroup pathVariablesGroup;

    public PathVariableEditDialog(Shell parentShell) {
        super(parentShell);
        this.setTitle(IDEWorkbenchMessages.PathVariableSelectionDialog_title);
        this.pathVariablesGroup = new PathVariablesGroup(false, 2, null);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
    }

    public boolean close() {
        this.pathVariablesGroup.dispose();
        return super.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.ide.path_variable_selection_dialog");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogAreaComposite = (Composite)super.createDialogArea(parent);
        this.pathVariablesGroup.createContents(dialogAreaComposite);
        return dialogAreaComposite;
    }

    protected void okPressed() {
        try {
            if (this.pathVariablesGroup.performOk()) {
                PathVariablesGroup.PathVariableElement[] selection = this.pathVariablesGroup.getSelection();
                Object[] variableNames = new String[selection.length];
                int i = 0;
                while (i < selection.length) {
                    variableNames[i] = selection[i].name;
                    ++i;
                }
                this.setSelectionResult(variableNames);
            } else {
                this.setSelectionResult(null);
            }
            super.okPressed();
        }
        catch (Throwable t) {
            IDEWorkbenchPlugin.log(t.getMessage(), t);
        }
    }

    public void setResource(IResource resource) {
        this.pathVariablesGroup.setResource(resource);
    }
}

