/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.eclipse;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.LazyManipulator;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdminRuntimeException;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;

public class AgentFromInstall {
    private File configurationFolder;
    private File installFolder;
    private IProvisioningAgentProvider agentProvider;
    private String profileId;
    private String p2DataAreaURI;
    private String userSpecifiedProfileId;

    private AgentFromInstall(IProvisioningAgentProvider agentProvider, File installFolder, File configurationFolder, String profileId) {
        this.installFolder = installFolder;
        this.configurationFolder = configurationFolder;
        this.agentProvider = agentProvider;
        this.userSpecifiedProfileId = profileId;
    }

    public static IProvisioningAgent createAgentFrom(IProvisioningAgentProvider agentProvider, File installFolder, File configurationFolder, String profileId) {
        AgentFromInstall newInstance = new AgentFromInstall(agentProvider, installFolder, configurationFolder, profileId);
        return newInstance.loadAgent();
    }

    private IProvisioningAgent loadAgent() {
        if (this.installFolder != null) {
            if (!this.installFolder.exists()) {
                return null;
            }
            this.initializeFromConfigFiles();
        } else {
            this.initializeByGuessing();
        }
        if (this.profileId == null) {
            this.profileId = this.userSpecifiedProfileId;
        }
        if (this.profileId == null || this.p2DataAreaURI == null) {
            return null;
        }
        return this.createAgent();
    }

    public IProvisioningAgent createAgent() {
        IProvisioningAgent agent = null;
        try {
            agent = this.agentProvider.createAgent(URIUtil.fromString((String)this.p2DataAreaURI));
        }
        catch (ProvisionException provisionException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        agent.registerService("FORCED_SELF", (Object)this.profileId);
        return agent;
    }

    private boolean initializeFromConfigFiles() {
        FrameworkAdmin fwk = LazyManipulator.getFrameworkAdmin();
        if (fwk == null) {
            return false;
        }
        Manipulator manipulator = fwk.getManipulator();
        LauncherData launcherData = manipulator.getLauncherData();
        launcherData.setFwConfigLocation(this.configurationFolder != null ? this.configurationFolder : new File(this.installFolder, "configuration/config.ini"));
        launcherData.setHome(this.installFolder);
        try {
            manipulator.load();
        }
        catch (IllegalStateException e) {
            return false;
        }
        catch (FrameworkAdminRuntimeException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        this.profileId = manipulator.getConfigData().getProperty("eclipse.p2.profile");
        this.p2DataAreaURI = manipulator.getConfigData().getProperty("eclipse.p2.data.area");
        return true;
    }

    private void initializeByGuessing() {
        File p2Folder = new File(this.configurationFolder, "p2");
        if (!p2Folder.exists() && !(p2Folder = new File(this.configurationFolder.getParentFile(), "p2")).exists()) {
            return;
        }
        this.p2DataAreaURI = p2Folder.toURI().toASCIIString();
        if (this.profileId == null) {
            this.profileId = AgentFromInstall.findProfile(AgentFromInstall.getProfileRegistryFolder(p2Folder));
        }
    }

    private static File getProfileRegistryFolder(File p2Folder) {
        return new File(p2Folder, "org.eclipse.equinox.p2.engine/profileRegistry/");
    }

    private static String findProfile(File profileDirectory) {
        String PROFILE_EXT = ".profile";
        File[] profileDirectories = profileDirectory.listFiles(pathname -> pathname.getName().endsWith(".profile") && pathname.isDirectory());
        if (profileDirectories.length == 1) {
            String directoryName = profileDirectories[0].getName();
            return SimpleProfileRegistry.unescape((String)directoryName.substring(0, directoryName.lastIndexOf(".profile")));
        }
        return null;
    }
}

