/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.urischeme.internal.registration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.urischeme.IOperatingSystemRegistration;
import org.eclipse.urischeme.IScheme;
import org.eclipse.urischeme.ISchemeInformation;
import org.eclipse.urischeme.internal.registration.FileProvider;
import org.eclipse.urischeme.internal.registration.IFileProvider;
import org.eclipse.urischeme.internal.registration.IProcessExecutor;
import org.eclipse.urischeme.internal.registration.PlistFileWriter;
import org.eclipse.urischeme.internal.registration.ProcessExecutor;
import org.eclipse.urischeme.internal.registration.SchemeInformation;

public class RegistrationMacOsX
implements IOperatingSystemRegistration {
    private static final String PLIST_PATH_SUFFIX = "/Contents/Info.plist";
    private static final String LSREGISTER = "/System/Library/Frameworks/CoreServices.framework/Versions/A/Frameworks/LaunchServices.framework/Versions/A/Support/lsregister";
    private static final String UNREGISTER = "-u";
    private static final String RECURSIVE = "-r";
    private static final String DUMP = "-dump";
    private static final String ANY_LINES = "(?:.*\\n)*";
    private static final String TRAILING_HEX_VALUE_WITH_BRACKETS = "\\s\\(0x\\w*\\)";
    private static final String PATH_WITH_CAPTURING_GROUP = "path:\\s*(.*)";
    private IFileProvider fileProvider;
    private IProcessExecutor processExecutor;
    private String lsRegisterOutput = null;

    public RegistrationMacOsX() {
        this(new FileProvider(), new ProcessExecutor());
    }

    public RegistrationMacOsX(IFileProvider fileProvider, IProcessExecutor processExecutor) {
        this.fileProvider = fileProvider;
        this.processExecutor = processExecutor;
    }

    @Override
    public void handleSchemes(Collection<IScheme> toAdd, Collection<IScheme> toRemove) throws Exception {
        String pathToEclipseApp = this.getPathToEclipseApp();
        this.changePlistFile(toAdd, toRemove, pathToEclipseApp);
        this.registerAppWithLsregister(pathToEclipseApp);
    }

    @Override
    public List<ISchemeInformation> getSchemesInformation(Collection<IScheme> schemes) throws Exception {
        ArrayList<ISchemeInformation> returnList = new ArrayList<ISchemeInformation>();
        String eclipseLauncher = this.getEclipseLauncher();
        for (IScheme scheme : schemes) {
            SchemeInformation schemeInfo = new SchemeInformation(scheme.getName(), scheme.getDescription());
            String location = this.determineHandlerLocation(this.getLsRegisterOutput(), scheme.getName());
            if (!location.isEmpty() && eclipseLauncher.startsWith(location)) {
                schemeInfo.setHandled(true);
            }
            schemeInfo.setHandlerLocation(location);
            returnList.add(schemeInfo);
        }
        return returnList;
    }

    private String getLsRegisterOutput() throws Exception {
        if (this.lsRegisterOutput != null) {
            return this.lsRegisterOutput;
        }
        this.lsRegisterOutput = this.processExecutor.execute(LSREGISTER, DUMP);
        return this.lsRegisterOutput;
    }

    private String determineHandlerLocation(String lsRegisterDump, String scheme) {
        String keyOfSchemeList;
        String keyOfFirstLine;
        String[] lsRegisterEntries = lsRegisterDump.split("-{80}\n");
        if (((Stream)Stream.of(lsRegisterEntries).parallel()).anyMatch(s -> s.startsWith("BundleClass:"))) {
            keyOfFirstLine = "BundleClass";
            keyOfSchemeList = "bindings:";
        } else {
            keyOfFirstLine = "bundle id";
            keyOfSchemeList = "claimed schemes:";
        }
        Pattern pattern = Pattern.compile("^(?:.*\\n)*\\s*path:\\s*(.*)\\n(?:.*\\n)*\\s*" + keyOfSchemeList + ".*" + Pattern.quote(scheme) + ":", 8);
        return ((Stream)Stream.of(lsRegisterEntries).parallel()).filter(s -> s.startsWith(keyOfFirstLine)).filter(s -> s.contains(scheme + ":")).map(pattern::matcher).filter(Matcher::find).map(m -> m.group(1)).findFirst().map(s -> s.replaceFirst(TRAILING_HEX_VALUE_WITH_BRACKETS, "")).orElse("");
    }

    private PlistFileWriter getPlistFileWriter(String plistPath) {
        return new PlistFileWriter(() -> this.fileProvider.newReader(plistPath));
    }

    @Override
    public String getEclipseLauncher() {
        return this.getPathToEclipseApp();
    }

    private void registerAppWithLsregister(String pathToEclipseApp) throws Exception {
        this.processExecutor.execute(LSREGISTER, UNREGISTER, pathToEclipseApp);
        this.processExecutor.execute(LSREGISTER, RECURSIVE, pathToEclipseApp);
    }

    private void changePlistFile(Collection<IScheme> toAdd, Collection<IScheme> toRemove, String pathToEclipseApp) {
        if (!this.supportsRegistration()) {
            return;
        }
        String plistPath = pathToEclipseApp + PLIST_PATH_SUFFIX;
        PlistFileWriter writer = this.getPlistFileWriter(plistPath);
        for (IScheme scheme : toAdd) {
            writer.addScheme(scheme.getName(), scheme.getDescription());
        }
        for (IScheme scheme : toRemove) {
            writer.removeScheme(scheme.getName());
        }
        writer.writeTo(() -> this.fileProvider.newWriter(plistPath));
    }

    private String getPathToEclipseApp() {
        String homeLocationProperty = System.getProperty("eclipse.home.location");
        return homeLocationProperty.replaceAll("file:(.*)\\/Contents\\/Eclipse.*", "$1");
    }

    @Override
    public boolean canOverwriteOtherApplicationsRegistration() {
        return false;
    }

    @Override
    public boolean supportsRegistration() {
        return !this.fileProvider.fileExists(this.getPathToEclipseApp() + "/Contents/_CodeSignature");
    }
}

