/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg.sig;

import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public class RegularExpression
extends SignatureSubpacket {
    public RegularExpression(boolean bl, boolean bl2, byte[] byArray) {
        super(6, bl, bl2, byArray);
        if (byArray[byArray.length - 1] != 0) {
            throw new IllegalArgumentException("data in regex missing null termination");
        }
    }

    public RegularExpression(boolean bl, String string) {
        super(6, bl, false, RegularExpression.toNullTerminatedUTF8ByteArray(string));
    }

    public String getRegex() {
        return Strings.fromUTF8ByteArray((byte[])this.data, (int)0, (int)(this.data.length - 1));
    }

    public byte[] getRawRegex() {
        return Arrays.clone((byte[])this.data);
    }

    private static byte[] toNullTerminatedUTF8ByteArray(String string) {
        byte[] byArray = Strings.toUTF8ByteArray((String)string);
        return Arrays.append((byte[])byArray, (byte)0);
    }
}

