/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.internal.databinding.Util;
import org.eclipse.core.internal.databinding.validation.ValidatedObservableList;
import org.eclipse.core.internal.databinding.validation.ValidatedObservableMap;
import org.eclipse.core.internal.databinding.validation.ValidatedObservableSet;
import org.eclipse.core.internal.databinding.validation.ValidatedObservableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;

public abstract class MultiValidator
extends ValidationStatusProvider {
    private Realm realm;
    private ValidationStatusObservableValue validationStatus;
    private IObservableValue<IStatus> unmodifiableValidationStatus;
    private WritableList<IObservable> targets;
    private IObservableList<IObservable> unmodifiableTargets;
    private IObservableList<IObservable> models;
    IListChangeListener<IObservable> targetsListener = event -> event.diff.accept((ListDiffVisitor)new ListDiffVisitor<IObservable>(){

        public void handleAdd(int index, IObservable dependency) {
            dependency.addChangeListener((IChangeListener)MultiValidator.this.dependencyListener);
            dependency.addStaleListener((IStaleListener)MultiValidator.this.dependencyListener);
        }

        public void handleRemove(int index, IObservable dependency) {
            dependency.removeChangeListener((IChangeListener)MultiValidator.this.dependencyListener);
            dependency.removeStaleListener((IStaleListener)MultiValidator.this.dependencyListener);
        }
    });
    private DependencyListener dependencyListener = new DependencyListener();

    public MultiValidator() {
        this(Realm.getDefault());
    }

    public MultiValidator(Realm realm) {
        Assert.isNotNull((Object)realm, (String)"Realm cannot be null");
        this.realm = realm;
        ObservableTracker.setIgnore((boolean)true);
        try {
            this.validationStatus = new ValidationStatusObservableValue(realm);
            this.targets = new WritableList(realm, new ArrayList(), IObservable.class);
            this.targets.addListChangeListener(this.targetsListener);
            this.unmodifiableTargets = Observables.unmodifiableObservableList(this.targets);
            this.models = Observables.emptyObservableList((Realm)realm);
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
    }

    private void checkObservable(IObservable target) {
        Assert.isNotNull((Object)target, (String)"Target observable cannot be null");
        Assert.isTrue((boolean)this.realm.equals(target.getRealm()), (String)"Target observable must be in the same realm as MultiValidator");
    }

    @Override
    public IObservableValue<IStatus> getValidationStatus() {
        if (this.unmodifiableValidationStatus == null) {
            ObservableTracker.setIgnore((boolean)true);
            try {
                this.unmodifiableValidationStatus = Observables.unmodifiableObservableValue((IObservableValue)this.validationStatus);
            }
            finally {
                ObservableTracker.setIgnore((boolean)false);
            }
            this.revalidate();
        }
        return this.unmodifiableValidationStatus;
    }

    protected final void revalidate() {
        class ValidationRunnable
        implements Runnable {
            IStatus validationResult;

            ValidationRunnable() {
            }

            @Override
            public void run() {
                try {
                    this.validationResult = MultiValidator.this.validate();
                    if (this.validationResult == null) {
                        this.validationResult = ValidationStatus.ok();
                    }
                }
                catch (RuntimeException e) {
                    this.validationResult = ValidationStatus.error(e.getMessage(), e);
                }
            }
        }
        ValidationRunnable validationRunnable = new ValidationRunnable();
        IObservable[] dependencies = ObservableTracker.runAndMonitor((Runnable)validationRunnable, null, null);
        ObservableTracker.setIgnore((boolean)true);
        try {
            ArrayList<IObservable> newTargets = new ArrayList<IObservable>(Arrays.asList(dependencies));
            Iterator itNew = newTargets.iterator();
            while (itNew.hasNext()) {
                IObservable newDependency = (IObservable)itNew.next();
                if (newDependency != this.validationStatus && newDependency != this.unmodifiableValidationStatus && newDependency != this.targets && newDependency != this.unmodifiableTargets && newDependency != this.models) continue;
                itNew.remove();
            }
            int i = this.targets.size() - 1;
            while (i >= 0) {
                block6: {
                    IObservable oldDependency = (IObservable)this.targets.get(i);
                    Iterator itNew2 = newTargets.iterator();
                    while (itNew2.hasNext()) {
                        Object newDependency = itNew2.next();
                        if (oldDependency != newDependency) continue;
                        itNew2.remove();
                        break block6;
                    }
                    this.targets.remove(i);
                }
                --i;
            }
            this.targets.addAll(newTargets);
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
        this.validationStatus.setValue(validationRunnable.validationResult);
    }

    protected abstract IStatus validate();

    public <T> IObservableValue<T> observeValidatedValue(IObservableValue<T> target) {
        this.checkObservable((IObservable)target);
        return new ValidatedObservableValue<T>(target, this.getValidationStatus());
    }

    public <E> IObservableList<E> observeValidatedList(IObservableList<E> target) {
        this.checkObservable((IObservable)target);
        return new ValidatedObservableList<E>(target, this.getValidationStatus());
    }

    public <E> IObservableSet<E> observeValidatedSet(IObservableSet<E> target) {
        this.checkObservable((IObservable)target);
        return new ValidatedObservableSet<E>(target, this.getValidationStatus());
    }

    public <K, V> IObservableMap<K, V> observeValidatedMap(IObservableMap<K, V> target) {
        this.checkObservable((IObservable)target);
        return new ValidatedObservableMap<K, V>(target, this.getValidationStatus());
    }

    @Override
    public IObservableList<IObservable> getTargets() {
        return this.unmodifiableTargets;
    }

    @Override
    public IObservableList<IObservable> getModels() {
        return this.models;
    }

    @Override
    public void dispose() {
        if (this.targets != null) {
            this.targets.clear();
        }
        if (this.unmodifiableValidationStatus != null) {
            this.unmodifiableValidationStatus.dispose();
            this.unmodifiableValidationStatus = null;
        }
        if (this.validationStatus != null) {
            this.validationStatus.dispose();
            this.validationStatus = null;
        }
        if (this.unmodifiableTargets != null) {
            this.unmodifiableTargets.dispose();
            this.unmodifiableTargets = null;
        }
        if (this.targets != null) {
            this.targets.dispose();
            this.targets = null;
        }
        if (this.models != null) {
            this.models.dispose();
            this.models = null;
        }
        this.realm = null;
        super.dispose();
    }

    private class DependencyListener
    implements IChangeListener,
    IStaleListener {
        private DependencyListener() {
        }

        public void handleChange(ChangeEvent event) {
            MultiValidator.this.revalidate();
        }

        public void handleStale(StaleEvent staleEvent) {
            MultiValidator.this.validationStatus.makeStale();
        }
    }

    private class ValidationStatusObservableValue
    extends AbstractObservableValue<IStatus> {
        private IStatus value;
        private boolean stale;

        public ValidationStatusObservableValue(Realm realm) {
            super(realm);
            this.value = ValidationStatus.ok();
            this.stale = false;
        }

        protected IStatus doGetValue() {
            return this.value;
        }

        protected void doSetValue(IStatus value) {
            boolean oldStale = this.stale;
            this.stale = false;
            for (IObservable dependency : MultiValidator.this.targets) {
                if (!dependency.isStale()) continue;
                this.stale = true;
                break;
            }
            IStatus oldValue = this.value;
            this.value = value;
            if (oldStale && !this.stale || !Util.equals(oldValue, value)) {
                this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)value));
            } else if (!oldStale && this.stale) {
                this.fireStale();
            }
        }

        void makeStale() {
            if (!this.stale) {
                this.stale = true;
                this.fireStale();
            }
        }

        public boolean isStale() {
            ObservableTracker.getterCalled((IObservable)this);
            return this.stale;
        }

        public Object getValueType() {
            return IStatus.class;
        }
    }
}

