/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.minmax;

import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class TrimPaneLayout
extends Layout {
    private static int BORDER_WIDTH = 4;
    private static final Rectangle EMPTY_RECT = new Rectangle(0, 0, 0, 0);
    private final int fixedCorner;
    public Rectangle hSizingRect = EMPTY_RECT;
    public Rectangle vSizingRect = EMPTY_RECT;
    public Rectangle cornerRect = EMPTY_RECT;
    private Rectangle clientRect = EMPTY_RECT;
    private boolean resizeInstalled = false;
    private static int NOT_SIZING = 0;
    private static int HORIZONTAL_SIZING = 1;
    private static int VERTICAL_SIZING = 2;
    private static int CORNER_SIZING = 3;
    int trackState = 0;
    protected Point curPos;
    private final MToolControl toolControl;

    public TrimPaneLayout(MToolControl toolControl, int barSide) {
        this.toolControl = toolControl;
        this.fixedCorner = barSide;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        return new Point(600, 400);
    }

    protected void layout(Composite composite, boolean flushCache) {
        this.installResize(composite);
        if (composite.getChildren().length != 1) {
            return;
        }
        if (this.fixedCorner == 0) {
            return;
        }
        Rectangle bounds = composite.getBounds();
        if (this.isFixed(128)) {
            if (this.isFixed(131072)) {
                this.hSizingRect = new Rectangle(0, 0, BORDER_WIDTH, bounds.height - BORDER_WIDTH);
                this.vSizingRect = new Rectangle(BORDER_WIDTH, bounds.height - BORDER_WIDTH, bounds.width - BORDER_WIDTH, BORDER_WIDTH);
                this.cornerRect = new Rectangle(0, bounds.height - BORDER_WIDTH, BORDER_WIDTH, BORDER_WIDTH);
                this.clientRect = new Rectangle(BORDER_WIDTH, 0, bounds.width - BORDER_WIDTH, bounds.height - BORDER_WIDTH);
            } else {
                this.hSizingRect = new Rectangle(bounds.width - BORDER_WIDTH, 0, BORDER_WIDTH, bounds.height - BORDER_WIDTH);
                this.vSizingRect = new Rectangle(0, bounds.height - BORDER_WIDTH, bounds.width - BORDER_WIDTH, BORDER_WIDTH);
                this.cornerRect = new Rectangle(bounds.width - BORDER_WIDTH, bounds.height - BORDER_WIDTH, BORDER_WIDTH, BORDER_WIDTH);
                this.clientRect = new Rectangle(0, 0, bounds.width - BORDER_WIDTH, bounds.height - BORDER_WIDTH);
            }
        } else if (this.isFixed(1024)) {
            if (this.isFixed(131072)) {
                this.hSizingRect = new Rectangle(0, BORDER_WIDTH, BORDER_WIDTH, bounds.height - BORDER_WIDTH);
                this.vSizingRect = new Rectangle(BORDER_WIDTH, 0, bounds.width - BORDER_WIDTH, BORDER_WIDTH);
                this.cornerRect = new Rectangle(0, 0, BORDER_WIDTH, BORDER_WIDTH);
                this.clientRect = new Rectangle(BORDER_WIDTH, BORDER_WIDTH, bounds.width - BORDER_WIDTH, bounds.height - BORDER_WIDTH);
            } else {
                this.hSizingRect = new Rectangle(bounds.width - BORDER_WIDTH, BORDER_WIDTH, BORDER_WIDTH, bounds.height - BORDER_WIDTH);
                this.vSizingRect = new Rectangle(0, 0, bounds.width - BORDER_WIDTH, BORDER_WIDTH);
                this.cornerRect = new Rectangle(bounds.width - BORDER_WIDTH, 0, BORDER_WIDTH, BORDER_WIDTH);
                this.clientRect = new Rectangle(0, BORDER_WIDTH, bounds.width - BORDER_WIDTH, bounds.height - BORDER_WIDTH);
            }
        }
        Control child = composite.getChildren()[0];
        child.setBounds(this.clientRect);
    }

    private void installResize(final Composite composite) {
        if (this.resizeInstalled) {
            return;
        }
        composite.addMouseMoveListener(e -> {
            Point p = e.display.getCursorLocation();
            if (this.trackState == NOT_SIZING) {
                this.setCursor(composite, new Point(e.x, e.y));
            } else if (this.trackState == HORIZONTAL_SIZING) {
                this.dragHorizontal(composite, p);
            } else if (this.trackState == VERTICAL_SIZING) {
                this.dragVertical(composite, p);
            } else if (this.trackState == CORNER_SIZING) {
                this.dragCorner(composite, p);
            }
        });
        composite.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                composite.setCapture(false);
                Point size = composite.getSize();
                TrimPaneLayout.this.toolControl.getPersistedState().put("XSize", Integer.toString(size.x));
                TrimPaneLayout.this.toolControl.getPersistedState().put("YSize", Integer.toString(size.y));
                TrimPaneLayout.this.trackState = NOT_SIZING;
            }

            public void mouseDown(MouseEvent e) {
                Point p = new Point(e.x, e.y);
                if (TrimPaneLayout.this.hSizingRect.contains(p)) {
                    TrimPaneLayout.this.curPos = e.display.getCursorLocation();
                    TrimPaneLayout.this.trackState = HORIZONTAL_SIZING;
                    composite.setCapture(true);
                } else if (TrimPaneLayout.this.vSizingRect.contains(p)) {
                    TrimPaneLayout.this.curPos = e.display.getCursorLocation();
                    TrimPaneLayout.this.trackState = VERTICAL_SIZING;
                    composite.setCapture(true);
                } else if (TrimPaneLayout.this.cornerRect.contains(p)) {
                    TrimPaneLayout.this.curPos = e.display.getCursorLocation();
                    TrimPaneLayout.this.trackState = CORNER_SIZING;
                    composite.setCapture(true);
                }
            }
        });
        composite.addMouseTrackListener(MouseTrackListener.mouseExitAdapter(e -> {
            Composite comp = (Composite)e.widget;
            comp.setCursor(null);
        }));
        this.resizeInstalled = true;
    }

    protected void setCursor(Composite composite, Point p) {
        if (this.hSizingRect.contains(p)) {
            composite.setCursor(composite.getDisplay().getSystemCursor(9));
        } else if (this.vSizingRect.contains(p)) {
            composite.setCursor(composite.getDisplay().getSystemCursor(7));
        } else if (this.cornerRect.contains(p)) {
            if (this.isFixed(128)) {
                if (this.isFixed(131072)) {
                    composite.setCursor(composite.getDisplay().getSystemCursor(16));
                } else {
                    composite.setCursor(composite.getDisplay().getSystemCursor(15));
                }
            } else if (this.isFixed(1024)) {
                if (this.isFixed(131072)) {
                    composite.setCursor(composite.getDisplay().getSystemCursor(15));
                } else {
                    composite.setCursor(composite.getDisplay().getSystemCursor(16));
                }
            }
        } else {
            composite.setCursor(null);
        }
    }

    protected void dragCorner(Composite composite, Point p) {
        int dx = p.x - this.curPos.x;
        int dy = p.y - this.curPos.y;
        Rectangle bounds = composite.getBounds();
        if (this.isFixed(131072)) {
            bounds.x += dx;
            bounds.width -= dx;
        } else {
            bounds.width += dx;
        }
        if (this.isFixed(1024)) {
            bounds.y += dy;
            bounds.height -= dy;
        } else {
            bounds.height += dy;
        }
        composite.setBounds(bounds);
        composite.getDisplay().update();
        this.curPos = p;
    }

    protected void dragVertical(Composite composite, Point p) {
        int dy = p.y - this.curPos.y;
        Rectangle bounds = composite.getBounds();
        if (this.isFixed(1024)) {
            bounds.y += dy;
            bounds.height -= dy;
        } else {
            bounds.height += dy;
        }
        composite.setBounds(bounds);
        composite.getDisplay().update();
        this.curPos = p;
    }

    protected void dragHorizontal(Composite composite, Point p) {
        int dx = p.x - this.curPos.x;
        Rectangle bounds = composite.getBounds();
        if (this.isFixed(131072)) {
            bounds.x += dx;
            bounds.width -= dx;
        } else {
            bounds.width += dx;
        }
        composite.setBounds(bounds);
        composite.getDisplay().update();
        this.curPos = p;
    }

    private boolean isFixed(int swtSide) {
        return (this.fixedCorner & swtSide) != 0;
    }
}

