/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.extensions;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.NavigatorSafeRunnable;
import org.eclipse.ui.internal.navigator.Policy;
import org.eclipse.ui.internal.navigator.VisibilityAssistant;
import org.eclipse.ui.internal.navigator.extensions.EvaluationCache;
import org.eclipse.ui.internal.navigator.extensions.ExtensionSequenceNumberComparator;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentRegistryReader;
import org.eclipse.ui.navigator.OverridePolicy;

public class NavigatorContentDescriptorManager {
    private static final NavigatorContentDescriptorManager INSTANCE = new NavigatorContentDescriptorManager();
    private final Map<String, NavigatorContentDescriptor> firstClassDescriptorsMap = new HashMap<String, NavigatorContentDescriptor>();
    private final Map<String, NavigatorContentDescriptor> allDescriptors = new HashMap<String, NavigatorContentDescriptor>();
    private final Map<VisibilityAssistant, EvaluationCache> cachedTriggerPointEvaluations = new WeakHashMap<VisibilityAssistant, EvaluationCache>();
    private final Map<VisibilityAssistant, EvaluationCache> cachedPossibleChildrenEvaluations = new WeakHashMap<VisibilityAssistant, EvaluationCache>();
    private ImageRegistry imageRegistry;
    private final Set<NavigatorContentDescriptor> overridingDescriptors = new HashSet<NavigatorContentDescriptor>();
    private final Set<NavigatorContentDescriptor> saveablesProviderDescriptors = new HashSet<NavigatorContentDescriptor>();
    private final Set<NavigatorContentDescriptor> sortOnlyDescriptors = new HashSet<NavigatorContentDescriptor>();
    private final Set<NavigatorContentDescriptor> firstClassDescriptorsSet = new HashSet<NavigatorContentDescriptor>();
    private static final boolean POSSIBLE_CHILD = true;

    public static NavigatorContentDescriptorManager getInstance() {
        return INSTANCE;
    }

    private NavigatorContentDescriptorManager() {
        new NavigatorContentDescriptorRegistry().readRegistry();
    }

    public NavigatorContentDescriptor[] getAllContentDescriptors() {
        NavigatorContentDescriptor[] finalDescriptors = new NavigatorContentDescriptor[this.allDescriptors.size()];
        finalDescriptors = this.allDescriptors.values().toArray(finalDescriptors);
        Arrays.sort(finalDescriptors, ExtensionSequenceNumberComparator.INSTANCE);
        return finalDescriptors;
    }

    public NavigatorContentDescriptor[] getContentDescriptorsWithSaveables() {
        NavigatorContentDescriptor[] finalDescriptors = new NavigatorContentDescriptor[this.saveablesProviderDescriptors.size()];
        this.saveablesProviderDescriptors.toArray(finalDescriptors);
        Arrays.sort(finalDescriptors, ExtensionSequenceNumberComparator.INSTANCE);
        return finalDescriptors;
    }

    public NavigatorContentDescriptor[] getSortOnlyContentDescriptors() {
        NavigatorContentDescriptor[] finalDescriptors = new NavigatorContentDescriptor[this.sortOnlyDescriptors.size()];
        this.sortOnlyDescriptors.toArray(finalDescriptors);
        Arrays.sort(finalDescriptors, ExtensionSequenceNumberComparator.INSTANCE);
        return finalDescriptors;
    }

    public Set<NavigatorContentDescriptor> findDescriptorsForTriggerPoint(Object anElement, VisibilityAssistant aVisibilityAssistant, boolean considerOverrides) {
        return this.findDescriptors(anElement, this.cachedTriggerPointEvaluations, aVisibilityAssistant, considerOverrides, false);
    }

    public Set<NavigatorContentDescriptor> findDescriptorsForPossibleChild(Object anElement, VisibilityAssistant aVisibilityAssistant, boolean toComputeOverrides) {
        return this.findDescriptors(anElement, this.cachedPossibleChildrenEvaluations, aVisibilityAssistant, toComputeOverrides, true);
    }

    private Set<NavigatorContentDescriptor> findDescriptors(Object anElement, Map<VisibilityAssistant, EvaluationCache> cachedEvaluations, VisibilityAssistant aVisibilityAssistant, boolean considerOverrides, boolean possibleChild) {
        EvaluationCache cache = this.getEvaluationCache(cachedEvaluations, aVisibilityAssistant);
        TreeSet<NavigatorContentDescriptor> descriptors = new TreeSet<NavigatorContentDescriptor>(ExtensionSequenceNumberComparator.INSTANCE);
        NavigatorContentDescriptor[] cachedDescriptors = null;
        cachedDescriptors = cache.getDescriptors(anElement, considerOverrides);
        if (cachedDescriptors != null) {
            descriptors.addAll(Arrays.asList(cachedDescriptors));
            if (Policy.DEBUG_RESOLUTION) {
                System.out.println("Find descriptors for : " + Policy.getObjectString(anElement) + (considerOverrides ? " (with overrides)" : "") + " (cached): " + descriptors);
            }
            return descriptors;
        }
        if (considerOverrides) {
            this.addDescriptorsConsideringOverrides(anElement, this.firstClassDescriptorsSet, aVisibilityAssistant, descriptors, possibleChild);
        } else {
            for (NavigatorContentDescriptor descriptor : this.firstClassDescriptorsSet) {
                if (!aVisibilityAssistant.isActive(descriptor) || !aVisibilityAssistant.isVisible(descriptor) || !(possibleChild ? descriptor.isPossibleChild(anElement) : descriptor.isTriggerPoint(anElement))) continue;
                descriptors.add(descriptor);
            }
        }
        if (Policy.DEBUG_RESOLUTION) {
            System.out.println("Find descriptors for: " + Policy.getObjectString(anElement) + (considerOverrides ? " (with overrides)" : "") + ": " + descriptors);
        }
        cache.setDescriptors(anElement, descriptors.toArray(new NavigatorContentDescriptor[descriptors.size()]), considerOverrides);
        return descriptors;
    }

    private EvaluationCache getEvaluationCache(Map<VisibilityAssistant, EvaluationCache> anEvaluationMap, VisibilityAssistant aVisibilityAssistant) {
        EvaluationCache c = anEvaluationMap.get(aVisibilityAssistant);
        if (c == null) {
            c = new EvaluationCache(aVisibilityAssistant);
            anEvaluationMap.put(aVisibilityAssistant, c);
        }
        return c;
    }

    private boolean addDescriptorsConsideringOverrides(Object anElement, Set<NavigatorContentDescriptor> theChildDescriptors, VisibilityAssistant aVisibilityAssistant, Set<NavigatorContentDescriptor> theFoundDescriptors, boolean possibleChild) {
        int initialSize = theFoundDescriptors.size();
        for (NavigatorContentDescriptor descriptor : theChildDescriptors) {
            boolean isApplicable;
            boolean bl = aVisibilityAssistant.isActive(descriptor) && aVisibilityAssistant.isVisible(descriptor) && (possibleChild ? descriptor.isPossibleChild(anElement) : descriptor.isTriggerPoint(anElement)) ? true : (isApplicable = false);
            if (descriptor.hasOverridingExtensions()) {
                TreeSet<NavigatorContentDescriptor> overridingDescriptors = new TreeSet<NavigatorContentDescriptor>(ExtensionSequenceNumberComparator.INSTANCE);
                boolean isOverridden = this.addDescriptorsConsideringOverrides(anElement, descriptor.getOverriddingExtensions(), aVisibilityAssistant, overridingDescriptors, possibleChild);
                if (!isOverridden && isApplicable) {
                    theFoundDescriptors.add(descriptor);
                    continue;
                }
                if (!isOverridden) continue;
                theFoundDescriptors.addAll(overridingDescriptors);
                continue;
            }
            if (!isApplicable) continue;
            theFoundDescriptors.add(descriptor);
        }
        return initialSize < theFoundDescriptors.size();
    }

    public NavigatorContentDescriptor getContentDescriptor(String id) {
        return this.allDescriptors.get(id);
    }

    public String getText(String descriptorId) {
        NavigatorContentDescriptor descriptor = this.getContentDescriptor(descriptorId);
        if (descriptor != null) {
            return descriptor.getName();
        }
        return descriptorId;
    }

    public Image getImage(String descriptorId) {
        return this.retrieveAndStoreImage(descriptorId);
    }

    protected Image retrieveAndStoreImage(String descriptorId) {
        String iconPath;
        NavigatorContentDescriptor contentDescriptor = this.getContentDescriptor(descriptorId);
        Image image = null;
        if (contentDescriptor != null && (iconPath = contentDescriptor.getIcon()) != null) {
            String prefix = contentDescriptor.getId() == null ? "" : contentDescriptor.getId();
            String iconKey = String.valueOf(prefix) + "::" + iconPath;
            ImageRegistry registry = this.getImageRegistry();
            image = registry.get(iconKey);
            if (image == null || image.isDisposed()) {
                String pluginId = contentDescriptor.getContribution().getPluginId();
                ResourceLocator.imageDescriptorFromBundle((String)pluginId, (String)iconPath).ifPresent(d -> {
                    Image created = d.createImage();
                    if (created != null) {
                        registry.put(iconKey, created);
                    }
                });
                image = registry.get(iconKey);
            }
        }
        return image;
    }

    public void clearCache() {
        for (EvaluationCache cache : this.cachedPossibleChildrenEvaluations.values()) {
            cache.clear();
        }
        for (EvaluationCache cache : this.cachedTriggerPointEvaluations.values()) {
            cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNavigatorContentDescriptor(NavigatorContentDescriptor desc) {
        if (desc == null) {
            return;
        }
        Map<String, NavigatorContentDescriptor> map = this.firstClassDescriptorsMap;
        synchronized (map) {
            if (this.firstClassDescriptorsMap.containsKey(desc.getId())) {
                NavigatorPlugin.logError(0, "An extension already exists with id \"" + desc.getId() + "\".", null);
            } else {
                if (desc.getSuppressedExtensionId() == null) {
                    this.firstClassDescriptorsMap.put(desc.getId(), desc);
                    this.firstClassDescriptorsSet.add(desc);
                    if (Policy.DEBUG_EXTENSION_SETUP) {
                        System.out.println("First class descriptor: " + desc);
                    }
                } else {
                    this.overridingDescriptors.add(desc);
                    if (Policy.DEBUG_EXTENSION_SETUP) {
                        System.out.println("Overriding descriptor: " + desc);
                    }
                }
                this.allDescriptors.put(desc.getId(), desc);
                if (desc.hasSaveablesProvider()) {
                    this.saveablesProviderDescriptors.add(desc);
                    if (Policy.DEBUG_EXTENSION_SETUP) {
                        System.out.println("Saveables provider descriptor: " + desc);
                    }
                }
                if (desc.isSortOnly()) {
                    this.sortOnlyDescriptors.add(desc);
                    if (Policy.DEBUG_EXTENSION_SETUP) {
                        System.out.println("SortOnly descriptor: " + desc);
                    }
                }
            }
        }
    }

    private void computeOverrides() {
        if (this.overridingDescriptors.size() > 0) {
            for (NavigatorContentDescriptor descriptor : this.overridingDescriptors) {
                NavigatorContentDescriptor overriddenDescriptor = this.allDescriptors.get(descriptor.getSuppressedExtensionId());
                if (overriddenDescriptor != null) {
                    if (Policy.DEBUG_EXTENSION_SETUP) {
                        System.out.println(descriptor + " overrides: " + overriddenDescriptor);
                    }
                    overriddenDescriptor.getOverriddingExtensions().add(descriptor);
                    descriptor.setOverriddenDescriptor(overriddenDescriptor);
                    if (descriptor.getOverridePolicy() != OverridePolicy.InvokeAlwaysRegardlessOfSuppressedExt) continue;
                    if (Policy.DEBUG_EXTENSION_SETUP) {
                        System.out.println(descriptor + " is first class");
                    }
                    this.firstClassDescriptorsMap.put(descriptor.getId(), descriptor);
                    this.firstClassDescriptorsSet.add(descriptor);
                    continue;
                }
                String message = "Invalid suppressedExtensionId \"" + descriptor.getSuppressedExtensionId() + "\" specified from \"" + descriptor.getId() + "\" in \"" + descriptor.getContribution().getPluginId() + "\". No extension with matching id found.";
                if (Policy.DEBUG_EXTENSION_SETUP) {
                    System.out.println("Error: " + message);
                }
                NavigatorPlugin.logError(0, message, null);
            }
        }
    }

    private int findId(List<NavigatorContentDescriptor> list, String id) {
        int i = 0;
        int len = list.size();
        while (i < len) {
            NavigatorContentDescriptor desc = list.get(i);
            if (desc.getId().equals(id)) {
                return i;
            }
            ++i;
        }
        NavigatorPlugin.log(2, 0, "Can't find Navigator Content Descriptor with id: " + id, null);
        return -1;
    }

    private void computeSequenceNumbers() {
        NavigatorContentDescriptor desc;
        int len;
        int i;
        NavigatorContentDescriptor[] descs = this.getAllContentDescriptors();
        LinkedList<NavigatorContentDescriptor> list = new LinkedList<NavigatorContentDescriptor>();
        list.addAll(Arrays.asList(descs));
        boolean changed = true;
        while (changed) {
            changed = false;
            i = 0;
            len = list.size();
            while (i < len) {
                int beforeInd;
                desc = (NavigatorContentDescriptor)list.get(i);
                if (desc.getAppearsBeforeId() != null && (beforeInd = this.findId(list, desc.getAppearsBeforeId())) >= 0 && beforeInd < i) {
                    list.add(beforeInd, desc);
                    list.remove(i + 1);
                    changed = true;
                }
                ++i;
            }
        }
        i = 0;
        len = list.size();
        while (i < len) {
            desc = (NavigatorContentDescriptor)list.get(i);
            desc.setSequenceNumber(i);
            if (Policy.DEBUG_EXTENSION_SETUP) {
                System.out.println("Descriptors by sequence: " + desc);
            }
            ++i;
        }
    }

    private ImageRegistry getImageRegistry() {
        if (this.imageRegistry == null) {
            this.imageRegistry = new ImageRegistry();
        }
        return this.imageRegistry;
    }

    private class NavigatorContentDescriptorRegistry
    extends NavigatorContentRegistryReader {
        private NavigatorContentDescriptorRegistry() {
        }

        @Override
        public void readRegistry() {
            super.readRegistry();
            NavigatorContentDescriptorManager.this.computeSequenceNumbers();
            NavigatorContentDescriptorManager.this.computeOverrides();
        }

        @Override
        protected boolean readElement(final IConfigurationElement anElement) {
            if ("navigatorContent".equals(anElement.getName())) {
                SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(anElement){

                    @Override
                    public void run() throws Exception {
                        NavigatorContentDescriptorManager.this.addNavigatorContentDescriptor(new NavigatorContentDescriptor(anElement));
                    }
                });
            }
            return super.readElement(anElement);
        }
    }
}

