/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher.eclipse;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.p2.metadata.TouchpointInstruction;
import org.eclipse.equinox.internal.p2.publisher.eclipse.GeneratorBundleInfo;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.publisher.eclipse.IConfigAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.IExecutableAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.ProductFileAdvice;
import org.eclipse.equinox.p2.repository.IRepositoryReference;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;

public class ConfigCUsAction
extends AbstractPublisherAction {
    protected static final String DEFAULT_START_LEVEL = "osgi.bundles.defaultStartLevel";
    private static Collection<String> PROPERTIES_TO_SKIP = new HashSet<String>();
    private static HashSet<String> PROGRAM_ARGS_TO_SKIP;
    protected Version version;
    protected String id;
    protected String flavor;
    IPublisherResult outerResults = null;

    static {
        PROPERTIES_TO_SKIP.add("osgi.frameworkClassPath");
        PROPERTIES_TO_SKIP.add("osgi.framework");
        PROPERTIES_TO_SKIP.add("osgi.bundles");
        PROPERTIES_TO_SKIP.add("eof");
        PROPERTIES_TO_SKIP.add("eclipse.p2.profile");
        PROPERTIES_TO_SKIP.add("eclipse.p2.data.area");
        PROPERTIES_TO_SKIP.add("org.eclipse.update.reconcile");
        PROPERTIES_TO_SKIP.add("org.eclipse.equinox.simpleconfigurator.configUrl");
        PROGRAM_ARGS_TO_SKIP = new HashSet();
        PROGRAM_ARGS_TO_SKIP.add("--launcher.library");
        PROGRAM_ARGS_TO_SKIP.add("-startup");
        PROGRAM_ARGS_TO_SKIP.add("-configuration");
    }

    public static String getAbstractCUCapabilityNamespace(String id, String type, String flavor, String configSpec) {
        return flavor + id;
    }

    public static String getAbstractCUCapabilityId(String id, String type, String flavor, String configSpec) {
        return id + "." + type;
    }

    public static String computeIUId(String id, String flavor) {
        return flavor + id + ".configuration";
    }

    public ConfigCUsAction(IPublisherInfo info, String flavor, String id, Version version) {
        this.flavor = flavor;
        this.id = id;
        this.version = version;
    }

    public IStatus perform(IPublisherInfo publisherInfo, IPublisherResult results, IProgressMonitor monitor) {
        String[] configSpecs;
        PublisherResult innerResult = new PublisherResult();
        this.outerResults = results;
        this.info = publisherInfo;
        String[] stringArray = configSpecs = publisherInfo.getConfigurations();
        int n = configSpecs.length;
        int n2 = 0;
        while (n2 < n) {
            String configSpec1 = stringArray[n2];
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            String configSpec = configSpec1;
            Collection configAdvice = publisherInfo.getAdvice(configSpec, false, this.id, this.version, IConfigAdvice.class);
            BundleInfo[] bundles = this.fillInBundles(configAdvice, results);
            Set<String> configBundles = configAdvice.stream().filter(ProductFileAdvice.class::isInstance).map(ProductFileAdvice.class::cast).flatMap(pca -> pca.getBundles(true)).map(BundleInfo::getSymbolicName).filter(Objects::nonNull).distinct().collect(Collectors.toSet());
            this.publishBundleCUs(publisherInfo, bundles, configSpec, (IPublisherResult)innerResult, configBundles);
            this.publishConfigIUs(configAdvice, (IPublisherResult)innerResult, configSpec);
            Collection launchingAdvice = publisherInfo.getAdvice(configSpec, false, this.id, this.version, IExecutableAdvice.class);
            this.publishIniIUs(launchingAdvice, (IPublisherResult)innerResult, configSpec);
            ++n2;
        }
        results.merge((IPublisherResult)innerResult, 2);
        this.publishTopLevelConfigurationIU(innerResult.getIUs(null, "root"), results);
        return Status.OK_STATUS;
    }

    private void publishTopLevelConfigurationIU(Collection<? extends IVersionedId> children, IPublisherResult result) {
        MetadataFactory.InstallableUnitDescription descriptor = this.createParentIU(children, ConfigCUsAction.computeIUId(this.id, this.flavor), this.version);
        descriptor.setSingleton(true);
        IInstallableUnit rootIU = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)descriptor);
        if (rootIU == null) {
            return;
        }
        result.addIU(rootIU, "root");
    }

    private BundleInfo[] fillInBundles(Collection<IConfigAdvice> configAdvice, IPublisherResult results) {
        ArrayList<BundleInfo> result = new ArrayList<BundleInfo>();
        for (IConfigAdvice advice : configAdvice) {
            BundleInfo[] bundles;
            int defaultStart = -1;
            Map<String, String> adviceProperties = advice.getProperties();
            if (adviceProperties.containsKey(DEFAULT_START_LEVEL)) {
                try {
                    defaultStart = Integer.parseInt(adviceProperties.get(DEFAULT_START_LEVEL));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            BundleInfo[] bundleInfoArray = bundles = advice.getBundles();
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                BundleInfo bundleInfo = bundleInfoArray[n2];
                if (bundleInfo.getStartLevel() != -1 && bundleInfo.getStartLevel() == defaultStart) {
                    bundleInfo.setStartLevel(-1);
                }
                if (bundleInfo.getSymbolicName() != null && bundleInfo.getVersion() != null || bundleInfo.getLocation() == null) {
                    result.add(bundleInfo);
                } else {
                    try {
                        File location = new File(bundleInfo.getLocation());
                        Dictionary<String, String> manifest = BundlesAction.loadManifestIgnoringExceptions(location);
                        if (manifest != null) {
                            GeneratorBundleInfo newInfo = new GeneratorBundleInfo(bundleInfo);
                            ManifestElement[] element = ManifestElement.parseHeader((String)"dummy-bsn", (String)manifest.get("Bundle-SymbolicName"));
                            newInfo.setSymbolicName(element[0].getValue());
                            newInfo.setVersion(manifest.get("Bundle-Version"));
                            result.add(newInfo);
                        }
                    }
                    catch (BundleException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
        return result.toArray(new BundleInfo[result.size()]);
    }

    private void publishIniIUs(Collection<IExecutableAdvice> launchingAdvice, IPublisherResult results, String configSpec) {
        if (launchingAdvice.isEmpty()) {
            return;
        }
        Object configureData = "";
        Object unconfigureData = "";
        if (!launchingAdvice.isEmpty()) {
            String[] dataStrings = this.getLauncherConfigStrings(launchingAdvice);
            configureData = (String)configureData + dataStrings[0];
            unconfigureData = (String)unconfigureData + dataStrings[1];
        }
        if (((String)configureData).length() == 0 && ((String)unconfigureData).length() == 0) {
            return;
        }
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        touchpointData.put("configure", (String)configureData);
        touchpointData.put("unconfigure", (String)unconfigureData);
        IInstallableUnit cu = this.createCU(this.id, this.version, "ini", this.flavor, configSpec, touchpointData);
        results.addIU(cu, "root");
    }

    private void publishConfigIUs(Collection<IConfigAdvice> configAdvice, IPublisherResult results, String configSpec) {
        if (configAdvice.isEmpty()) {
            return;
        }
        Object configureData = "";
        Object unconfigureData = "";
        if (!configAdvice.isEmpty()) {
            String[] dataStrings = this.getConfigurationStrings(configAdvice);
            configureData = (String)configureData + dataStrings[0];
            unconfigureData = (String)unconfigureData + dataStrings[1];
        }
        if (((String)configureData).length() == 0 && ((String)unconfigureData).length() == 0) {
            return;
        }
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        touchpointData.put("configure", (String)configureData);
        touchpointData.put("unconfigure", (String)unconfigureData);
        IInstallableUnit cu = this.createCU(this.id, this.version, "config", this.flavor, configSpec, touchpointData);
        results.addIU(cu, "root");
    }

    private IInstallableUnit createCU(String cuId, Version cuVersion, String cuType, String cuFlavor, String configSpec, Map<String, String> touchpointData) {
        MetadataFactory.InstallableUnitDescription cu = new MetadataFactory.InstallableUnitDescription();
        String resultId = this.createCUIdString(cuId, cuType, cuFlavor, configSpec);
        cu.setId(resultId);
        cu.setVersion(cuVersion);
        cu.setFilter(this.createFilterSpec(configSpec));
        IProvidedCapability selfCapability = PublisherHelper.createSelfCapability((String)resultId, (Version)cuVersion);
        String namespace = ConfigCUsAction.getAbstractCUCapabilityNamespace(cuId, cuType, cuFlavor, configSpec);
        String abstractId = ConfigCUsAction.getAbstractCUCapabilityId(cuId, cuType, cuFlavor, configSpec);
        IProvidedCapability abstractCapability = MetadataFactory.createProvidedCapability((String)namespace, (String)abstractId, (Version)cuVersion);
        cu.setCapabilities(new IProvidedCapability[]{selfCapability, abstractCapability});
        cu.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        cu.setTouchpointType(PublisherHelper.TOUCHPOINT_OSGI);
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)cu);
    }

    protected String[] getConfigurationStrings(Collection<IConfigAdvice> configAdvice) {
        Object configurationData = "";
        Object unconfigurationData = "";
        HashSet<String> properties = new HashSet<String>();
        for (IConfigAdvice advice : configAdvice) {
            for (Map.Entry<String, String> aProperty : advice.getProperties().entrySet()) {
                String key = aProperty.getKey();
                if (!this.shouldPublishProperty(key) || properties.contains(key)) continue;
                properties.add(key);
                LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
                parameters.put("propName", key);
                parameters.put("propValue", aProperty.getValue());
                configurationData = (String)configurationData + TouchpointInstruction.encodeAction((String)"setProgramProperty", parameters);
                parameters.put("propValue", "");
                unconfigurationData = (String)unconfigurationData + TouchpointInstruction.encodeAction((String)"setProgramProperty", parameters);
            }
            if (!(advice instanceof ProductFileAdvice)) continue;
            for (IRepositoryReference repo : ((ProductFileAdvice)advice).getUpdateRepositories()) {
                LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
                parameters.put("type", Integer.toString(repo.getType()));
                parameters.put("location", repo.getLocation().toString());
                parameters.put("enabled", Boolean.toString((repo.getOptions() & 1) == 1));
                configurationData = (String)configurationData + TouchpointInstruction.encodeAction((String)"addRepository", parameters);
                parameters.remove("enabled");
                unconfigurationData = (String)unconfigurationData + TouchpointInstruction.encodeAction((String)"removeRepository", parameters);
            }
        }
        return new String[]{configurationData, unconfigurationData};
    }

    private boolean shouldPublishProperty(String key) {
        return !PROPERTIES_TO_SKIP.contains(key);
    }

    private boolean shouldPublishJvmArg(String key) {
        return true;
    }

    private boolean shouldPublishProgramArg(String key) {
        return !PROGRAM_ARGS_TO_SKIP.contains(key);
    }

    protected String[] getLauncherConfigStrings(Collection<IExecutableAdvice> launchingAdvice) {
        Object configurationData = "";
        Object unconfigurationData = "";
        LinkedHashMap<String, String> touchpointParameters = new LinkedHashMap<String, String>();
        HashSet<String> jvmSet = new HashSet<String>();
        HashSet<String> programSet = new HashSet<String>();
        for (IExecutableAdvice advice : launchingAdvice) {
            String[] jvmArgs;
            String[] stringArray = jvmArgs = advice.getVMArguments();
            int n = jvmArgs.length;
            int n2 = 0;
            while (n2 < n) {
                String jvmArg = stringArray[n2];
                if (this.shouldPublishJvmArg(jvmArg) && !jvmSet.contains(jvmArg)) {
                    jvmSet.add(jvmArg);
                    touchpointParameters.clear();
                    touchpointParameters.put("jvmArg", jvmArg);
                    configurationData = (String)configurationData + TouchpointInstruction.encodeAction((String)"addJvmArg", touchpointParameters);
                    unconfigurationData = (String)unconfigurationData + TouchpointInstruction.encodeAction((String)"removeJvmArg", touchpointParameters);
                }
                ++n2;
            }
            String[] programArgs = advice.getProgramArguments();
            int i = 0;
            while (i < programArgs.length) {
                if (this.shouldPublishProgramArg(programArgs[i]) && !programSet.contains(programArgs[i])) {
                    if (programArgs[i].startsWith("-")) {
                        programSet.add(programArgs[i]);
                    }
                    touchpointParameters.clear();
                    touchpointParameters.put("programArg", programArgs[i]);
                    configurationData = (String)configurationData + TouchpointInstruction.encodeAction((String)"addProgramArg", touchpointParameters);
                    unconfigurationData = (String)unconfigurationData + TouchpointInstruction.encodeAction((String)"removeProgramArg", touchpointParameters);
                } else if (i + 1 < programArgs.length && !programArgs[i + 1].startsWith("-")) {
                    ++i;
                }
                ++i;
            }
        }
        return new String[]{configurationData, unconfigurationData};
    }

    protected void publishBundleCUs(IPublisherInfo publisherInfo, BundleInfo[] bundles, String configSpec, IPublisherResult result, Set<String> configBundles) {
        if (bundles == null) {
            return;
        }
        String cuIdPrefix = "";
        IMatchExpression filter = null;
        if (configSpec != null) {
            cuIdPrefix = this.createIdString(configSpec);
            filter = this.createFilterSpec(configSpec);
        }
        BundleInfo[] bundleInfoArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallableUnit cu;
            IInstallableUnit iu;
            BundleInfo bundleInfo = bundleInfoArray[n2];
            GeneratorBundleInfo generatorBundle = this.createGeneratorBundleInfo(bundleInfo, result);
            if (generatorBundle != null && (iu = generatorBundle.getIU()) != null && this.filterMatches(iu.getFilter(), configSpec) && (generatorBundle.getStartLevel() != -1 || generatorBundle.isMarkedAsStarted()) && (cu = configBundles.contains(bundleInfo.getSymbolicName()) ? BundlesAction.createBundleConfigurationUnit(generatorBundle.getSymbolicName(), this.version, false, generatorBundle, this.flavor + cuIdPrefix, (IMatchExpression<IInstallableUnit>)filter, true) : (this.version != null && !this.version.equals(Version.emptyVersion) ? BundlesAction.createBundleConfigurationUnit(generatorBundle.getSymbolicName(), this.version, false, generatorBundle, this.flavor + cuIdPrefix, (IMatchExpression<IInstallableUnit>)filter) : BundlesAction.createBundleConfigurationUnit(generatorBundle.getSymbolicName(), Version.parseVersion((String)generatorBundle.getVersion()), false, generatorBundle, this.flavor + cuIdPrefix, (IMatchExpression<IInstallableUnit>)filter))) != null) {
                result.addIU(cu, "root");
            }
            ++n2;
        }
    }

    protected GeneratorBundleInfo createGeneratorBundleInfo(BundleInfo bundleInfo, IPublisherResult result) {
        String name = bundleInfo.getSymbolicName();
        IInstallableUnit iu = this.queryForIU(this.outerResults, name, Version.create((String)bundleInfo.getVersion()));
        if (iu != null) {
            if (iu.getVersion() == null) {
                bundleInfo.setVersion("0.0.0");
            } else {
                bundleInfo.setVersion(iu.getVersion().toString());
            }
            GeneratorBundleInfo newInfo = new GeneratorBundleInfo(bundleInfo);
            newInfo.setIU(iu);
            return newInfo;
        }
        if (bundleInfo.getLocation() != null || bundleInfo.getVersion() != null) {
            return new GeneratorBundleInfo(bundleInfo);
        }
        int i = name.indexOf(95);
        while (i > -1) {
            try {
                Version bundleVersion = Version.parseVersion((String)name.substring(i));
                bundleInfo.setSymbolicName(name.substring(0, i));
                bundleInfo.setVersion(bundleVersion.toString());
                return new GeneratorBundleInfo(bundleInfo);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                i = name.indexOf(95, i);
            }
        }
        return null;
    }
}

