/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.misc.ProgramImageDescriptor;
import org.eclipse.ui.internal.util.BundleUtility;

public class WorkbenchImages {
    private static Map<String, ImageDescriptor> descriptors;
    private static ImageRegistry imageRegistry;
    public static final String ICONS_PATH = "$nl$/icons/full/";
    private static final String PATH_ETOOL = "$nl$/icons/full/etool16/";
    private static final String PATH_ELOCALTOOL = "$nl$/icons/full/elcl16/";
    private static final String PATH_EVIEW = "$nl$/icons/full/eview16/";
    private static final String PATH_OVERLAY = "$nl$/icons/full/ovr16/";
    private static final String PATH_OBJECT = "$nl$/icons/full/obj16/";
    private static final String PATH_POINTER = "$nl$/icons/full/pointer/";
    private static final String PATH_WIZBAN = "$nl$/icons/full/wizban/";
    private static final String PATH_PREF = "$nl$/icons/full/pref/";

    private static final void declareImage(String key, String path, boolean shared) {
        WorkbenchImages.declareImage(key, null, path, shared);
    }

    private static final void declareImage(String key, String disabledKey, String path, boolean shared) {
        ImageDescriptor desc = ImageDescriptor.createFromURLSupplier((boolean)true, () -> BundleUtility.find("org.eclipse.ui", path));
        WorkbenchImages.declareImage(key, desc, shared);
        if (disabledKey != null) {
            ImageDescriptor disabledImageDescriptor = ImageDescriptor.createWithFlags((ImageDescriptor)desc, (int)1);
            WorkbenchImages.declareImage(disabledKey, disabledImageDescriptor, shared);
        }
    }

    private static final void declareImages() {
        WorkbenchImages.declareImage("IMG_DEF_MISSING", ImageDescriptor.getMissingImageDescriptor(), true);
        WorkbenchImages.declareImage("IMG_DEC_FIELD_ERROR", "$nl$/icons/full/ovr16/error_ovr.svg", true);
        WorkbenchImages.declareImage("IMG_DEC_FIELD_WARNING", "$nl$/icons/full/ovr16/warning_ovr.svg", true);
        WorkbenchImages.declareImage("IMG_ETOOL_PIN_EDITOR", "IMG_ETOOL_PIN_EDITOR_DISABLED", "$nl$/icons/full/etool16/pin_editor.svg", false);
        WorkbenchImages.declareImage("IMG_ETOOL_SAVE_EDIT", "IMG_ETOOL_SAVE_EDIT_DISABLED", "$nl$/icons/full/etool16/save_edit.svg", true);
        WorkbenchImages.declareImage("IMG_ETOOL_SAVEAS_EDIT", "IMG_ETOOL_SAVEAS_EDIT_DISABLED", "$nl$/icons/full/etool16/saveas_edit.svg", true);
        WorkbenchImages.declareImage("IMG_ETOOL_SAVEALL_EDIT", "IMG_ETOOL_SAVEALL_EDIT_DISABLED", "$nl$/icons/full/etool16/saveall_edit.svg", true);
        WorkbenchImages.declareImage("IMG_TOOL_UNDO", "IMG_TOOL_UNDO_DISABLED", "$nl$/icons/full/etool16/undo_edit.svg", true);
        WorkbenchImages.declareImage("IMG_TOOL_REDO", "IMG_TOOL_REDO_DISABLED", "$nl$/icons/full/etool16/redo_edit.svg", true);
        WorkbenchImages.declareImage("IMG_TOOL_CUT", "IMG_TOOL_CUT_DISABLED", "$nl$/icons/full/etool16/cut_edit.svg", true);
        WorkbenchImages.declareImage("IMG_TOOL_COPY", "IMG_TOOL_COPY_DISABLED", "$nl$/icons/full/etool16/copy_edit.svg", true);
        WorkbenchImages.declareImage("IMG_TOOL_PASTE", "IMG_TOOL_PASTE_DISABLED", "$nl$/icons/full/etool16/paste_edit.svg", true);
        WorkbenchImages.declareImage("IMG_TOOL_DELETE", "IMG_TOOL_DELETE_DISABLED", "$nl$/icons/full/etool16/delete_edit.svg", true);
        WorkbenchImages.declareImage("IMG_ETOOL_DELETE", "IMG_ETOOL_DELETE_DISABLED", "$nl$/icons/full/etool16/delete.svg", true);
        WorkbenchImages.declareImage("IMG_ETOOL_CLEAR", "IMG_ETOOL_CLEAR_DISABLED", "$nl$/icons/full/etool16/clear.svg", true);
        WorkbenchImages.declareImage("IMG_TOOL_NEW_WIZARD", "IMG_TOOL_NEW_WIZARD_DISABLED", "$nl$/icons/full/etool16/new_wiz.svg", true);
        WorkbenchImages.declareImage("IMG_ETOOL_PRINT_EDIT", "IMG_ETOOL_PRINT_EDIT_DISABLED", "$nl$/icons/full/etool16/print_edit.svg", true);
        WorkbenchImages.declareImage("IMG_ETOOL_HELP_CONTENTS", "$nl$/icons/full/etool16/help_contents.svg", true);
        WorkbenchImages.declareImage("IMG_ETOOL_HELP_SEARCH", "$nl$/icons/full/etool16/help_search.svg", true);
        WorkbenchImages.declareImage("IMG_ETOOL_TIPS_AND_TRICKS", "$nl$/icons/full/etool16/tricks.svg", true);
        WorkbenchImages.declareImage("IMG_ETOOL_NEW_FASTVIEW", "IMG_DTOOL_NEW_FASTVIEW", "$nl$/icons/full/etool16/new_fastview.svg", true);
        WorkbenchImages.declareImage("IMG_ETOOL_RESTORE_TRIMPART", "$nl$/icons/full/etool16/fastview_restore.svg", true);
        WorkbenchImages.declareImage("IMG_ETOOL_EDITOR_TRIMPART", "$nl$/icons/full/etool16/editor_area.svg", true);
        WorkbenchImages.declareImage("IMG_TOOL_FORWARD", "IMG_TOOL_FORWARD_DISABLED", "$nl$/icons/full/elcl16/forward_nav.svg", true);
        WorkbenchImages.declareImage("IMG_TOOL_BACK", "IMG_TOOL_BACK_DISABLED", "$nl$/icons/full/elcl16/backward_nav.svg", true);
        WorkbenchImages.declareImage("IMG_TOOL_UP", "IMG_TOOL_UP_DISABLED", "$nl$/icons/full/elcl16/up_nav.svg", true);
        WorkbenchImages.declareImage("IMG_ELCL_SYNCED", "IMG_ELCL_SYNCED_DISABLED", "$nl$/icons/full/elcl16/synced.svg", true);
        WorkbenchImages.declareImage("IMG_ELCL_COLLAPSEALL", "IMG_ELCL_COLLAPSEALL_DISABLED", "$nl$/icons/full/elcl16/collapseall.svg", true);
        WorkbenchImages.declareImage("IMG_ELCL_REMOVE", "IMG_ELCL_REMOVE_DISABLED", "$nl$/icons/full/elcl16/remove.svg", true);
        WorkbenchImages.declareImage("IMG_ELCL_REMOVEALL", "IMG_ELCL_REMOVEALL_DISABLED", "$nl$/icons/full/elcl16/removeall.svg", true);
        WorkbenchImages.declareImage("IMG_ELCL_COLLAPSEALL", "IMG_ELCL_COLLAPSEALL_DISABLED", "$nl$/icons/full/elcl16/collapseall.svg", true);
        WorkbenchImages.declareImage("IMG_ELCL_STOP", "IMG_ELCL_STOP_DISABLED", "$nl$/icons/full/elcl16/stop.svg", true);
        WorkbenchImages.declareImage("IMG_ETOOL_NEW_PAGE", "$nl$/icons/full/eview16/new_persp.svg", false);
        WorkbenchImages.declareImage("IMG_ETOOL_HOME_NAV", "IMG_ETOOL_HOME_NAV_DISABLED", "$nl$/icons/full/elcl16/home_nav.svg", true);
        WorkbenchImages.declareImage("IMG_ETOOL_DEF_PERSPECTIVE", "$nl$/icons/full/eview16/default_persp.svg", true);
        WorkbenchImages.declareImage("IMG_WIZBAN_NEW_WIZ", "$nl$/icons/full/wizban/new_wiz.svg", false);
        WorkbenchImages.declareImage("IMG_ETOOL_IMPORT_WIZ", "$nl$/icons/full/etool16/import_wiz.svg", false);
        WorkbenchImages.declareImage("IMG_ETOOL_EXPORT_WIZ", "$nl$/icons/full/etool16/export_wiz.svg", false);
        WorkbenchImages.declareImage("IMG_WIZBAN_IMPORT_WIZ", "$nl$/icons/full/wizban/import_wiz.svg", false);
        WorkbenchImages.declareImage("IMG_WIZBAN_EXPORT_WIZ", "$nl$/icons/full/wizban/export_wiz.svg", false);
        WorkbenchImages.declareImage("IMG_WIZBAN_IMPORT_PREF_WIZ", "$nl$/icons/full/wizban/importpref_wiz.svg", false);
        WorkbenchImages.declareImage("IMG_WIZBAN_EXPORT_PREF_WIZ", "$nl$/icons/full/wizban/exportpref_wiz.svg", false);
        WorkbenchImages.declareImage("IMG_WIZBAN_WORKINGSET_WIZ", "$nl$/icons/full/wizban/workset_wiz.svg", false);
        WorkbenchImages.declareImage("IMG_VIEW_DEFAULTVIEW_MISC", "$nl$/icons/full/eview16/defaultview_misc.svg", false);
        WorkbenchImages.declareImage("IMG_OBJ_FONT", "$nl$/icons/full/obj16/font.svg", true);
        WorkbenchImages.declareImage("IMG_OBJ_THEME_CATEGORY", "$nl$/icons/full/obj16/theme_category.svg", true);
        WorkbenchImages.declareImage("IMG_OBJ_ACTIVITY", "$nl$/icons/full/obj16/activity.svg", true);
        WorkbenchImages.declareImage("IMG_OBJ_ACTIVITY_CATEGORY", "$nl$/icons/full/obj16/activity_category.svg", true);
        WorkbenchImages.declareImage("IMG_OBJ_WORKING_SETS", "$nl$/icons/full/obj16/workingsets.svg", true);
        WorkbenchImages.declareImage("IMG_OBJ_SEPARATOR", "$nl$/icons/full/obj16/separator.svg", true);
        WorkbenchImages.declareImage("IMG_OBJ_NODE", "$nl$/icons/full/obj16/generic_elements.svg", true);
        WorkbenchImages.declareImage("IMG_OBJ_ELEMENT", "$nl$/icons/full/obj16/generic_element.svg", true);
        WorkbenchImages.declareImage("IMG_OBJ_ADD", "$nl$/icons/full/obj16/add_obj.svg", true);
        WorkbenchImages.declareImage("IMG_OBJ_FILE", "$nl$/icons/full/obj16/file_obj.svg", true);
        WorkbenchImages.declareImage("IMG_OBJ_FOLDER", "$nl$/icons/full/obj16/fldr_obj.svg", true);
        WorkbenchImages.declareImage("IMG_OBJ_ELEMENTS", "$nl$/icons/full/obj16/elements_obj.svg", true);
        WorkbenchImages.declareImage("IMG_DEF_VIEW", "$nl$/icons/full/eview16/defaultview_misc.svg", true);
        WorkbenchImages.declareImage("IMG_LCL_CLOSE_VIEW", "$nl$/icons/full/elcl16/close_view.svg", true);
        WorkbenchImages.declareImage("IMG_LCL_MIN_VIEW", "$nl$/icons/full/elcl16/min_view.svg", true);
        WorkbenchImages.declareImage("IMG_LCL_VIEW_MENU", "$nl$/icons/full/elcl16/view_menu.svg", true);
        WorkbenchImages.declareImage("IMG_LCL_BUTTON_MENU", "$nl$/icons/full/elcl16/button_menu.svg", true);
        WorkbenchImages.declareImage("IMG_LCL_LINKTO_HELP", "$nl$/icons/full/elcl16/linkto_help.svg", true);
        WorkbenchImages.declareImage("IMG_LCL_RENDERED_VIEW_MENU", "$nl$/icons/full/elcl16/view_menu.svg", true);
        WorkbenchImages.declareImage("IMG_LCL_CLOSE_VIEW_THIN", "$nl$/icons/full/elcl16/thin_close_view.svg", true);
        WorkbenchImages.declareImage("IMG_LCL_HIDE_TOOLBAR_THIN", "$nl$/icons/full/elcl16/thin_hide_toolbar.svg", true);
        WorkbenchImages.declareImage("IMG_LCL_MAX_VIEW_THIN", "$nl$/icons/full/elcl16/thin_max_view.svg", true);
        WorkbenchImages.declareImage("IMG_LCL_MIN_VIEW_THIN", "$nl$/icons/full/elcl16/thin_min_view.svg", true);
        WorkbenchImages.declareImage("IMG_LCL_RESTORE_VIEW_THIN", "$nl$/icons/full/elcl16/thin_restore_view.svg", true);
        WorkbenchImages.declareImage("IMG_LCL_SHOW_TOOLBAR_THIN", "$nl$/icons/full/elcl16/thin_show_toolbar.svg", true);
        WorkbenchImages.declareImage("IMG_LCL_VIEW_MENU_THIN", "$nl$/icons/full/elcl16/thin_view_menu.svg", true);
        WorkbenchImages.declareImage("IMG_OBJS_ERROR_TSK", "$nl$/icons/full/obj16/error_tsk.svg", true);
        WorkbenchImages.declareImage("IMG_OBJS_WARN_TSK", "$nl$/icons/full/obj16/warn_tsk.svg", true);
        WorkbenchImages.declareImage("IMG_OBJS_INFO_TSK", "$nl$/icons/full/obj16/info_tsk.svg", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_LEFT_SOURCE", "$nl$/icons/full/pointer/left_source.svg", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_LEFT_MASK", "$nl$/icons/full/pointer/left_mask.svg", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_RIGHT_SOURCE", "$nl$/icons/full/pointer/right_source.svg", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_RIGHT_MASK", "$nl$/icons/full/pointer/right_mask.svg", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_TOP_SOURCE", "$nl$/icons/full/pointer/top_source.svg", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_TOP_MASK", "$nl$/icons/full/pointer/top_mask.svg", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_BOTTOM_SOURCE", "$nl$/icons/full/pointer/bottom_source.svg", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_BOTTOM_MASK", "$nl$/icons/full/pointer/bottom_mask.svg", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_INVALID_SOURCE", "$nl$/icons/full/pointer/invalid_source.svg", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_INVALID_MASK", "$nl$/icons/full/pointer/invalid_mask.svg", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_STACK_SOURCE", "$nl$/icons/full/pointer/stack_source.svg", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_STACK_MASK", "$nl$/icons/full/pointer/stack_mask.svg", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_OFFSCREEN_SOURCE", "$nl$/icons/full/pointer/offscreen_source.svg", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_OFFSCREEN_MASK", "$nl$/icons/full/pointer/offscreen_mask.svg", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_TOFASTVIEW_SOURCE", "$nl$/icons/full/pointer/tofastview_source.svg", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_TOFASTVIEW_MASK", "$nl$/icons/full/pointer/tofastview_mask.svg", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_LEFT", "$nl$/icons/full/pointer/left.svg", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_RIGHT", "$nl$/icons/full/pointer/right.svg", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_TOP", "$nl$/icons/full/pointer/top.svg", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_BOTTOM", "$nl$/icons/full/pointer/bottom.svg", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_INVALID", "$nl$/icons/full/pointer/invalid.svg", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_STACK", "$nl$/icons/full/pointer/stack.svg", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_OFFSCREEN", "$nl$/icons/full/pointer/offscreen.svg", true);
        WorkbenchImages.declareImage("IMG_OBJS_DND_TOFASTVIEW", "$nl$/icons/full/pointer/tofastview.svg", true);
        WorkbenchImages.declareImage("IMG_OBJ_SIGNED_YES", "$nl$/icons/full/obj16/signed_yes_tbl.svg", true);
        WorkbenchImages.declareImage("IMG_OBJ_SIGNED_NO", "$nl$/icons/full/obj16/signed_no_tbl.svg", true);
        WorkbenchImages.declareImage("IMG_OBJ_SIGNED_UNKNOWN", "$nl$/icons/full/obj16/signed_unkn_tbl.svg", true);
        WorkbenchImages.declareImage("IMG_PREF_IMPORT", "$nl$/icons/full/pref/import_wiz.svg", false);
        WorkbenchImages.declareImage("IMG_PREF_EXPORT", "$nl$/icons/full/pref/export_wiz.svg", false);
    }

    public static void declareImage(String symbolicName, ImageDescriptor descriptor, boolean shared) {
        if (Policy.DEBUG_DECLARED_IMAGES) {
            Image image = descriptor.createImage(false);
            if (image == null) {
                WorkbenchPlugin.log("Image not found in WorkbenchImages.declaredImage().  symbolicName=" + symbolicName + " descriptor=" + String.valueOf(descriptor), new Exception("stack dump"));
            } else {
                image.dispose();
            }
        }
        WorkbenchImages.getDescriptors().put(symbolicName, descriptor);
        if (shared) {
            WorkbenchImages.getImageRegistry().put(symbolicName, descriptor);
        }
    }

    public static Map<String, ImageDescriptor> getDescriptors() {
        if (descriptors == null) {
            WorkbenchImages.initializeImageRegistry();
        }
        return descriptors;
    }

    public static Image getImage(String symbolicName) {
        return WorkbenchImages.getImageRegistry().get(symbolicName);
    }

    public static ImageDescriptor getImageDescriptor(String symbolicName) {
        return WorkbenchImages.getDescriptors().get(symbolicName);
    }

    public static ImageDescriptor getImageDescriptorFromProgram(String filename, int offset) {
        Assert.isNotNull((Object)filename);
        String key = filename + "*" + offset;
        ImageDescriptor desc = WorkbenchImages.getImageDescriptor(key);
        if (desc == null) {
            desc = new ProgramImageDescriptor(filename, offset);
            WorkbenchImages.getDescriptors().put(key, desc);
        }
        return desc;
    }

    public static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            WorkbenchImages.initializeImageRegistry();
        }
        return imageRegistry;
    }

    private static void initializeImageRegistry() {
        imageRegistry = new ImageRegistry();
        descriptors = new HashMap<String, ImageDescriptor>();
        WorkbenchImages.declareImages();
    }

    public static void dispose() {
        if (imageRegistry != null) {
            imageRegistry.dispose();
            imageRegistry = null;
            descriptors = null;
        }
    }

    public static ImageDescriptor getWorkbenchImageDescriptor(String relativePath) {
        return ImageDescriptor.createFromURLSupplier((boolean)true, () -> BundleUtility.find("org.eclipse.ui", ICONS_PATH + relativePath));
    }
}

