/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.jface.dialogs;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.passage.lic.base.conditions.ConditionMiners;
import org.eclipse.passage.lic.equinox.LicensingEquinox;
import org.eclipse.passage.lic.internal.jface.viewers.LicensingConditionViewer;
import org.eclipse.passage.lic.jface.resource.LicensingImages;
import org.eclipse.passage.lic.runtime.LicensingConfiguration;
import org.eclipse.passage.lic.runtime.LicensingResult;
import org.eclipse.passage.lic.runtime.conditions.ConditionMinerRegistry;
import org.eclipse.passage.lic.runtime.conditions.ConditionTransport;
import org.eclipse.passage.lic.runtime.conditions.ConditionTransportRegistry;
import org.eclipse.passage.lic.runtime.conditions.LicensingCondition;
import org.eclipse.passage.lic.runtime.io.KeyKeeper;
import org.eclipse.passage.lic.runtime.io.KeyKeeperRegistry;
import org.eclipse.passage.lic.runtime.io.StreamCodec;
import org.eclipse.passage.lic.runtime.io.StreamCodecRegistry;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class ImportLicenseDialog
extends TitleAreaDialog {
    private final ConditionMinerRegistry conditionMinerRegistry;
    private final LicensingConfiguration configuration;
    private final KeyKeeper keyKeeper;
    private final StreamCodec streamCodec;
    private final ConditionTransport transport;
    private final List<LicensingCondition> mined = new ArrayList<LicensingCondition>();
    private Combo sourceText;
    private Button sourceButton;
    private String currentMessage;
    private TableViewer tableViewer;

    public ImportLicenseDialog(Shell shell, LicensingConfiguration configuration) {
        super(shell);
        this.configuration = configuration;
        this.conditionMinerRegistry = (ConditionMinerRegistry)LicensingEquinox.getLicensingService(ConditionMinerRegistry.class);
        this.keyKeeper = ((KeyKeeperRegistry)LicensingEquinox.getLicensingService(KeyKeeperRegistry.class)).getKeyKeeper(configuration);
        this.streamCodec = ((StreamCodecRegistry)LicensingEquinox.getLicensingService(StreamCodecRegistry.class)).getStreamCodec(configuration);
        this.transport = ((ConditionTransportRegistry)LicensingEquinox.getLicensingService(ConditionTransportRegistry.class)).getConditionTransportForContentType("application/xml");
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Import License");
        newShell.setImage(LicensingImages.getImage("IMG_IMPORT"));
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Import license");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(area, 0);
        contents.setLayout((Layout)new GridLayout(1, false));
        contents.setLayoutData((Object)new GridData(1808));
        this.createSelector(contents);
        this.createViewer(contents);
        Dialog.applyDialogFont((Control)area);
        return area;
    }

    protected void createSelector(Composite contents) {
        Composite composite = new Composite(contents, 0);
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 128).create());
        composite.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite, 0);
        label.setText("From licensing file");
        this.sourceText = new Combo(composite, 0);
        this.sourceText.setLayoutData((Object)new GridData(1808));
        this.sourceText.addListener(24, e -> this.handleEvent(e));
        this.sourceButton = new Button(composite, 8);
        this.sourceButton.setText("B&rowse...");
        this.sourceButton.addListener(13, e -> this.handleEvent(e));
        this.setButtonLayoutData(this.sourceButton);
    }

    protected void createViewer(Composite contents) {
        Table tableDetails = new Table(contents, 2048);
        tableDetails.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableViewer = LicensingConditionViewer.createTableViewer(tableDetails);
    }

    protected void handleBrowseButtonPressed() {
        FileDialog dialog = new FileDialog(this.getShell(), 0x10001000);
        dialog.setText("Import from File");
        dialog.setFilterPath(this.sourceText.getText().trim());
        dialog.setFilterExtensions(new String[]{"*.licen", "*.*"});
        String selectedFileName = dialog.open();
        if (selectedFileName != null) {
            this.sourceText.setText(selectedFileName);
        }
    }

    protected void handleEvent(Event e) {
        if (e.widget == this.sourceButton) {
            this.handleBrowseButtonPressed();
        }
        this.updateCompletion();
        this.tableViewer.setInput(this.mined);
    }

    protected void updateCompletion() {
        boolean pageComplete = this.determineCompletion();
        this.mined.clear();
        if (pageComplete) {
            LicensingResult mining = this.mine(this.sourceText.getText().trim());
            this.setMessage(mining.getMessage());
        }
        this.getButton(0).setEnabled(!this.mined.isEmpty());
    }

    protected LicensingResult mine(String pack) {
        String source = ((Object)((Object)this)).getClass().getName();
        Set<String> paths = Collections.singleton(pack);
        return ConditionMiners.mine((String)source, (LicensingConfiguration)this.configuration, this.mined, (KeyKeeper)this.keyKeeper, (StreamCodec)this.streamCodec, (ConditionTransport)this.transport, paths);
    }

    protected boolean determineCompletion() {
        boolean complete = this.validateSourceGroup();
        if (complete) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(this.currentMessage);
        }
        return complete;
    }

    protected boolean validateSourceGroup() {
        if (!this.validSource()) {
            this.currentMessage = "Licensing file does not exist or is a directory.";
            return false;
        }
        return true;
    }

    protected boolean validSource() {
        String source = this.sourceText.getText().trim();
        File fromFile = new File(source);
        return fromFile.exists() && !fromFile.isDirectory();
    }

    protected void okPressed() {
        String source = this.sourceText.getText().trim();
        this.conditionMinerRegistry.importConditions(source, this.configuration);
        super.okPressed();
    }

    protected boolean isResizable() {
        return true;
    }
}

