/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.core;

import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.licenses.LicenseGrantDescriptor;
import org.eclipse.passage.lic.licenses.LicensePackDescriptor;
import org.eclipse.passage.loc.internal.licenses.core.i18n.LicensesCoreMessages;

public class LicenseMail {
    private static final String MAILTO = "mailto:";
    private static final String MAILTO_SUBJECT = "?subject=";
    private static final String MAILTO_BODY = "&body=";
    private static final String MAILTO_SEPARATOR = "%0A";
    private final LicensePackDescriptor licensePack;

    public LicenseMail(LicensePackDescriptor licensePack) {
        this.licensePack = licensePack;
    }

    public String getDetails() {
        return this.getDetails(System.lineSeparator());
    }

    public String getDetails(String separator) {
        if (this.licensePack == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(NLS.bind((String)LicensesCoreMessages.LicenseRequest_request_lbl, (Object)this.licensePack.getRequestIdentifier()));
        builder.append(separator).append(separator);
        builder.append(NLS.bind((String)LicensesCoreMessages.LicenseRequest_plan_lbl, (Object)this.licensePack.getPlanIdentifier()));
        builder.append(separator);
        builder.append(NLS.bind((String)LicensesCoreMessages.LicenseRequest_package_lbl, (Object)this.licensePack.getIdentifier()));
        builder.append(separator);
        builder.append(NLS.bind((String)LicensesCoreMessages.LicenseRequest_product_lbl, (Object)this.licensePack.getProductIdentifier()));
        builder.append(separator);
        builder.append(NLS.bind((String)LicensesCoreMessages.LicenseRequest_product_version_lbl, (Object)this.licensePack.getProductVersion()));
        builder.append(separator);
        for (LicenseGrantDescriptor grant : this.licensePack.getLicenseGrants()) {
            builder.append(NLS.bind((String)LicensesCoreMessages.LicenseRequest_feature_lbl, (Object)grant.getFeatureIdentifier()));
            builder.append(separator);
            String conditionExpression = grant.getConditionExpression();
            if (conditionExpression == null || conditionExpression.isEmpty()) continue;
            builder.append(NLS.bind((String)LicensesCoreMessages.LicenseRequest_condition_expr_lbl, (Object)conditionExpression));
            builder.append(separator);
        }
        builder.append(separator);
        builder.append(NLS.bind((String)LicensesCoreMessages.LicenseRequest_user_lbl, (Object)this.licensePack.getUserIdentifier()));
        builder.append(separator);
        builder.append(NLS.bind((String)LicensesCoreMessages.LicenseRequest_user_name_lbl, (Object)this.licensePack.getUserFullName()));
        builder.append(separator).append(separator);
        builder.append(NLS.bind((String)LicensesCoreMessages.LicenseRequest_issue_date_lbl, (Object)this.licensePack.getIssueDate()));
        builder.append(separator);
        return builder.toString();
    }

    public String getMailTo() {
        StringBuilder builder = new StringBuilder(MAILTO);
        builder.append(this.licensePack.getUserIdentifier());
        builder.append(MAILTO_SUBJECT);
        builder.append(LicensesCoreMessages.LicenseRequest_mailto_subject_lbl);
        builder.append(MAILTO_BODY);
        builder.append(NLS.bind((String)LicensesCoreMessages.LicenseRequest_mailto_appeal_lbl, (Object)this.licensePack.getUserFullName()));
        builder.append(MAILTO_SEPARATOR);
        builder.append(LicensesCoreMessages.LicenseRequest_mailto_body_base_lbl);
        builder.append(MAILTO_SEPARATOR).append(MAILTO_SEPARATOR);
        builder.append(LicensesCoreMessages.LicenseRequest_mailto_body_details_lbl);
        builder.append(MAILTO_SEPARATOR);
        builder.append(this.getDetails(MAILTO_SEPARATOR));
        return builder.toString();
    }
}

