/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.features.core;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.api.LicensingReporter;
import org.eclipse.passage.lic.base.LicensingResults;
import org.eclipse.passage.lic.emf.ecore.DomainContentAdapter;
import org.eclipse.passage.lic.emf.ecore.EditingDomainRegistry;
import org.eclipse.passage.lic.emf.edit.BaseDomainRegistry;
import org.eclipse.passage.lic.emf.edit.ComposedAdapterFactoryProvider;
import org.eclipse.passage.lic.equinox.io.EquinoxPaths;
import org.eclipse.passage.lic.features.FeatureDescriptor;
import org.eclipse.passage.lic.features.FeatureSetDescriptor;
import org.eclipse.passage.lic.features.FeatureVersionDescriptor;
import org.eclipse.passage.lic.features.model.meta.FeaturesPackage;
import org.eclipse.passage.lic.features.registry.FeatureRegistry;
import org.eclipse.passage.loc.internal.features.core.FeaturesDomainRegistryTracker;
import org.eclipse.passage.loc.internal.features.core.i18n.FeaturesCoreMessages;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"org.eclipse.passage.lic.emf.edit.domain.name=features", "org.eclipse.passage.lic.emf.edit.file.extension=features_xmi"})
public class FeatureDomainRegistry
extends BaseDomainRegistry<FeatureSetDescriptor>
implements FeatureRegistry,
EditingDomainRegistry<FeatureSetDescriptor> {
    private final Map<String, FeatureSetDescriptor> featureSetIndex = new HashMap<String, FeatureSetDescriptor>();
    private final Map<String, FeatureDescriptor> featureIndex = new HashMap<String, FeatureDescriptor>();
    private final Map<String, Map<String, FeatureVersionDescriptor>> featureVersionIndex = new HashMap<String, Map<String, FeatureVersionDescriptor>>();

    @Reference
    public void bindLicensingReporter(LicensingReporter admin) {
        super.bindLicensingReporter(admin);
    }

    public void unbindLicensingReporter(LicensingReporter admin) {
        super.unbindLicensingReporter(admin);
    }

    @Reference
    public void bindFactoryProvider(ComposedAdapterFactoryProvider factoryProvider) {
        super.bindFactoryProvider(factoryProvider);
    }

    public void unbindFactoryProvider(ComposedAdapterFactoryProvider factoryProvider) {
        super.unbindFactoryProvider(factoryProvider);
    }

    @Activate
    public void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    @Deactivate
    public void deactivate(Map<String, Object> properties) {
        Collection<Map<String, FeatureVersionDescriptor>> values = this.featureVersionIndex.values();
        for (Map<String, FeatureVersionDescriptor> map : values) {
            map.clear();
        }
        this.featureVersionIndex.clear();
        this.featureIndex.clear();
        this.featureSetIndex.clear();
        super.deactivate(properties);
    }

    public String getFileExtension() {
        return "features_xmi";
    }

    public Class<FeatureSetDescriptor> getContentClass() {
        return FeatureSetDescriptor.class;
    }

    public String resolveIdentifier(FeatureSetDescriptor content) {
        return content.getIdentifier();
    }

    public Iterable<? extends FeatureSetDescriptor> getFeatureSets() {
        return new ArrayList<FeatureSetDescriptor>(this.featureSetIndex.values());
    }

    public FeatureSetDescriptor getFeatureSet(String identifier) {
        return this.featureSetIndex.get(identifier);
    }

    public Iterable<? extends FeatureDescriptor> getFeatures() {
        return new ArrayList<FeatureDescriptor>(this.featureIndex.values());
    }

    public Iterable<? extends FeatureDescriptor> getFeatures(String featureSetId) {
        FeatureSetDescriptor featureSet = this.featureSetIndex.get(featureSetId);
        if (featureSet == null) {
            return Collections.emptyList();
        }
        ArrayList features = new ArrayList();
        featureSet.getFeatures().forEach(features::add);
        return features;
    }

    public FeatureDescriptor getFeature(String identifier) {
        return this.featureIndex.get(identifier);
    }

    public Iterable<? extends FeatureVersionDescriptor> getFeatureVersions() {
        ArrayList<FeatureVersionDescriptor> list = new ArrayList<FeatureVersionDescriptor>();
        Collection<Map<String, FeatureVersionDescriptor>> values = this.featureVersionIndex.values();
        for (Map<String, FeatureVersionDescriptor> map : values) {
            list.addAll(map.values());
        }
        return list;
    }

    public Iterable<? extends FeatureVersionDescriptor> getFeatureVersions(String featureId) {
        Map<String, FeatureVersionDescriptor> map = this.featureVersionIndex.get(featureId);
        if (map == null) {
            return Collections.emptyList();
        }
        return new ArrayList<FeatureVersionDescriptor>(map.values());
    }

    public FeatureVersionDescriptor getFeatureVersion(String featureId, String version) {
        Map<String, FeatureVersionDescriptor> map = this.featureVersionIndex.get(featureId);
        if (map == null) {
            return null;
        }
        return map.get(version);
    }

    protected DomainContentAdapter<FeatureSetDescriptor, FeatureDomainRegistry> createContentAdapter() {
        return new FeaturesDomainRegistryTracker(this);
    }

    public void registerFeatureSet(FeatureSetDescriptor featureSet) {
        String identifier = featureSet.getIdentifier();
        FeatureSetDescriptor existing = this.featureSetIndex.put(identifier, featureSet);
        if (existing != null) {
            String msg = NLS.bind((String)FeaturesCoreMessages.FeatureDomain_instance_duplication_message, (Object)existing, (Object)featureSet);
            this.licensingReporter.logResult(LicensingResults.createWarning((String)msg, ((Object)((Object)this)).getClass(), null));
        }
        this.licensingReporter.postResult(LicensingResults.createEvent((String)"org/eclipse/passage/lic/features/registry/FeatureSet/create", (Object)featureSet));
        Iterable features = featureSet.getFeatures();
        for (FeatureDescriptor feature : features) {
            this.registerFeature(feature);
        }
    }

    public void registerFeature(FeatureDescriptor feature) {
        String identifier = feature.getIdentifier();
        FeatureDescriptor existing = this.featureIndex.put(identifier, feature);
        if (existing != null) {
            String msg = NLS.bind((String)FeaturesCoreMessages.FeatureDomain_instance_duplication_message, (Object)existing, (Object)feature);
            this.licensingReporter.logResult(LicensingResults.createWarning((String)msg, ((Object)((Object)this)).getClass(), null));
        }
        this.licensingReporter.postResult(LicensingResults.createEvent((String)"org/eclipse/passage/lic/features/registry/Feature/create", (Object)feature));
        Iterable featureVersions = feature.getFeatureVersions();
        for (FeatureVersionDescriptor featureVersion : featureVersions) {
            this.registerFeatureVersion(feature, featureVersion);
        }
    }

    public void registerFeatureVersion(FeatureDescriptor feature, FeatureVersionDescriptor featureVersion) {
        String version;
        String identifier = feature.getIdentifier();
        Map map = this.featureVersionIndex.computeIfAbsent(identifier, key -> new HashMap());
        FeatureVersionDescriptor existing = map.put(version = featureVersion.getVersion(), featureVersion);
        if (existing != null) {
            String msg = NLS.bind((String)FeaturesCoreMessages.FeatureDomain_instance_duplication_message, (Object)existing, (Object)featureVersion);
            this.licensingReporter.logResult(LicensingResults.createWarning((String)msg, ((Object)((Object)this)).getClass(), null));
        }
        this.licensingReporter.postResult(LicensingResults.createEvent((String)"org/eclipse/passage/lic/features/registry/FeatureVersion/create", (Object)featureVersion));
    }

    public void unregisterFeatureSet(String featureSetId) {
        FeatureSetDescriptor removed = this.featureSetIndex.remove(featureSetId);
        if (removed != null) {
            this.licensingReporter.postResult(LicensingResults.createEvent((String)"org/eclipse/passage/lic/features/registry/FeatureSet/delete", (Object)removed));
            Iterable features = removed.getFeatures();
            for (FeatureDescriptor feature : features) {
                this.unregisterFeature(feature.getIdentifier());
            }
        }
    }

    public void unregisterFeature(String featureId) {
        FeatureDescriptor removed = this.featureIndex.remove(featureId);
        if (removed != null) {
            this.licensingReporter.postResult(LicensingResults.createEvent((String)"org/eclipse/passage/lic/features/registry/Feature/delete", (Object)removed));
            Iterable featureVersions = removed.getFeatureVersions();
            for (FeatureVersionDescriptor featureVersion : featureVersions) {
                this.unregisterFeatureVersion(featureId, featureVersion.getVersion());
            }
        }
    }

    public void unregisterFeatureVersion(String featureId, String version) {
        Map<String, FeatureVersionDescriptor> map = this.featureVersionIndex.get(featureId);
        if (map != null) {
            FeatureVersionDescriptor removed = map.remove(version);
            if (removed != null) {
                this.licensingReporter.postResult(LicensingResults.createEvent((String)"org/eclipse/passage/lic/features/registry/FeatureVersion/delete", (Object)removed));
            }
            if (map.isEmpty()) {
                this.featureVersionIndex.remove(version);
            }
        }
    }

    public EClass getContentClassifier() {
        return FeaturesPackage.eINSTANCE.getFeatureSet();
    }

    public EStructuralFeature getContentIdentifierAttribute() {
        return FeaturesPackage.eINSTANCE.getFeatureSet_Identifier();
    }

    public EStructuralFeature getContentNameAttribute() {
        return FeaturesPackage.eINSTANCE.getFeatureSet_Name();
    }

    public void registerContent(FeatureSetDescriptor content) {
        this.registerFeatureSet(content);
    }

    public void unregisterContent(String identifier) {
        this.unregisterFeatureSet(identifier);
    }

    protected Path getResourceSetPath() throws Exception {
        Path passagePath = EquinoxPaths.resolveInstallBasePath();
        Files.createDirectories(passagePath, new FileAttribute[0]);
        return passagePath.resolve(this.domainName);
    }
}

