/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.bc;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPKeyRingGenerator;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyPair;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyEncryptorBuilder;
import org.eclipse.passage.lic.api.LicensingConfiguration;
import org.eclipse.passage.lic.api.io.StreamCodec;
import org.eclipse.passage.lic.base.LicensingConfigurations;
import org.eclipse.passage.lic.bc.BcProperties;
import org.eclipse.passage.lic.internal.bc.i18n.BcMessages;
import org.osgi.service.component.annotations.Activate;

public class BcStreamCodec
implements StreamCodec {
    private static final long EXPIRATION_TIME = 1000L;
    private String keyAlgo = "RSA";
    private int keySize = 1024;
    private int hashAlgo = 10;
    private LicensingConfiguration configuration = LicensingConfigurations.INVALID;

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    @Activate
    public void activate(Map<String, Object> properties) {
        this.configuration = LicensingConfigurations.create(properties);
        this.keyAlgo = BcProperties.extractKeyAlgo(properties);
        this.keySize = BcProperties.extractKeySize(properties);
    }

    public String getKeyAlgo() {
        return this.keyAlgo;
    }

    public int getKeySize() {
        return this.keySize;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createKeyPair(String publicKeyPath, String privateKeyPath, String username, String password) throws IOException {
        Object output;
        PGPKeyRingGenerator keyRingGen;
        block31: {
            JcaPGPContentSignerBuilder certificationSignerBuilder2;
            Object pgpKeyPair;
            try {
                KeyPairGenerator generator = KeyPairGenerator.getInstance(this.keyAlgo, "BC");
                generator.initialize(this.keySize);
                KeyPair keyPair = generator.generateKeyPair();
                PGPDigestCalculator sha1Calc = new JcaPGPDigestCalculatorProviderBuilder().build().get(2);
                pgpKeyPair = new JcaPGPKeyPair(1, keyPair, new Date());
                certificationSignerBuilder2 = new JcaPGPContentSignerBuilder(pgpKeyPair.getPublicKey().getAlgorithm(), 2);
                JcePBESecretKeyEncryptorBuilder jcePBESecretKeyEncryptorBuilder = new JcePBESecretKeyEncryptorBuilder(3, sha1Calc);
                PBESecretKeyEncryptor secretKeyEcriptor = jcePBESecretKeyEncryptorBuilder.setProvider("BC").build(password.toCharArray());
                PGPSignatureSubpacketGenerator subpacketGenerator = new PGPSignatureSubpacketGenerator();
                PGPSignatureSubpacketVector subpacketVector = null;
                subpacketGenerator.setKeyExpirationTime(false, 1000L);
                subpacketVector = subpacketGenerator.generate();
                keyRingGen = new PGPKeyRingGenerator(19, (PGPKeyPair)pgpKeyPair, username, sha1Calc, subpacketVector, null, (PGPContentSignerBuilder)certificationSignerBuilder2, secretKeyEcriptor);
                keyRingGen.addSubKey((PGPKeyPair)pgpKeyPair);
            }
            catch (NoSuchAlgorithmException | NoSuchProviderException | PGPException e) {
                throw new IOException(BcMessages.getString("BcStreamCodec_create_keys_error_ring"), e);
            }
            Path pathPrivateKey = Paths.get(privateKeyPath, new String[0]);
            PGPSecretKeyRing keyRingSecret = keyRingGen.generateSecretKeyRing();
            File privateKey = pathPrivateKey.toFile();
            try {
                pgpKeyPair = null;
                certificationSignerBuilder2 = null;
                try {
                    FileOutputStream fos = new FileOutputStream(privateKey);
                    try {
                        output = new ArmoredOutputStream((OutputStream)new BufferedOutputStream(fos));
                        try {
                            keyRingSecret.encode((OutputStream)output);
                        }
                        finally {
                            if (output != null) {
                                output.close();
                            }
                        }
                        if (fos == null) break block31;
                    }
                    catch (Throwable certificationSignerBuilder2) {
                        if (pgpKeyPair == null) {
                            pgpKeyPair = certificationSignerBuilder2;
                        } else if (pgpKeyPair != certificationSignerBuilder2) {
                            ((Throwable)pgpKeyPair).addSuppressed(certificationSignerBuilder2);
                        }
                        if (fos == null) throw pgpKeyPair;
                        fos.close();
                        throw pgpKeyPair;
                    }
                    fos.close();
                }
                catch (Throwable certificationSignerBuilder2) {
                    if (pgpKeyPair == null) {
                        pgpKeyPair = certificationSignerBuilder2;
                        throw pgpKeyPair;
                    }
                    if (pgpKeyPair == certificationSignerBuilder2) throw pgpKeyPair;
                    ((Throwable)pgpKeyPair).addSuppressed(certificationSignerBuilder2);
                    throw pgpKeyPair;
                }
            }
            catch (IOException e) {
                throw new IOException(BcMessages.getString("BcStreamCodec_create_keys_error_private"), e);
            }
        }
        Path pathPublicKey = Paths.get(publicKeyPath, new String[0]);
        PGPPublicKeyRing keyRingPublic = keyRingGen.generatePublicKeyRing();
        File publicKey = pathPublicKey.toFile();
        try {
            output = null;
            Object var13_19 = null;
            try {
                FileOutputStream fos = new FileOutputStream(publicKey);
                try {
                    try (ArmoredOutputStream output2 = new ArmoredOutputStream((OutputStream)new BufferedOutputStream(fos));){
                        keyRingPublic.encode((OutputStream)output2);
                    }
                    if (fos == null) return;
                }
                catch (Throwable throwable) {
                    if (output == null) {
                        output = throwable;
                    } else if (output != throwable) {
                        ((Throwable)output).addSuppressed(throwable);
                    }
                    if (fos == null) throw output;
                    fos.close();
                    throw output;
                }
                fos.close();
                return;
            }
            catch (Throwable throwable) {
                if (output == null) {
                    output = throwable;
                    throw output;
                }
                if (output == throwable) throw output;
                ((Throwable)output).addSuppressed(throwable);
                throw output;
            }
        }
        catch (IOException e) {
            throw new IOException(BcMessages.getString("BcStreamCodec_create_keys_error_public"), e);
        }
    }

    public void encodeStream(InputStream input, OutputStream output, InputStream keyRing, String username, String password) throws IOException {
        PGPSecretKey key = BcStreamCodec.findKey(keyRing, username);
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (ArmoredOutputStream aos = new ArmoredOutputStream(output);){
                PGPCompressedDataGenerator generator = new PGPCompressedDataGenerator(2);
                Throwable throwable2 = null;
                Object var12_17 = null;
                try (BCPGOutputStream generated = new BCPGOutputStream(generator.open((OutputStream)aos));){
                    JcaPGPContentSignerBuilder csBuilder = new JcaPGPContentSignerBuilder(key.getPublicKey().getAlgorithm(), this.hashAlgo);
                    PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)csBuilder);
                    PGPDigestCalculatorProvider calcProvider = new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build();
                    PBESecretKeyDecryptor decryptor = new JcePBESecretKeyDecryptorBuilder(calcProvider).setProvider("BC").build(password.toCharArray());
                    PGPPrivateKey privateKey = key.extractPrivateKey(decryptor);
                    signatureGenerator.init(0, privateKey);
                    Iterator it = key.getPublicKey().getUserIDs();
                    if (it.hasNext()) {
                        PGPSignatureSubpacketGenerator generator1 = new PGPSignatureSubpacketGenerator();
                        generator1.setSignerUserID(false, (String)it.next());
                        signatureGenerator.setHashedSubpackets(generator1.generate());
                    }
                    signatureGenerator.generateOnePassVersion(false).encode((OutputStream)generated);
                    BcStreamCodec.updateSignatureGenerator(input, generated, signatureGenerator);
                    signatureGenerator.generate().encode((OutputStream)generated);
                    generator.close();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException | PGPException e) {
            String message = String.format(BcMessages.getString("BcStreamCodec_enconde_error"), this.configuration);
            throw new IOException(message, e);
        }
    }

    private static void updateSignatureGenerator(InputStream input, BCPGOutputStream generated, PGPSignatureGenerator signatureGenerator) throws IOException {
        PGPLiteralDataGenerator literalDataGenerator = new PGPLiteralDataGenerator();
        Throwable throwable = null;
        Object var5_6 = null;
        try (OutputStream literalDataStream = literalDataGenerator.open((OutputStream)generated, 'b', "ignored", new Date(), new byte[1024]);){
            int ch;
            while ((ch = input.read()) >= 0) {
                literalDataStream.write(ch);
                signatureGenerator.update((byte)ch);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        literalDataGenerator.close();
    }

    private static PGPSecretKey findKey(InputStream key, String username) throws IOException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream decoder = PGPUtil.getDecoderStream((InputStream)key);){
                JcaPGPSecretKeyRingCollection keyRingCollection = new JcaPGPSecretKeyRingCollection(decoder);
                Iterator keyRings = keyRingCollection.getKeyRings();
                while (keyRings.hasNext()) {
                    PGPSecretKeyRing keyRing = (PGPSecretKeyRing)keyRings.next();
                    Iterator secretKeys = keyRing.getSecretKeys();
                    PGPSecretKey found = BcStreamCodec.findKey(secretKeys, username);
                    if (found == null) continue;
                    return found;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | PGPException e) {
            throw new IOException(BcMessages.getString("BcStreamCodec_encode_error_no_key"), e);
        }
        throw new IOException(BcMessages.getString("BcStreamCodec_encode_error_no_key"));
    }

    private static PGPSecretKey findKey(Iterator<PGPSecretKey> secretKeys, String username) {
        while (secretKeys.hasNext()) {
            PGPSecretKey secretKey = secretKeys.next();
            if (!secretKey.isSigningKey()) continue;
            Iterator userIDs = secretKey.getUserIDs();
            while (userIDs.hasNext()) {
                Object next = userIDs.next();
                if (!Objects.equals(username, next)) continue;
                return secretKey;
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public Object decodeStream(InputStream input, OutputStream output, InputStream key, byte[] digest) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

