/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.workbench;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.passage.lic.emf.ecore.EditingDomainRegistry;
import org.eclipse.passage.lic.emf.edit.EditingDomainRegistryAccess;
import org.eclipse.passage.lic.emf.edit.SelectionCommandAdvisor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class LocDomainRegistryAccess
implements EditingDomainRegistryAccess {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, EditingDomainRegistry<?>> domainRegistries = new HashMap();
    private final Map<String, String> domain2extension = new HashMap<String, String>();
    private final Map<String, String> extension2domain = new HashMap<String, String>();
    private final Map<String, SelectionCommandAdvisor> selectionAdvisors = new HashMap<String, SelectionCommandAdvisor>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE)
    public void registerEditingDomainRegistry(EditingDomainRegistry<?> instance, Map<String, Object> properties) {
        String domain = String.valueOf(properties.get("org.eclipse.passage.lic.emf.edit.domain.name"));
        this.registerEntry(this.domainRegistries, domain, instance);
        String extension = String.valueOf(properties.get("org.eclipse.passage.lic.emf.edit.file.extension"));
        this.registerEntry(this.domain2extension, domain, extension);
        this.registerEntry(this.extension2domain, extension, domain);
    }

    public void unregisterEditingDomainRegistry(EditingDomainRegistry<?> instance, Map<String, Object> properties) {
        String domain = String.valueOf(properties.get("org.eclipse.passage.lic.emf.edit.domain.name"));
        this.unregisterEntry(this.domainRegistries, domain, instance);
        String extension = String.valueOf(properties.get("org.eclipse.passage.lic.emf.edit.file.extension"));
        this.unregisterEntry(this.domain2extension, domain, extension);
        this.unregisterEntry(this.extension2domain, extension, domain);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE)
    public void registerCommandAdvisor(SelectionCommandAdvisor instance, Map<String, Object> properties) {
        String domain = String.valueOf(properties.get("org.eclipse.passage.lic.emf.edit.domain.name"));
        this.registerEntry(this.selectionAdvisors, domain, instance);
    }

    public void unregisterCommandAdvisor(SelectionCommandAdvisor instance, Map<String, Object> properties) {
        String domain = String.valueOf(properties.get("org.eclipse.passage.lic.emf.edit.domain.name"));
        this.unregisterEntry(this.selectionAdvisors, domain, instance);
    }

    protected <K, V> void registerEntry(Map<K, V> map, K key, V value) {
        V existing = map.put(key, value);
        if (existing != null) {
            this.logger.warn("Replaced {} for domain {}", existing, key);
        }
        this.logger.trace("Registered {} for domain {}", value, key);
    }

    protected <K, V> void unregisterEntry(Map<K, V> map, K key, V value) {
        V existing = map.remove(key);
        if (existing == null) {
            this.logger.warn("Unexpected null (should be {}) for domain {}", value, key);
        }
        this.logger.trace("Unregistered {} for domain {}", existing, key);
    }

    public EditingDomainRegistry<?> getDomainRegistry(String domain) {
        return this.domainRegistries.get(domain);
    }

    public String getFileExtension(String domain) {
        return this.domain2extension.get(domain);
    }

    public SelectionCommandAdvisor getSelectionCommandAdvisor(String domain) {
        return this.selectionAdvisors.get(domain);
    }

    public Optional<String> domainForExtension(String extension) {
        return Optional.ofNullable(this.extension2domain.get(extension));
    }

    public Optional<EditingDomainRegistry<?>> domainRegistryForExtension(String extension) {
        return this.domainForExtension(extension).flatMap(d -> Optional.ofNullable(this.domainRegistries.get(d)));
    }

    public List<EditingDomainRegistry<?>> domainRegistryList() {
        return new ArrayList(this.domainRegistries.values());
    }
}

