/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.conditions.mining;

import java.nio.file.Path;
import java.util.Collection;
import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.conditions.ConditionPack;
import org.eclipse.passage.lic.internal.api.conditions.mining.LicenseReadingService;
import org.eclipse.passage.lic.internal.api.registry.StringServiceId;
import org.eclipse.passage.lic.internal.base.conditions.mining.LocalConditions;
import org.eclipse.passage.lic.internal.base.conditions.mining.MiningEquipment;

public final class BaseLicenseReadingService
implements LicenseReadingService {
    private final LicensedProduct product;
    private final MiningEquipment equipment;

    public BaseLicenseReadingService(LicensedProduct product, MiningEquipment equipment) {
        this.product = product;
        this.equipment = equipment;
    }

    public LicensedProduct id() {
        return this.product;
    }

    public ServiceInvocationResult<Collection<ConditionPack>> read(Path license) {
        return new OnTheFlyConditions(license, this.equipment).all(this.product);
    }

    private static final class OnTheFlyConditions
    extends LocalConditions {
        private final Path license;

        private OnTheFlyConditions(Path license, MiningEquipment equipment) {
            super(new StringServiceId("on-the-fly"), equipment);
            this.license = license;
        }

        @Override
        protected Supplier<Path> base(LicensedProduct product) {
            return () -> this.license;
        }
    }
}

