/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.workbench.handlers;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.passage.lic.emf.edit.LabeledDiagnostician;
import org.eclipse.swt.widgets.Shell;

public class ValidateHandler {
    @Execute
    public void execute(ESelectionService selectionService, Shell shell, IEclipseContext context) {
        Object selection = selectionService.getSelection();
        if (selection instanceof EObject) {
            EObject eObject = (EObject)selection;
            LabeledDiagnostician diagnostician = new LabeledDiagnostician();
            Diagnostic validate = diagnostician.validate(eObject);
            this.handleDiagnostic(validate, shell);
        }
    }

    @CanExecute
    public boolean canExecute(ESelectionService selectionService) {
        Object selection = selectionService.getSelection();
        return selection instanceof EObject;
    }

    protected void handleDiagnostic(Diagnostic diagnostic, Shell shell) {
        int severity = diagnostic.getSeverity();
        String title = null;
        String message = null;
        if (severity == 4 || severity == 2) {
            title = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationProblems_title");
            message = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationProblems_message");
        } else {
            title = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationResults_title");
            message = EMFEditUIPlugin.INSTANCE.getString(severity == 0 ? "_UI_ValidationOK_message" : "_UI_ValidationResults_message");
        }
        if (diagnostic.getSeverity() == 0) {
            MessageDialog.openInformation((Shell)shell, (String)title, (String)message);
        } else {
            IStatus status = BasicDiagnostic.toIStatus((Diagnostic)diagnostic);
            ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
        }
    }
}

