/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import oshi.hardware.common.AbstractComputerSystem;
import oshi.hardware.platform.linux.LinuxBaseboard;
import oshi.hardware.platform.linux.LinuxFirmware;
import oshi.util.ExecutingCommand;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;

final class LinuxComputerSystem
extends AbstractComputerSystem {
    private static final long serialVersionUID = 1L;
    private static final String SYSFS_SERIAL_PATH = "/sys/devices/virtual/dmi/id/";
    private static final String UNKNOWN = "unknown";

    LinuxComputerSystem() {
        this.init();
    }

    private void init() {
        String sysVendor = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/sys_vendor");
        if (sysVendor != null && !sysVendor.trim().isEmpty()) {
            this.setManufacturer(sysVendor.trim());
        }
        String productName = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/product_name");
        String productVersion = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/product_version");
        if (productName != null && !productName.trim().isEmpty()) {
            if (productVersion != null && !productVersion.trim().isEmpty() && !"None".equals(productVersion.trim())) {
                this.setModel(productName.trim() + " (version: " + productVersion.trim() + ")");
            } else {
                this.setModel(productName.trim());
            }
        } else if (productVersion != null && !productVersion.trim().isEmpty()) {
            this.setModel(productVersion.trim());
        }
        this.setSerialNumber(this.getSystemSerialNumber());
        this.setFirmware(new LinuxFirmware());
        this.setBaseboard(new LinuxBaseboard());
    }

    private String getSystemSerialNumber() {
        String serialNumber = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/product_serial");
        if ((serialNumber.isEmpty() || "None".equals(serialNumber)) && ((serialNumber = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/board_serial")).isEmpty() || "None".equals(serialNumber))) {
            serialNumber = UNKNOWN;
        }
        String marker = "Serial Number:";
        if (UNKNOWN.equals(serialNumber)) {
            for (String checkLine : ExecutingCommand.runNative("dmidecode -t system")) {
                if (!checkLine.contains(marker)) continue;
                serialNumber = checkLine.split(marker)[1].trim();
                break;
            }
        }
        if (UNKNOWN.equals(serialNumber)) {
            marker = "system.hardware.serial =";
            for (String checkLine : ExecutingCommand.runNative("lshal")) {
                if (!checkLine.contains(marker)) continue;
                serialNumber = ParseUtil.getSingleQuoteStringValue(checkLine);
                break;
            }
        }
        return serialNumber;
    }
}

