/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.wizards.license;

import java.time.LocalDate;
import java.util.Optional;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.passage.lic.internal.api.MandatoryService;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.SelectableField;
import org.eclipse.passage.loc.internal.dashboard.ui.i18n.IssueLicensePageMessages;
import org.eclipse.passage.loc.jface.dialogs.DateDialog;
import org.eclipse.swt.widgets.Text;

public final class DateField
extends SelectableField<LocalDate> {
    private final String name;

    DateField(LocalDate initial, String name, Runnable modified, LabelProvider labels, MandatoryService context) {
        super(Optional.of(initial), modified, labels, context);
        this.name = name;
    }

    @Override
    protected String label() {
        return this.name;
    }

    @Override
    protected String errorText() {
        return String.format(IssueLicensePageMessages.IssueLicenseRequestPage_e_no_date, this.name);
    }

    @Override
    protected Optional<LocalDate> select(Text control) {
        LocalDate current = (LocalDate)this.source.get();
        Object data = control.getData();
        if (data instanceof LocalDate) {
            current = (LocalDate)data;
        }
        DateDialog dialog = new DateDialog(this.shell(), current);
        dialog.create();
        dialog.getShell().setText(this.name);
        if (dialog.open() == 0) {
            current = dialog.getSelected();
            control.setData((Object)current);
        }
        return Optional.of(current);
    }
}

