/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.access;

import org.eclipse.passage.lic.internal.api.Framework;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.access.GrantLockAttempt;
import org.eclipse.passage.lic.internal.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.internal.api.diagnostic.Trouble;
import org.eclipse.passage.lic.internal.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.internal.api.restrictions.ExaminationCertificate;
import org.eclipse.passage.lic.internal.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.internal.base.access.Allow;
import org.eclipse.passage.lic.internal.base.access.Assess;
import org.eclipse.passage.lic.internal.base.access.BaseGrantLockAttempt;
import org.eclipse.passage.lic.internal.base.access.Lock;
import org.eclipse.passage.lic.internal.base.diagnostic.BaseDiagnostic;
import org.eclipse.passage.lic.internal.base.diagnostic.SumOfDiagnostics;
import org.eclipse.passage.lic.internal.base.diagnostic.code.NoRequirements;
import org.eclipse.passage.lic.internal.base.restrictions.CertificateIsRestrictive;

public final class Access {
    private final Framework framework;

    public Access(Framework framework) {
        this.framework = framework;
    }

    public boolean canUse(String feature) {
        return (Boolean)new Allow(this.framework, feature).apply();
    }

    public ServiceInvocationResult<ExaminationCertificate> assess() {
        return (ServiceInvocationResult)new Assess(this.framework).apply();
    }

    public ServiceInvocationResult<GrantLockAttempt> acquire(String feature) {
        ServiceInvocationResult certificate = (ServiceInvocationResult)new Assess(this.framework, feature).apply();
        if (new CertificateIsRestrictive().test(certificate.data())) {
            return this.failOnAccess((ServiceInvocationResult<ExaminationCertificate>)certificate);
        }
        if (this.empty((ExaminationCertificate)certificate.data().get())) {
            return this.unknownFeature(feature, certificate.diagnostic());
        }
        ServiceInvocationResult<GrantLockAttempt> lock = new Lock(this.framework).lock((ExaminationCertificate)certificate.data().get());
        return new BaseServiceInvocationResult<GrantLockAttempt>(new SumOfDiagnostics().apply(certificate.diagnostic(), lock.diagnostic()), lock.data());
    }

    public ServiceInvocationResult<Boolean> release(GrantLockAttempt lock) {
        return new Lock(this.framework).unlock(lock);
    }

    private ServiceInvocationResult<GrantLockAttempt> failOnAccess(ServiceInvocationResult<ExaminationCertificate> assessment) {
        if (assessment.data().isPresent()) {
            return new BaseServiceInvocationResult<GrantLockAttempt>(assessment.diagnostic(), new BaseGrantLockAttempt.Failed((ExaminationCertificate)assessment.data().get()));
        }
        return new BaseServiceInvocationResult<GrantLockAttempt>(assessment.diagnostic());
    }

    private ServiceInvocationResult<GrantLockAttempt> unknownFeature(String feature, Diagnostic diagnostic) {
        return new BaseServiceInvocationResult<GrantLockAttempt>(new SumOfDiagnostics().apply(diagnostic, new BaseDiagnostic(new Trouble((TroubleCode)new NoRequirements(), feature))));
    }

    private boolean empty(ExaminationCertificate certificate) {
        return certificate.restrictions().isEmpty() && certificate.satisfied().isEmpty();
    }
}

